/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.CaseTermQuery;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DefaultQueryHits;
import org.apache.jackrabbit.core.query.lucene.DescendantSelfAxisQuery;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.LocalNameRangeQuery;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.MatchAllDocsQuery;
import org.apache.jackrabbit.core.query.lucene.MatchAllQuery;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NameQuery;
import org.apache.jackrabbit.core.query.lucene.NameRangeQuery;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NotQuery;
import org.apache.jackrabbit.core.query.lucene.QueryHitsQuery;
import org.apache.jackrabbit.core.query.lucene.RangeQuery;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.apache.jackrabbit.core.query.lucene.Transformable;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.WildcardQuery;
import org.apache.jackrabbit.core.query.lucene.fulltext.QueryParser;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.QueryObjectModelConstants;
import org.apache.jackrabbit.spi.commons.query.qom.AndImpl;
import org.apache.jackrabbit.spi.commons.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ColumnImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ComparisonImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ConstraintImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DescendantNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DescendantNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DynamicOperandImpl;
import org.apache.jackrabbit.spi.commons.query.qom.EquiJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchImpl;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchScoreImpl;
import org.apache.jackrabbit.spi.commons.query.qom.JoinImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LengthImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LiteralImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LowerCaseImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NodeLocalNameImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NodeNameImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NotImpl;
import org.apache.jackrabbit.spi.commons.query.qom.OrImpl;
import org.apache.jackrabbit.spi.commons.query.qom.OrderingImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyExistenceImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.spi.commons.query.qom.SameNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SameNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;
import org.apache.jackrabbit.spi.commons.query.qom.StaticOperandImpl;
import org.apache.jackrabbit.spi.commons.query.qom.UpperCaseImpl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JQOM2LuceneQueryBuilder
implements QOMTreeVisitor,
QueryObjectModelConstants {
    private static final Logger log = LoggerFactory.getLogger((Class)JQOM2LuceneQueryBuilder.class);
    private final QueryObjectModelTree qomTree;
    private final SessionImpl session;
    private final ItemStateManager ism;
    private final HierarchyManager hmgr;
    private final NamespaceMappings nsMappings;
    private final NamePathResolver npResolver;
    private final Analyzer analyzer;
    private final PropertyTypeRegistry propRegistry;
    private final SynonymProvider synonymProvider;
    private final Map bindVariableValues;
    private final Map selectors = new HashMap();
    private final IndexFormatVersion version;

    private JQOM2LuceneQueryBuilder(QueryObjectModelTree qomTree, SessionImpl session, ItemStateManager ism, HierarchyManager hmgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, Map bindVariableValues, IndexFormatVersion version) {
        this.qomTree = qomTree;
        this.session = session;
        this.ism = ism;
        this.hmgr = hmgr;
        this.nsMappings = nsMappings;
        this.npResolver = NamePathResolverImpl.create(nsMappings);
        this.analyzer = analyzer;
        this.propRegistry = propReg;
        this.synonymProvider = synonymProvider;
        this.bindVariableValues = bindVariableValues;
        this.version = version;
    }

    public static Query createQuery(QueryObjectModelTree qomTree, SessionImpl session, ItemStateManager sharedItemMgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, Map bindVariableValues, IndexFormatVersion version) throws RepositoryException {
        HierarchyManagerImpl hmgr = new HierarchyManagerImpl(RepositoryImpl.ROOT_NODE_ID, sharedItemMgr);
        JQOM2LuceneQueryBuilder builder = new JQOM2LuceneQueryBuilder(qomTree, session, sharedItemMgr, hmgr, nsMappings, analyzer, propReg, synonymProvider, bindVariableValues, version);
        return builder.createLuceneQuery();
    }

    private Query createLuceneQuery() throws InvalidQueryException {
        try {
            return (Query)this.qomTree.accept((QOMTreeVisitor)this, null);
        }
        catch (InvalidQueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public Object visit(AndImpl node, Object data) throws Exception {
        BooleanQuery b = new BooleanQuery();
        b.add((Query)((ConstraintImpl)node.getConstraint1()).accept((QOMTreeVisitor)this, data), BooleanClause.Occur.MUST);
        b.add((Query)((ConstraintImpl)node.getConstraint2()).accept((QOMTreeVisitor)this, data), BooleanClause.Occur.MUST);
        return b;
    }

    public Object visit(BindVariableValueImpl node, Object data) throws InvalidQueryException {
        Value v = (Value)this.bindVariableValues.get(node.getBindVariableQName());
        if (v == null) {
            throw new InvalidQueryException("No value bound for variable " + node.getBindVariableName());
        }
        return v;
    }

    public Object visit(ChildNodeImpl node, Object data) {
        Name ntName = this.qomTree.getSelector(node.getSelectorQName()).getNodeTypeQName();
        ArrayList<ScoreNode> scoreNodes = new ArrayList<ScoreNode>();
        try {
            Node parent = this.session.getNode(node.getPath());
            NodeIterator it = parent.getNodes();
            while (it.hasNext()) {
                NodeImpl n = (NodeImpl)it.nextNode();
                if (!n.isNodeType(ntName)) continue;
                scoreNodes.add(new ScoreNode(n.getNodeId(), 1.0f));
            }
            return new QueryHitsQuery(new DefaultQueryHits(scoreNodes));
        }
        catch (PathNotFoundException e) {
        }
        catch (RepositoryException e) {
            log.warn("Exception while constructing query: " + (Object)((Object)e));
            log.debug("Stacktrace: ", (Throwable)e);
        }
        return new BooleanQuery();
    }

    public Object visit(ChildNodeJoinConditionImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Object visit(ColumnImpl node, Object data) {
        throw new IllegalStateException();
    }

    public Object visit(ComparisonImpl node, Object data) throws Exception {
        return ((DynamicOperandImpl)node.getOperand1()).accept((QOMTreeVisitor)this, (Object)node);
    }

    public Object visit(DescendantNodeImpl node, Object data) throws Exception {
        Query selectorQuery = (Query)this.qomTree.getSelector(node.getSelectorQName()).accept((QOMTreeVisitor)this, null);
        try {
            NodeImpl n = (NodeImpl)this.session.getNode(node.getPath());
            ScoreNode sn = new ScoreNode(n.getNodeId(), 1.0f);
            QueryHitsQuery context = new QueryHitsQuery(new DefaultQueryHits(Collections.singletonList(sn)));
            return new DescendantSelfAxisQuery((Query)context, selectorQuery, false);
        }
        catch (PathNotFoundException e) {
        }
        catch (RepositoryException e) {
            log.warn("Exception while constructing query: " + (Object)((Object)e));
            log.debug("Stacktrace: ", (Throwable)e);
        }
        return new BooleanQuery();
    }

    public Object visit(DescendantNodeJoinConditionImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Object visit(EquiJoinConditionImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Object visit(FullTextSearchImpl node, Object data) throws Exception {
        String fieldname;
        if (node.getPropertyName() == null) {
            fieldname = FieldNames.FULLTEXT;
        } else {
            Name propName = node.getPropertyQName();
            StringBuffer tmp = new StringBuffer();
            tmp.append(this.nsMappings.getPrefix(propName.getNamespaceURI()));
            tmp.append(":").append("FULL:");
            tmp.append(propName.getLocalName());
            fieldname = tmp.toString();
        }
        QueryParser parser = new QueryParser(fieldname, this.analyzer, this.synonymProvider);
        parser.setOperator(1);
        StringBuffer query = new StringBuffer();
        String textsearch = node.getFullTextSearchExpression();
        textsearch = textsearch.replaceAll("AND", "and");
        textsearch = textsearch.replaceAll("NOT", "not");
        boolean escaped = false;
        for (int i = 0; i < textsearch.length(); ++i) {
            if (textsearch.charAt(i) == '\\') {
                if (escaped) {
                    query.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (textsearch.charAt(i) == '\'') {
                if (escaped) {
                    escaped = false;
                }
                query.append(textsearch.charAt(i));
                continue;
            }
            if (escaped) {
                query.append('\\');
                escaped = false;
            }
            query.append(textsearch.charAt(i));
        }
        return parser.parse(query.toString());
    }

    public Object visit(FullTextSearchScoreImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Object visit(JoinImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Object visit(LengthImpl node, Object data) throws Exception {
        if (this.version.getVersion() < IndexFormatVersion.V3.getVersion()) {
            throw new InvalidQueryException("Length operator is only available with index version >= 3. Please re-index repository and execute query again.");
        }
        PropertyValueImpl pv = (PropertyValueImpl)node.getPropertyValue();
        String propName = this.npResolver.getJCRName(pv.getPropertyQName());
        if (data instanceof ComparisonImpl) {
            ComparisonImpl comp = (ComparisonImpl)data;
            int operator = comp.getOperator();
            Value v = (Value)((StaticOperandImpl)comp.getOperand2()).accept((QOMTreeVisitor)this, data);
            String namedLength = FieldNames.createNamedLength(propName, v.getLong());
            switch (operator) {
                case 201: {
                    return new TermQuery(new Term(FieldNames.PROPERTY_LENGTHS, namedLength));
                }
                case 205: {
                    Term lower = new Term(FieldNames.PROPERTY_LENGTHS, namedLength);
                    Term upper = new Term(FieldNames.PROPERTY_LENGTHS, FieldNames.createNamedLength(propName, Long.MAX_VALUE));
                    return new RangeQuery(lower, upper, false);
                }
                case 206: {
                    Term lower = new Term(FieldNames.PROPERTY_LENGTHS, namedLength);
                    Term upper = new Term(FieldNames.PROPERTY_LENGTHS, FieldNames.createNamedLength(propName, Long.MAX_VALUE));
                    return new RangeQuery(lower, upper, true);
                }
                case 203: {
                    Term lower = new Term(FieldNames.PROPERTY_LENGTHS, FieldNames.createNamedLength(propName, -1L));
                    Term upper = new Term(FieldNames.PROPERTY_LENGTHS, namedLength);
                    return new RangeQuery(lower, upper, false);
                }
                case 204: {
                    Term lower = new Term(FieldNames.PROPERTY_LENGTHS, FieldNames.createNamedLength(propName, -1L));
                    Term upper = new Term(FieldNames.PROPERTY_LENGTHS, namedLength);
                    return new RangeQuery(lower, upper, true);
                }
                case 207: {
                    throw new InvalidQueryException("Like operator cannot be used with length operand");
                }
                case 202: {
                    Query all = Util.createMatchAllQuery(propName, this.version);
                    BooleanQuery b = new BooleanQuery();
                    b.add(all, BooleanClause.Occur.SHOULD);
                    b.add((Query)new TermQuery(new Term(FieldNames.PROPERTY_LENGTHS, namedLength)), BooleanClause.Occur.MUST_NOT);
                    return b;
                }
            }
            throw new InvalidQueryException("Unknown operator " + operator);
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Object visit(LiteralImpl node, Object data) {
        return node.getValue();
    }

    public Object visit(LowerCaseImpl node, Object data) throws Exception {
        Object obj = ((DynamicOperandImpl)node.getOperand()).accept((QOMTreeVisitor)this, data);
        return this.transformCase(obj, data, false);
    }

    public Object visit(NodeLocalNameImpl node, Object data) throws Exception {
        if (this.version.getVersion() < IndexFormatVersion.V3.getVersion()) {
            throw new InvalidQueryException("NodeLocalName operand is only available with index version >= 3. Please re-index repository and execute query again.");
        }
        if (data instanceof ComparisonImpl) {
            ComparisonImpl comp = (ComparisonImpl)data;
            int operator = comp.getOperator();
            Value v = (Value)((StaticOperandImpl)comp.getOperand2()).accept((QOMTreeVisitor)this, data);
            String value = v.getString();
            switch (operator) {
                case 201: {
                    return new TermQuery(new Term(FieldNames.LOCAL_NAME, value));
                }
                case 205: {
                    return new LocalNameRangeQuery(value, null, false);
                }
                case 206: {
                    return new LocalNameRangeQuery(value, null, true);
                }
                case 203: {
                    return new LocalNameRangeQuery(null, value, false);
                }
                case 204: {
                    return new LocalNameRangeQuery(null, value, true);
                }
                case 207: {
                    if (value.equals("%")) {
                        return new MatchAllDocsQuery();
                    }
                    return new WildcardQuery(FieldNames.LOCAL_NAME, null, value);
                }
                case 202: {
                    MatchAllDocsQuery all = new MatchAllDocsQuery();
                    BooleanQuery b = new BooleanQuery();
                    b.add((Query)all, BooleanClause.Occur.SHOULD);
                    b.add((Query)new TermQuery(new Term(FieldNames.LOCAL_NAME, value)), BooleanClause.Occur.MUST_NOT);
                    return b;
                }
            }
            throw new InvalidQueryException("Unknown operator " + operator);
        }
        throw new InvalidQueryException("not yet implemented");
    }

    public Object visit(NodeNameImpl node, Object data) throws Exception {
        if (data instanceof ComparisonImpl) {
            Name value;
            ComparisonImpl comp = (ComparisonImpl)data;
            int operator = comp.getOperator();
            Value v = (Value)((StaticOperandImpl)comp.getOperand2()).accept((QOMTreeVisitor)this, data);
            switch (v.getType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    throw new InvalidQueryException(v.getString() + " cannot be converted into a NAME value");
                }
            }
            try {
                value = this.session.getQName(v.getString());
            }
            catch (RepositoryException e) {
                throw new InvalidQueryException(v.getString() + " cannot be converted into a NAME value");
            }
            switch (operator) {
                case 201: {
                    return new NameQuery(value, this.version, this.nsMappings);
                }
                case 205: {
                    return new NameRangeQuery(value, null, false, this.version, this.nsMappings);
                }
                case 206: {
                    return new NameRangeQuery(value, null, true, this.version, this.nsMappings);
                }
                case 203: {
                    return new NameRangeQuery(null, value, false, this.version, this.nsMappings);
                }
                case 204: {
                    return new NameRangeQuery(null, value, true, this.version, this.nsMappings);
                }
                case 207: {
                    throw new InvalidQueryException("Operator LIKE is not supported with NAME operands");
                }
                case 202: {
                    MatchAllDocsQuery all = new MatchAllDocsQuery();
                    BooleanQuery b = new BooleanQuery();
                    b.add((Query)all, BooleanClause.Occur.SHOULD);
                    b.add((Query)new NameQuery(value, this.version, this.nsMappings), BooleanClause.Occur.MUST_NOT);
                    return b;
                }
            }
            throw new InvalidQueryException("Unknown operator " + operator);
        }
        throw new InvalidQueryException("not yet implemented");
    }

    public Object visit(NotImpl node, Object data) throws Exception {
        Query c = (Query)((ConstraintImpl)node.getConstraint()).accept((QOMTreeVisitor)this, data);
        return new NotQuery(c);
    }

    public Object visit(OrderingImpl node, Object data) {
        throw new IllegalStateException();
    }

    public Object visit(OrImpl node, Object data) throws Exception {
        BooleanQuery b = new BooleanQuery();
        b.add((Query)((ConstraintImpl)node.getConstraint1()).accept((QOMTreeVisitor)this, data), BooleanClause.Occur.SHOULD);
        b.add((Query)((ConstraintImpl)node.getConstraint2()).accept((QOMTreeVisitor)this, data), BooleanClause.Occur.SHOULD);
        return b;
    }

    public Object visit(PropertyExistenceImpl node, Object data) throws Exception {
        String propName = this.npResolver.getJCRName(node.getPropertyQName());
        return Util.createMatchAllQuery(propName, this.version);
    }

    public Object visit(PropertyValueImpl node, Object data) throws Exception {
        if (data instanceof ComparisonImpl) {
            ComparisonImpl comp = (ComparisonImpl)data;
            int operator = comp.getOperator();
            Value v = (Value)((StaticOperandImpl)comp.getOperand2()).accept((QOMTreeVisitor)this, data);
            String stringValue = this.stringValueOf(v);
            String propName = this.npResolver.getJCRName(node.getPropertyQName());
            String text = FieldNames.createNamedValue(propName, stringValue);
            switch (operator) {
                case 201: {
                    return new TermQuery(new Term(FieldNames.PROPERTIES, text));
                }
                case 205: {
                    Term lower = new Term(FieldNames.PROPERTIES, text);
                    Term upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(propName, "\uffff"));
                    return new RangeQuery(lower, upper, false);
                }
                case 206: {
                    Term lower = new Term(FieldNames.PROPERTIES, text);
                    Term upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(propName, "\uffff"));
                    return new RangeQuery(lower, upper, true);
                }
                case 203: {
                    Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(propName, ""));
                    Term upper = new Term(FieldNames.PROPERTIES, text);
                    return new RangeQuery(lower, upper, false);
                }
                case 204: {
                    Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(propName, ""));
                    Term upper = new Term(FieldNames.PROPERTIES, text);
                    return new RangeQuery(lower, upper, true);
                }
                case 207: {
                    if (stringValue.equals("%")) {
                        return Util.createMatchAllQuery(propName, this.version);
                    }
                    return new WildcardQuery(FieldNames.PROPERTIES, propName, stringValue);
                }
                case 202: {
                    Query all = Util.createMatchAllQuery(propName, this.version);
                    BooleanQuery b = new BooleanQuery();
                    b.add(all, BooleanClause.Occur.SHOULD);
                    b.add((Query)new TermQuery(new Term(FieldNames.PROPERTIES, text)), BooleanClause.Occur.MUST_NOT);
                    return b;
                }
            }
            throw new InvalidQueryException("Unknown operator " + operator);
        }
        throw new InvalidQueryException("not yet implemented");
    }

    public Object visit(QueryObjectModelTree node, Object data) throws Exception {
        Query source = (Query)node.getSource().accept((QOMTreeVisitor)this, data);
        if (node.getConstraint() == null) {
            return source;
        }
        Query constraint = (Query)node.getConstraint().accept((QOMTreeVisitor)this, data);
        BooleanQuery b = new BooleanQuery();
        b.add(source, BooleanClause.Occur.MUST);
        b.add(constraint, BooleanClause.Occur.MUST);
        return b;
    }

    public Object visit(SameNodeImpl node, Object data) {
        Name ntName = this.qomTree.getSelector(node.getSelectorQName()).getNodeTypeQName();
        try {
            NodeImpl n = (NodeImpl)this.session.getNode(node.getPath());
            if (n.isNodeType(ntName)) {
                ScoreNode sn = new ScoreNode(n.getNodeId(), 1.0f);
                return new QueryHitsQuery(new DefaultQueryHits(Collections.singletonList(sn)));
            }
        }
        catch (PathNotFoundException e) {
        }
        catch (RepositoryException e) {
            log.warn("Exception while constructing query: " + (Object)((Object)e));
            log.debug("Stacktrace: ", (Throwable)e);
        }
        return new BooleanQuery();
    }

    public Object visit(SameNodeJoinConditionImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Object visit(SelectorImpl node, Object data) throws Exception {
        TermQuery q;
        Term t;
        ArrayList<Term> terms = new ArrayList<Term>();
        String mixinTypesField = this.npResolver.getJCRName(NameConstants.JCR_MIXINTYPES);
        String primaryTypeField = this.npResolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
        NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
        NodeType base = null;
        try {
            base = ntMgr.getNodeType(this.session.getJCRName(node.getNodeTypeQName()));
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        if (base != null && base.isMixin()) {
            t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, this.npResolver.getJCRName(node.getNodeTypeQName())));
            terms.add(t);
        } else {
            t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, this.npResolver.getJCRName(node.getNodeTypeQName())));
            terms.add(t);
        }
        if (base != null) {
            NodeTypeIterator allTypes = ntMgr.getAllNodeTypes();
            while (allTypes.hasNext()) {
                NodeType nt = allTypes.nextNodeType();
                NodeType[] superTypes = nt.getSupertypes();
                if (!Arrays.asList(superTypes).contains(base)) continue;
                Name n = this.session.getQName(nt.getName());
                String ntName = this.nsMappings.translatePropertyName(n);
                Term t2 = nt.isMixin() ? new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, ntName)) : new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, ntName));
                terms.add(t2);
            }
        }
        if (terms.size() == 1) {
            q = new TermQuery((Term)terms.get(0));
        } else {
            BooleanQuery b = new BooleanQuery();
            Iterator it = terms.iterator();
            while (it.hasNext()) {
                b.add((Query)new TermQuery((Term)it.next()), BooleanClause.Occur.SHOULD);
            }
            q = b;
        }
        this.selectors.put(node.getSelectorQName(), q);
        return q;
    }

    public Object visit(UpperCaseImpl node, Object data) throws Exception {
        Object obj = ((DynamicOperandImpl)node.getOperand()).accept((QOMTreeVisitor)this, data);
        return this.transformCase(obj, data, true);
    }

    private String stringValueOf(Value value) throws RepositoryException {
        switch (value.getType()) {
            case 2: {
                return value.getString();
            }
            case 6: {
                return value.getString();
            }
            case 5: {
                return DateField.dateToString(value.getDate().getTime());
            }
            case 4: {
                return DoubleField.doubleToString(value.getDouble());
            }
            case 3: {
                return LongField.longToString(value.getLong());
            }
            case 7: {
                Name n = this.session.getQName(value.getString());
                return this.nsMappings.translatePropertyName(n);
            }
            case 8: {
                Path p = this.session.getQPath(value.getString());
                return this.npResolver.getJCRPath(p);
            }
            case 9: {
                return value.getString();
            }
            case 1: {
                return value.getString();
            }
        }
        throw new InvalidQueryException("Unsupported property type " + PropertyType.nameFromValue((int)value.getType()));
    }

    private Query transformTermQuery(TermQuery query, boolean toUpper) throws InvalidQueryException {
        if (query.getTerm().field() == FieldNames.PROPERTIES) {
            if (toUpper) {
                return new CaseTermQuery.Upper(query.getTerm());
            }
            return new CaseTermQuery.Lower(query.getTerm());
        }
        if (query.getTerm().field() == FieldNames.PROPERTIES_SET) {
            return query;
        }
        throw new InvalidQueryException("Upper/LowerCase not supported on field " + query.getTerm().field());
    }

    private Object transformCase(Object operand, Object data, boolean toUpperCase) throws InvalidQueryException, Exception {
        if (operand instanceof Transformable) {
            ((Transformable)operand).setTransformation(toUpperCase ? 2 : 1);
            return operand;
        }
        if (operand instanceof TermQuery) {
            return this.transformTermQuery((TermQuery)operand, toUpperCase);
        }
        if (operand instanceof LowerCaseImpl) {
            LowerCaseImpl lc = (LowerCaseImpl)operand;
            if (toUpperCase) {
                return this.transformCase(lc.getOperand(), data, true);
            }
            return ((DynamicOperandImpl)lc.getOperand()).accept((QOMTreeVisitor)this, data);
        }
        if (operand instanceof UpperCaseImpl) {
            UpperCaseImpl oc = (UpperCaseImpl)operand;
            if (toUpperCase) {
                return ((DynamicOperandImpl)oc.getOperand()).accept((QOMTreeVisitor)this, data);
            }
            return this.transformCase(oc.getOperand(), data, false);
        }
        if (operand instanceof CaseTermQuery) {
            CaseTermQuery ctq = (CaseTermQuery)operand;
            return this.transformTermQuery(new TermQuery(ctq.getTerm()), toUpperCase);
        }
        if (operand instanceof MatchAllQuery) {
            return operand;
        }
        if (operand instanceof BooleanQuery) {
            BooleanQuery original = (BooleanQuery)operand;
            BooleanQuery transformed = new BooleanQuery();
            BooleanClause[] clauses = original.getClauses();
            for (int i = 0; i < clauses.length; ++i) {
                Query q = (Query)this.transformCase(clauses[i].getQuery(), data, toUpperCase);
                transformed.add(q, clauses[i].getOccur());
            }
            return transformed;
        }
        throw new InvalidQueryException("lower/upper-case not supported on operand " + operand.getClass().getName());
    }
}

