/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchKeywordContext;
import javax.faces.component.search.SearchKeywordResolver;
import javax.faces.component.search.UntargetableComponent;

public class PreviousSearchKeywordResolver
extends SearchKeywordResolver {
    public static final String PREVIOUS_KEYWORD = "previous";

    public void resolve(SearchKeywordContext expressionContext, UIComponent current, String keyword) {
        List children;
        int index;
        UIComponent parent = current.getParent();
        if (parent.getChildCount() > 1 && (index = (children = parent.getChildren()).indexOf(current)) > 0) {
            int nextIndex = -1;
            do {
                if (children.get(--index) instanceof UntargetableComponent) continue;
                nextIndex = index;
            } while (nextIndex == -1 && index > 0);
            if (nextIndex != -1) {
                expressionContext.invokeContextCallback((UIComponent)children.get(nextIndex));
            }
        }
        expressionContext.setKeywordResolved(true);
    }

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return PREVIOUS_KEYWORD.equalsIgnoreCase(keyword);
    }

    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }

    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }
}

