/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.core.api.shared.MessageUtils;

public class DoubleConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Double";
    public static final String STRING_ID = "javax.faces.converter.STRING";
    public static final String DOUBLE_ID = "javax.faces.converter.DoubleConverter.DOUBLE";

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        if (facesContext == null || uiComponent == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        try {
            value = this.fixLocale(facesContext, value);
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ConverterException(MessageUtils.getErrorMessage(facesContext, DOUBLE_ID, new Object[]{value, "4214", MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }

    private String fixLocale(FacesContext facesContext, String value) {
        Locale loc = facesContext.getViewRoot().getLocale();
        if (loc == null || loc == Locale.US) {
            return value;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(loc);
        char decSep = dfs.getDecimalSeparator();
        if (decSep != '.' && value.lastIndexOf(decSep) >= 0) {
            StringBuilder sbVal = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == decSep) {
                    sbVal.append('.');
                    continue;
                }
                sbVal.append(value.charAt(i));
            }
            value = sbVal.toString();
        }
        return value;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (facesContext == null || uiComponent == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return Double.toString(((Number)value).doubleValue());
        }
        catch (Exception e) {
            throw new ConverterException(MessageUtils.getErrorMessage(facesContext, STRING_ID, new Object[]{value, MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }
}

