/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.impl;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.myfaces.extensions.cdi.message.api.Message;
import org.apache.myfaces.extensions.cdi.message.api.MessageBuilder;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.MessageContextConfig;
import org.apache.myfaces.extensions.cdi.message.api.MessageFactory;
import org.apache.myfaces.extensions.cdi.message.api.MessageFilter;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultMessageBuilder;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultMessageContextConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageContext
implements MessageContext {
    private static final long serialVersionUID = -110779217295211303L;
    private MessageContextConfig config = new DefaultMessageContextConfig();
    private MessageFactory messageFactory;

    protected DefaultMessageContext() {
    }

    public static MessageContext create(MessageContextConfig config) {
        return new DefaultMessageContext(config);
    }

    public static MessageContext create(MessageFactory messageFactory) {
        return new DefaultMessageContext(messageFactory);
    }

    public static MessageContext create(MessageContextConfig config, MessageFactory messageFactory) {
        return new DefaultMessageContext(config, messageFactory);
    }

    DefaultMessageContext(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    DefaultMessageContext(MessageContextConfig config) {
        this.config = config;
    }

    DefaultMessageContext(MessageContextConfig config, MessageFactory messageFactory) {
        this.config = config;
        this.messageFactory = messageFactory;
    }

    public MessageBuilder message() {
        return new DefaultMessageBuilder(this, this.messageFactory);
    }

    public MessageContextConfig config() {
        return this.config;
    }

    public <T extends MessageContext> T typed(Class<T> contextType) {
        return (T)this;
    }

    public MessageContext cloneContext() {
        return this.config().use().create();
    }

    public void addMessage(Message message) {
        this.addMessage(this, message);
    }

    public void addMessage(MessageContext messageContext, Message message) {
        this.config().getMessageHandler().addMessage(messageContext, message);
    }

    public void addMessageFilter(MessageFilter ... messageFilters) {
        this.config().getMessageHandler().addMessageFilter(messageFilters);
    }

    public Set<MessageFilter> getMessageFilters() {
        return this.config().getMessageHandler().getMessageFilters();
    }

    public void removeMessage(Message message) {
        this.config().getMessageHandler().removeMessage(message);
    }

    public void removeAllMessages() {
        this.config().getMessageHandler().removeAllMessages();
    }

    public List<Message> getMessages() {
        return this.config().getMessageHandler().getMessages();
    }

    public Locale getLocale() {
        return this.config().getLocaleResolver().getLocale();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMessageContext)) {
            return false;
        }
        DefaultMessageContext that = (DefaultMessageContext)o;
        return this.config.equals(that.config);
    }

    public int hashCode() {
        return this.config.hashCode();
    }
}

