/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.openwebbeans.startup;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpSessionEvent;
import org.apache.myfaces.extensions.cdi.core.api.InvocationOrder;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.api.startup.event.StartupEventBroadcaster;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.apache.webbeans.servlet.WebBeansConfigurationListener;
import org.apache.webbeans.spi.ContainerLifecycle;

@InvocationOrder(value=1)
public class WebBeansAwareConfigurationListener
extends WebBeansConfigurationListener
implements StartupEventBroadcaster,
Deactivatable {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected static Map<ClassLoader, Boolean> initialized = new ConcurrentHashMap<ClassLoader, Boolean>();
    protected static Map<ClassLoader, ContainerLifecycle> storedContainerLifecycle = new ConcurrentHashMap<ClassLoader, ContainerLifecycle>();

    public void contextInitialized(ServletContextEvent event) {
        if (!this.isInitialized()) {
            this.logger.info("Controlled OpenWebBeans bootstrapping.");
            super.contextInitialized(event);
            this.storeContainerLifecycle();
            this.markAsInitialized();
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        this.storeContainerLifecycle();
        super.requestInitialized(event);
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.storeContainerLifecycle();
        super.contextDestroyed(event);
    }

    public void requestDestroyed(ServletRequestEvent event) {
        this.storeContainerLifecycle();
        super.requestDestroyed(event);
    }

    public void sessionCreated(HttpSessionEvent event) {
        this.storeContainerLifecycle();
        super.sessionCreated(event);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.storeContainerLifecycle();
        super.sessionDestroyed(event);
    }

    public void broadcastStartup() {
        if (!this.isActivated()) {
            return;
        }
        if (this.isInitialized()) {
            return;
        }
        this.logger.info("Controlled MyFaces ExtCDI bootstrapping.");
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && facesContext.getExternalContext() != null) {
            ServletContext servletContext = (ServletContext)facesContext.getExternalContext().getContext();
            this.contextInitialized(new ServletContextEvent(servletContext));
        }
        this.markAsInitialized();
    }

    protected void markAsInitialized() {
        initialized.put(this.getClassLoader(), Boolean.TRUE);
    }

    protected boolean isInitialized() {
        ClassLoader classLoader = this.getClassLoader();
        return Boolean.TRUE.equals(initialized.get(classLoader));
    }

    protected void storeContainerLifecycle() {
        ClassLoader classLoader = this.getClassLoader();
        if (this.lifeCycle != null) {
            storedContainerLifecycle.put(classLoader, this.lifeCycle);
        } else {
            this.lifeCycle = storedContainerLifecycle.get(classLoader);
        }
    }

    private ClassLoader getClassLoader() {
        return ClassUtils.getClassLoader(null);
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(((Object)((Object)this)).getClass());
    }
}

