/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.WindowContextIdHolderComponent;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.WindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.JsfUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.RequestCache;

@ApplicationScoped
public class DefaultWindowHandler
implements WindowHandler {
    private static final long serialVersionUID = -103516988654873089L;
    private static final int DEFAULT_WINDOW_KEY_LENGTH = 3;
    private static final String WINDOW_ID_PARAMETER_KEY = "windowId=";
    protected boolean useWindowAwareUrlEncoding;

    protected DefaultWindowHandler() {
    }

    @Inject
    protected DefaultWindowHandler(WindowContextConfig config) {
        this.useWindowAwareUrlEncoding = config.isUrlParameterSupported();
    }

    public String encodeURL(String url) {
        if (this.useWindowAwareUrlEncoding) {
            return this.addWindowIdIfNecessary(url, this.getCurrentWindowId());
        }
        return url;
    }

    public void sendRedirect(ExternalContext externalContext, String url, boolean addRequestParameter) throws IOException {
        if (FacesContext.getCurrentInstance().getResponseComplete()) {
            return;
        }
        url = this.encodeURL(url);
        url = addRequestParameter ? JsfUtils.addParameters(externalContext, url, true, true, true) : JsfUtils.addParameters(externalContext, url, false, true, true);
        url = externalContext.encodeActionURL(url);
        externalContext.redirect(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createWindowId() {
        String oldWindowContextId = this.resolveExpiredWindowContextId();
        if (oldWindowContextId != null) {
            return oldWindowContextId;
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        Map map = externalContext.getSessionMap();
        synchronized (map) {
            Set<String> existingWindowIdSet = ConversationUtils.getExistingWindowIdSet(externalContext);
            int startIndex = 0;
            while (startIndex + 3 < uuid.length()) {
                String shortUuid = uuid.substring(startIndex, startIndex + 3);
                if (!existingWindowIdSet.contains(shortUuid)) {
                    uuid = shortUuid;
                    break;
                }
                ++startIndex;
            }
        }
        return uuid;
    }

    private String resolveExpiredWindowContextId() {
        WindowContextIdHolderComponent windowContextIdHolderComponent = ConversationUtils.getWindowContextIdHolderComponent(FacesContext.getCurrentInstance());
        if (windowContextIdHolderComponent == null) {
            return null;
        }
        return windowContextIdHolderComponent.getWindowContextId();
    }

    public String restoreWindowId(ExternalContext externalContext) {
        if (!this.useWindowAwareUrlEncoding) {
            return null;
        }
        return (String)externalContext.getRequestParameterMap().get("windowId");
    }

    protected String getCurrentWindowId() {
        return RequestCache.getWindowContextManager().getCurrentWindowContext().getId();
    }

    protected String addWindowIdIfNecessary(String url, String windowId) {
        if (url.contains(WINDOW_ID_PARAMETER_KEY)) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        if (url.contains("?")) {
            newUrl.append("&");
        } else {
            newUrl.append("?");
        }
        newUrl.append("windowId");
        newUrl.append("=");
        newUrl.append(windowId);
        return newUrl.toString();
    }
}

