/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.extensions.cdi.core.api.activation.ClassDeactivator;
import org.apache.myfaces.extensions.cdi.core.api.config.ConfiguredValueResolver;
import org.apache.myfaces.extensions.cdi.core.api.provider.ServiceProvider;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfiguredValueResolver
implements ConfiguredValueResolver {
    private boolean deactivated = false;
    private List instances = new ArrayList();
    private List<String> configuredValues = new ArrayList<String>();

    protected AbstractConfiguredValueResolver() {
        List serviceLoader = ServiceProvider.loadServices(ClassDeactivator.class);
        for (ClassDeactivator currentInstance : serviceLoader) {
            if (!currentInstance.getDeactivatedClasses().contains(this.getClass())) continue;
            this.deactivated = true;
            break;
        }
    }

    protected <T> void add(Class<T> targetType) {
        Object instance = ClassUtils.tryToInstantiateClass(targetType);
        if (instance != null) {
            this.instances.add(instance);
        }
    }

    protected <T> void add(T value) {
        if (!String.class.isAssignableFrom(value.getClass())) {
            this.instances.add(value);
        } else {
            this.configuredValues.add((String)value);
        }
    }

    protected <T> List<T> getConfiguredValues(Class<T> targetType) {
        if (this.instances.size() > 0 && this.configuredValues.size() > 0) {
            throw new IllegalStateException("Mixed config found.");
        }
        if (!String.class.isAssignableFrom(targetType)) {
            return this.instances;
        }
        return this.configuredValues;
    }

    public boolean isActivated() {
        return !this.deactivated;
    }
}

