/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.projectstage;

import java.io.Serializable;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import org.apache.myfaces.extensions.cdi.core.api.Aggregatable;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.TestStage;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;

@ApplicationScoped
public class ProjectStageProducer
implements Serializable {
    private static final long serialVersionUID = -2987762608635612074L;
    protected static final Logger LOG = Logger.getLogger(ProjectStageProducer.class.getName());
    private static ProjectStage projectStage;
    private static volatile ProjectStageProducer projectStageProducer;

    protected ProjectStageProducer() {
    }

    @Produces
    @Dependent
    @Default
    public ProjectStage getProjectStage() {
        if (projectStage == null) {
            ProjectStageProducer.getInstance();
        }
        return projectStage;
    }

    protected void reset() {
        projectStage = null;
        projectStageProducer = null;
    }

    public static ProjectStageProducer getInstance() {
        if (projectStageProducer == null) {
            ProjectStageProducer.lazyInit();
        }
        if (projectStage == null) {
            projectStageProducer.initProjectStage();
        }
        return projectStageProducer;
    }

    private static synchronized void lazyInit() {
        if (projectStageProducer != null) {
            return;
        }
        ProjectStageProducer defaultProjectStageProducer = new ProjectStageProducer();
        projectStageProducer = (ProjectStageProducer)CodiUtils.lookupFromEnvironment(ProjectStageProducer.class, (Aggregatable)new Aggregatable<ProjectStageProducer>(){
            private ProjectStageProducer specializedCodiProjectStageProducer;
            private ProjectStageProducer customConfiguredProjectStageProducer;

            public void add(ProjectStageProducer projectStageProducer) {
                if (projectStageProducer.getClass().getName().startsWith("org.apache.myfaces.")) {
                    this.specializedCodiProjectStageProducer = projectStageProducer;
                } else {
                    this.customConfiguredProjectStageProducer = projectStageProducer;
                }
            }

            public ProjectStageProducer create() {
                if (this.customConfiguredProjectStageProducer != null) {
                    return this.customConfiguredProjectStageProducer;
                }
                if (this.specializedCodiProjectStageProducer != null) {
                    return this.specializedCodiProjectStageProducer;
                }
                return null;
            }
        }, (Serializable[])new ProjectStageProducer[]{defaultProjectStageProducer});
        if (projectStageProducer == null) {
            projectStageProducer = defaultProjectStageProducer;
        }
        projectStageProducer.initProjectStage();
    }

    public static void setProjectStage(ProjectStage ps) {
        projectStage = ps;
    }

    protected ProjectStage resolveProjectStage() {
        String stageName = (String)((Object)CodiUtils.lookupFromEnvironment((String)"ProjectStage", String.class, (Serializable[])new String[0]));
        if (stageName != null) {
            return ProjectStage.valueOf((String)stageName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initProjectStage() {
        Class<ProjectStageProducer> clazz = ProjectStageProducer.class;
        synchronized (ProjectStageProducer.class) {
            if (projectStage == null) {
                projectStage = this.resolveProjectStage();
                if (projectStage == null) {
                    projectStage = ProjectStage.Production;
                }
                if (TestStage.class.isAssignableFrom(projectStage.getClass())) {
                    new BeanManagerProvider(){

                        public void setTestMode() {
                            super.setTestMode();
                        }
                    }.setTestMode();
                }
                LOG.info("Computed the following CODI ProjectStage: " + projectStage);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

