/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIProgress;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProgressTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressTag.class);
    private ValueExpression tip;
    private ValueExpression value;
    private ValueExpression markup;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Progress";
    }

    public String getRendererType() {
        return "Progress";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIProgress component = (UIProgress)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
        if (this.value != null && !this.value.isLiteralText()) {
            component.setValueExpression("value", this.value);
        }
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public void release() {
        super.release();
        this.tip = null;
        this.value = null;
        this.markup = null;
    }
}

