/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.standard.standard.tag.TreeNodeRendererBase;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeMenuNodeRenderer
extends TreeNodeRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeNode node = (UITreeNode)component;
        AbstractUIData data = (AbstractUIData)ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        boolean dataRendersRowContainer = data.isRendersRowContainer();
        boolean folder = node.isFolder();
        String clientId = node.getClientId(facesContext);
        boolean ie6 = ClientProperties.getInstance((FacesContext)facesContext).getUserAgent().equals(UserAgent.MSIE_6_0);
        String parentId = data.getRowParentClientId();
        boolean visible = data.isRowVisible();
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("div", null);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(Classes.create((UIComponent)node));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)node);
        if (parentId != null) {
            writer.writeAttribute("data-tobago-tree-parent", parentId, false);
        }
        if (!dataRendersRowContainer && !visible) {
            Style style = new Style();
            style.setDisplay(Display.NONE);
            writer.writeStyleAttribute(style);
        }
        if (!folder && ie6) {
            String src = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/1x1");
            writer.startElement("img", null);
            writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"icon"));
            writer.writeAttribute("src", src, false);
            writer.writeAttribute("alt", "", false);
            Style style = new Style();
            style.setWidth(Measure.ZERO);
            writer.writeStyleAttribute(style);
            writer.endElement("img");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeNode node = (UITreeNode)component;
        AbstractUIData data = (AbstractUIData)ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        int level = node.getLevel();
        boolean folder = node.isFolder();
        boolean expanded = folder && data.getExpandedState().isExpanded(node.getPath()) || level == 0;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        if (folder) {
            this.encodeIcon(facesContext, writer, expanded, node);
        }
        writer.endElement("div");
    }

    private void encodeIcon(FacesContext facesContext, TobagoResponseWriter writer, boolean expanded, UITreeNode node) throws IOException {
        String srcOpen = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/treeMenuOpen");
        String srcClose = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/treeMenuClose");
        String src = expanded ? srcOpen : srcClose;
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"toggle"));
        writer.writeAttribute("src", src, false);
        writer.writeAttribute("data-tobago-src-open", srcOpen, false);
        writer.writeAttribute("data-tobago-src-close", srcClose, false);
        writer.writeAttribute("alt", "", false);
        writer.endElement("img");
    }
}

