/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.UILabel;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(LabelRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        ComponentUtils.evaluateAutoFor((UIComponent)component, UIInput.class);
        UILabel label = (UILabel)component;
        UIComponent corresponding = ComponentUtils.findFor((UIComponent)label);
        if (corresponding != null) {
            Markup markup = label.getCurrentMarkup();
            markup = ComponentUtils.updateMarkup((UIComponent)corresponding, (Markup)markup);
            label.setCurrentMarkup(markup);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String title;
        UILabel label = (UILabel)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String forValue = ComponentUtils.findClientIdFor((UIComponent)label, (FacesContext)facesContext);
        String clientId = label.getClientId(facesContext);
        writer.startElement("label", (UIComponent)label);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)label);
        Classes classes = Classes.create((UIComponent)label);
        writer.writeClassAttribute(classes);
        writer.writeStyleAttribute(new Style(facesContext, (LayoutBase)label));
        writer.writeIdAttribute(clientId);
        if (forValue != null) {
            writer.writeAttribute("for", forValue, false);
        }
        if ((title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)label)) != null) {
            writer.writeAttribute("title", title, true);
        }
        this.encodeTextContent(facesContext, writer, label);
        writer.endElement("label");
    }

    protected void encodeTextContent(FacesContext facesContext, TobagoResponseWriter writer, UILabel component) throws IOException {
        LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)component);
        if (label.getAccessKey() != null) {
            writer.writeAttribute("accesskey", Character.toString(label.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey(), (String)component.getClientId());
        }
        HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
    }
}

