/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.DeprecatedDimension;
import org.apache.myfaces.tobago.component.OnComponentCreated;
import org.apache.myfaces.tobago.component.OnComponentPopulated;
import org.apache.myfaces.tobago.component.Position;
import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanelBase;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUIPopup
extends AbstractUIPanelBase
implements OnComponentCreated,
OnComponentPopulated,
NamingContainer,
DeprecatedDimension,
Position,
LayoutContainer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUIPopup.class);
    private static final String Z_INDEX = AbstractUIPopup.class.getName() + ".Z_INDEX";
    private boolean activated;

    @Override
    public void onComponentCreated(FacesContext facesContext, UIComponent parent) {
        Integer zIndex = (Integer)facesContext.getExternalContext().getRequestMap().get(Z_INDEX);
        if (zIndex == null) {
            zIndex = 1;
        } else {
            Integer n = zIndex;
            Integer n2 = zIndex = Integer.valueOf(zIndex + 1);
        }
        this.setZIndex(zIndex);
        facesContext.getExternalContext().getRequestMap().put(Z_INDEX, zIndex);
    }

    @Override
    public void onComponentPopulated(FacesContext facesContext, UIComponent parent) {
        if (this.getLayoutManager() == null) {
            AbstractUIGridLayout layoutManager = (AbstractUIGridLayout)CreateComponentUtils.createAndInitLayout(facesContext, "org.apache.myfaces.tobago.GridLayout", "GridLayout", parent);
            this.setLayoutManager(layoutManager);
        }
    }

    @Override
    public List<LayoutComponent> getComponents() {
        return LayoutUtils.findLayoutChildren(this);
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public void processDecodes(FacesContext facesContext) {
        if (this.isSubmitted()) {
            Iterator it = this.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent childOrFacet = (UIComponent)it.next();
                childOrFacet.processDecodes(facesContext);
            }
            try {
                this.decode(facesContext);
            }
            catch (RuntimeException e) {
                facesContext.renderResponse();
                throw e;
            }
            if (facesContext.getRenderResponse()) {
                this.setActivated(true);
            }
        }
    }

    public boolean isRendered() {
        ValueExpression expression = this.getValueExpression("rendered");
        if (expression != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            return (Boolean)expression.getValue(context.getELContext());
        }
        return this.isActivated() || this.isRedisplay();
    }

    private boolean isSubmitted() {
        FacesContext facesContext = this.getFacesContext();
        String action = FacesContextUtils.getActionId(facesContext);
        return action != null && action.startsWith(this.getClientId(facesContext) + UINamingContainer.getSeparatorChar((FacesContext)facesContext));
    }

    private boolean isRedisplay() {
        UIComponent command;
        String action;
        if (this.isSubmitted() && (action = FacesContextUtils.getActionId(this.getFacesContext())) != null && (command = this.getFacesContext().getViewRoot().findComponent(UINamingContainer.getSeparatorChar((FacesContext)this.getFacesContext()) + action)) != null && command instanceof UICommand) {
            return command.getAttributes().get("popupClose") == null;
        }
        return false;
    }

    private boolean isActivated() {
        return this.activated;
    }

    public void processValidators(FacesContext context) {
        if (this.isSubmitted()) {
            Iterator it = this.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent childOrFacet = (UIComponent)it.next();
                childOrFacet.processValidators(context);
            }
            if (context.getRenderResponse()) {
                this.setActivated(true);
            }
        }
    }

    public void processUpdates(FacesContext context) {
        if (this.isSubmitted()) {
            Iterator it = this.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent childOrFacet = (UIComponent)it.next();
                childOrFacet.processUpdates(context);
            }
        }
    }

    public Object saveState(FacesContext context) {
        Object[] saveState = new Object[]{super.saveState(context), this.activated};
        return saveState;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] values = (Object[])savedState;
        super.restoreState(context, values[0]);
        this.activated = (Boolean)values[1];
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        this.activated = false;
    }

    @Override
    public LayoutManager getLayoutManager() {
        return (LayoutManager)this.getFacet("layout");
    }

    @Override
    public void setLayoutManager(LayoutManager layoutManager) {
        this.getFacets().put("layout", (AbstractUILayoutBase)((Object)layoutManager));
    }

    @Override
    public boolean isLayoutChildren() {
        return this.isRendered();
    }

    @Override
    public abstract Measure getWidth();

    @Override
    public abstract void setWidth(Measure var1);

    @Override
    public abstract Measure getHeight();

    @Override
    public abstract void setHeight(Measure var1);

    @Override
    public abstract Measure getTop();

    @Override
    public abstract void setTop(Measure var1);

    @Override
    public abstract Measure getLeft();

    @Override
    public abstract void setLeft(Measure var1);

    public abstract void setZIndex(Integer var1);
}

