/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.TobagoResourceBundle;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.event.SheetAction;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumn;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnNode;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnSelector;
import org.apache.myfaces.tobago.internal.component.AbstractUILink;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.component.AbstractUIReload;
import org.apache.myfaces.tobago.internal.component.AbstractUIRow;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.layout.Cell;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.ShowPosition;
import org.apache.myfaces.tobago.layout.TextAlign;
import org.apache.myfaces.tobago.layout.VerticalAlign;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.CustomClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SheetRenderer.class);
    private static final String SUFFIX_WIDTHS = "::widths";
    private static final String SUFFIX_COLUMN_RENDERED = "::rendered";
    private static final String SUFFIX_SCROLL_POSITION = "::scrollPosition";
    private static final String SUFFIX_SELECTED = "::selected";
    private static final String SUFFIX_LAZY = ":pageActionlazy";
    private static final String SUFFIX_PAGE_ACTION = "pageAction";

    public void decode(FacesContext facesContext, UIComponent component) {
        String value;
        AbstractUISheet sheet = (AbstractUISheet)component;
        List<AbstractUIColumnBase> columns = sheet.getAllColumns();
        String clientId = sheet.getClientId(facesContext);
        String key = clientId + SUFFIX_WIDTHS;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        SheetState state = sheet.getState();
        if (requestParameterMap.containsKey(key)) {
            String widths = (String)requestParameterMap.get(key);
            this.ensureColumnWidthsSize(state.getColumnWidths(), columns, JsonUtils.decodeIntegerArray(widths));
        }
        if (requestParameterMap.containsKey(key = clientId + SUFFIX_SELECTED)) {
            List<Integer> selectedRows;
            String selected = (String)requestParameterMap.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("selected = " + selected);
            }
            try {
                selectedRows = StringUtils.parseIntegerList(selected);
            }
            catch (NumberFormatException e) {
                LOG.warn(selected, (Throwable)e);
                selectedRows = Collections.emptyList();
            }
            ComponentUtils.setAttribute((UIComponent)sheet, Attributes.selectedListString, selectedRows);
        }
        if ((value = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId + SUFFIX_SCROLL_POSITION)) != null) {
            state.getScrollPosition().update(value);
        }
        RenderUtils.decodedStateOfTreeData(facesContext, sheet);
        this.decodeSheetAction(facesContext, sheet);
        this.decodeColumnAction(facesContext, columns);
    }

    private void decodeColumnAction(FacesContext facesContext, List<AbstractUIColumnBase> columns) {
        for (AbstractUIColumnBase column : columns) {
            boolean sortable = ComponentUtils.getBooleanAttribute((UIComponent)column, Attributes.sortable);
            if (!sortable) continue;
            String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.source");
            String columnId = column.getClientId(facesContext);
            String sorterId = columnId + "_" + "sorter";
            if (!sorterId.equals(sourceId)) continue;
            UIData data = (UIData)column.getParent();
            data.queueEvent((FacesEvent)new SortActionEvent(data, column));
        }
    }

    private void decodeSheetAction(FacesContext facesContext, AbstractUISheet component) {
        String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        String clientId = component.getClientId(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sourceId = '{}'", (Object)sourceId);
            LOG.debug("clientId = '{}'", (Object)clientId);
        }
        String sheetClientIdWithAction = clientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + SUFFIX_PAGE_ACTION;
        if (sourceId != null && sourceId.startsWith(sheetClientIdWithAction)) {
            String actionString = sourceId.substring(sheetClientIdWithAction.length());
            int index = actionString.indexOf(45);
            SheetAction action = index != -1 ? SheetAction.valueOf(actionString.substring(0, index)) : SheetAction.valueOf(actionString);
            PageActionEvent event = null;
            switch (action) {
                case first: 
                case prev: 
                case next: 
                case last: {
                    event = new PageActionEvent((UIComponent)component, action);
                    break;
                }
                case toPage: 
                case toRow: 
                case lazy: {
                    Integer target;
                    String value;
                    event = new PageActionEvent((UIComponent)component, action);
                    if (index == -1) {
                        Map map = facesContext.getExternalContext().getRequestParameterMap();
                        value = map.get(sourceId);
                    } else {
                        value = actionString.substring(index + 1);
                    }
                    try {
                        target = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Can't parse integer value for action " + action.name() + ": " + value);
                        break;
                    }
                    event.setValue(target);
                    break;
                }
            }
            if (event != null) {
                component.queueEvent((FacesEvent)event);
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUISheet sheet = (AbstractUISheet)component;
        String sheetId = sheet.getClientId(facesContext);
        Markup markup = sheet.getMarkup();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUIReload reload = ComponentUtils.getReloadFacet((UIComponent)sheet);
        UIComponent header = sheet.getHeader();
        if (header == null) {
            header = ComponentUtils.createComponent(facesContext, Tags.panel.componentType(), null, "_header");
            header.setTransient(true);
            List<AbstractUIColumnBase> columns = sheet.getAllColumns();
            int i = 0;
            for (AbstractUIColumnBase column : columns) {
                if (!(column instanceof AbstractUIRow)) {
                    AbstractUIOut out = (AbstractUIOut)ComponentUtils.createComponent(facesContext, Tags.out.componentType(), RendererTypes.Out, "_col" + i);
                    out.setTransient(true);
                    ValueExpression valueExpression = column.getValueExpression(Attributes.label.getName());
                    if (valueExpression != null) {
                        out.setValueExpression(Attributes.value.getName(), valueExpression);
                    } else {
                        out.setValue(ComponentUtils.getAttribute((UIComponent)column, Attributes.label));
                    }
                    valueExpression = column.getValueExpression(Attributes.rendered.getName());
                    if (valueExpression != null) {
                        out.setValueExpression(Attributes.rendered.getName(), valueExpression);
                    } else {
                        out.setRendered(ComponentUtils.getBooleanAttribute((UIComponent)column, Attributes.rendered));
                    }
                    out.setLabelLayout(LabelLayout.skip);
                    header.getChildren().add(out);
                }
                ++i;
            }
            sheet.setHeader(header);
        }
        sheet.init(facesContext);
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(sheetId);
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)sheet);
        writer.writeClassAttribute((CssItem)TobagoClass.SHEET, TobagoClass.SHEET.createMarkup(markup), new CssItem[]{sheet.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
        if (reload != null && reload.isRendered()) {
            writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.RELOAD, reload.getFrequency());
        }
        CommandMap commands = RenderUtils.getBehaviorCommands(facesContext, sheet);
        writer.writeAttribute(DataAttributes.BEHAVIOR_COMMANDS, JsonUtils.encode(commands), false);
        writer.writeAttribute(DataAttributes.SELECTION_MODE, sheet.getSelectable().name(), false);
        writer.writeAttribute(DataAttributes.FIRST, Integer.toString(sheet.getFirst()), false);
        writer.writeAttribute(DataAttributes.ROWS, Integer.toString(sheet.getRows()), false);
        writer.writeAttribute(DataAttributes.ROW_COUNT, Integer.toString(sheet.getRowCount()), false);
        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.LAZY, sheet.isLazy());
        StringBuilder builder = new StringBuilder();
        boolean autoLayout = sheet.isAutoLayout();
        if (!autoLayout) {
            builder.append("{\"columns\":");
            JsonUtils.encode(sheet.getColumnLayout(), builder);
            builder.append("}");
            writer.writeAttribute(DataAttributes.LAYOUT, builder.toString(), true);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUISheet sheet = (AbstractUISheet)component;
        for (UIComponent child : sheet.getChildren()) {
            if (!(child instanceof AbstractUIStyle)) continue;
            child.encodeAll(facesContext);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractUISheet sheet = (AbstractUISheet)uiComponent;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String sheetId = sheet.getClientId(facesContext);
        Selectable selectable = sheet.getSelectable();
        Application application = facesContext.getApplication();
        SheetState state = sheet.getSheetState(facesContext);
        List<Integer> columnWidths = sheet.getState().getColumnWidths();
        boolean definedColumnWidths = sheet.getState().isDefinedColumnWidths();
        List<Integer> selectedRows = this.getSelectedRows(sheet, state);
        List<AbstractUIColumnBase> columns = sheet.getAllColumns();
        boolean autoLayout = sheet.isAutoLayout();
        this.ensureColumnWidthsSize(columnWidths, columns, Collections.emptyList());
        if (!autoLayout) {
            this.encodeHiddenInput(writer, JsonUtils.encode(definedColumnWidths ? columnWidths : Collections.emptyList()), sheetId + SUFFIX_WIDTHS);
            ArrayList<String> encodedRendered = new ArrayList<String>();
            for (AbstractUIColumnBase column : columns) {
                if (column instanceof AbstractUIRow) continue;
                encodedRendered.add(Boolean.toString(column.isRendered()));
            }
            this.encodeHiddenInput(writer, JsonUtils.encode(encodedRendered.toArray(new String[0]), false), sheetId + SUFFIX_COLUMN_RENDERED);
        }
        this.encodeHiddenInput(writer, sheet.getState().getScrollPosition().encode(), sheet.getClientId(facesContext) + SUFFIX_SCROLL_POSITION);
        if (selectable != Selectable.none) {
            this.encodeHiddenInput(writer, StringUtils.joinWithSurroundingSeparator(selectedRows), sheetId + SUFFIX_SELECTED);
        }
        if (sheet.isLazy()) {
            this.encodeHiddenInput(writer, null, sheetId + SUFFIX_LAZY);
        }
        StringBuilder expandedValue = null;
        if (sheet.isTreeModel()) {
            expandedValue = new StringBuilder(",");
        }
        this.encodeTableBody(facesContext, sheet, writer, sheetId, selectable, columnWidths, selectedRows, columns, autoLayout, expandedValue);
        if (sheet.isPagingVisible()) {
            Markup showPageRange;
            Markup showDirectLinks;
            writer.startElement(HtmlElements.FOOTER);
            writer.writeClassAttribute(TobagoClass.SHEET__FOOTER);
            Markup showRowRange = this.markupForLeftCenterRight(sheet.getShowRowRange());
            if (showRowRange != Markup.NULL) {
                AbstractUILink command = this.ensurePagingCommand(facesContext, sheet, Facets.pagerRow.name(), SheetAction.toRow.name(), false);
                String pagerCommandId = command.getClientId(facesContext);
                writer.startElement(HtmlElements.UL);
                writer.writeClassAttribute((CssItem)TobagoClass.SHEET__PAGING, TobagoClass.SHEET__PAGING.createMarkup(showRowRange), new CssItem[]{BootstrapClass.PAGINATION});
                writer.startElement(HtmlElements.LI);
                writer.writeClassAttribute(BootstrapClass.PAGE_ITEM);
                writer.writeAttribute(HtmlAttributes.TITLE, TobagoResourceBundle.getString(facesContext, "sheetPagingInfoRowPagingTip"), true);
                writer.startElement(HtmlElements.SPAN);
                writer.writeClassAttribute(TobagoClass.SHEET__PAGING_TEXT, BootstrapClass.PAGE_LINK);
                if (sheet.getRowCount() != 0) {
                    boolean unknown;
                    Locale locale = facesContext.getViewRoot().getLocale();
                    int first = sheet.getFirst() + 1;
                    int last1 = sheet.hasRowCount() ? sheet.getLastRowIndexOfCurrentPage() : -1;
                    boolean bl = unknown = !sheet.hasRowCount();
                    String key = unknown ? (first == last1 ? "sheetPagingInfoUndefinedSingleRow" : "sheetPagingInfoUndefinedRows") : (first == last1 ? "sheetPagingInfoSingleRow" : "sheetPagingInfoRows");
                    String inputMarker = "{#}";
                    Object[] args = new Object[]{"{#}", last1 == -1 ? "?" : Integer.valueOf(last1), unknown ? "" : Integer.valueOf(sheet.getRowCount())};
                    MessageFormat detail = new MessageFormat(TobagoResourceBundle.getString(facesContext, key), locale);
                    String formatted = detail.format(args);
                    int pos = formatted.indexOf("{#}");
                    if (pos >= 0) {
                        writer.writeText(formatted.substring(0, pos));
                        writer.startElement(HtmlElements.SPAN);
                        writer.writeClassAttribute(TobagoClass.SHEET__PAGING_OUTPUT);
                        writer.writeText(Integer.toString(first));
                        writer.endElement(HtmlElements.SPAN);
                        writer.startElement(HtmlElements.INPUT);
                        writer.writeIdAttribute(pagerCommandId);
                        writer.writeNameAttribute(pagerCommandId);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.TEXT);
                        writer.writeClassAttribute(TobagoClass.SHEET__PAGING_INPUT);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.VALUE, first);
                        if (!unknown) {
                            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, Integer.toString(sheet.getRowCount()).length());
                        }
                        writer.endElement(HtmlElements.INPUT);
                        writer.writeText(formatted.substring(pos + "{#}".length()));
                    } else {
                        writer.writeText(formatted);
                    }
                } else {
                    writer.write(TobagoResourceBundle.getString(facesContext, "sheetPagingInfoEmptyRow"));
                }
                ComponentUtils.removeFacet((UIComponent)sheet, Facets.pagerRow);
                writer.endElement(HtmlElements.SPAN);
                writer.endElement(HtmlElements.LI);
                writer.endElement(HtmlElements.UL);
            }
            if ((showDirectLinks = this.markupForLeftCenterRight(sheet.getShowDirectLinks())) != Markup.NULL) {
                writer.startElement(HtmlElements.UL);
                writer.writeClassAttribute((CssItem)TobagoClass.SHEET__PAGING, TobagoClass.SHEET__PAGING.createMarkup(showDirectLinks), new CssItem[]{BootstrapClass.PAGINATION});
                if (sheet.isShowDirectLinksArrows()) {
                    boolean disabled = sheet.isAtBeginning();
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.first, null, Icons.STEP_BACKWARD, null);
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.prev, null, Icons.BACKWARD, null);
                }
                this.encodeDirectPagingLinks(facesContext, application, sheet);
                if (sheet.isShowDirectLinksArrows()) {
                    boolean disabled = sheet.isAtEnd();
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.next, null, Icons.FORWARD, null);
                    this.encodeLink(facesContext, sheet, application, disabled || !sheet.hasRowCount(), SheetAction.last, null, Icons.STEP_FORWARD, null);
                }
                writer.endElement(HtmlElements.UL);
            }
            if ((showPageRange = this.markupForLeftCenterRight(sheet.getShowPageRange())) != Markup.NULL) {
                AbstractUILink command = this.ensurePagingCommand(facesContext, sheet, Facets.pagerPage.name(), SheetAction.toPage.name(), false);
                String pagerCommandId = command.getClientId(facesContext);
                writer.startElement(HtmlElements.UL);
                writer.writeClassAttribute((CssItem)TobagoClass.SHEET__PAGING, TobagoClass.SHEET__PAGING.createMarkup(showPageRange), new CssItem[]{BootstrapClass.PAGINATION});
                if (sheet.isShowPageRangeArrows()) {
                    boolean disabled = sheet.isAtBeginning();
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.first, null, Icons.STEP_BACKWARD, null);
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.prev, null, Icons.BACKWARD, null);
                }
                writer.startElement(HtmlElements.LI);
                writer.writeClassAttribute(BootstrapClass.PAGE_ITEM);
                writer.startElement(HtmlElements.SPAN);
                writer.writeClassAttribute(TobagoClass.SHEET__PAGING_TEXT, BootstrapClass.PAGE_LINK);
                writer.writeAttribute(HtmlAttributes.TITLE, TobagoResourceBundle.getString(facesContext, "sheetPagingInfoPagePagingTip"), true);
                if (sheet.getRowCount() != 0) {
                    int pages;
                    Locale locale = facesContext.getViewRoot().getLocale();
                    int first = sheet.getCurrentPage() + 1;
                    boolean unknown = !sheet.hasRowCount();
                    int n = pages = unknown ? -1 : sheet.getPages();
                    String key = unknown ? (first == pages ? "sheetPagingInfoUndefinedSinglePage" : "sheetPagingInfoUndefinedPages") : (first == pages ? "sheetPagingInfoSinglePage" : "sheetPagingInfoPages");
                    String inputMarker = "{#}";
                    Object[] args = new Object[]{"{#}", pages == -1 ? "?" : Integer.valueOf(pages)};
                    MessageFormat detail = new MessageFormat(TobagoResourceBundle.getString(facesContext, key), locale);
                    String formatted = detail.format(args);
                    int pos = formatted.indexOf("{#}");
                    if (pos >= 0) {
                        writer.writeText(formatted.substring(0, pos));
                        writer.startElement(HtmlElements.SPAN);
                        writer.writeClassAttribute(TobagoClass.SHEET__PAGING_OUTPUT);
                        writer.writeText(Integer.toString(first));
                        writer.endElement(HtmlElements.SPAN);
                        writer.startElement(HtmlElements.INPUT);
                        writer.writeIdAttribute(pagerCommandId);
                        writer.writeNameAttribute(pagerCommandId);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.TEXT);
                        writer.writeClassAttribute(TobagoClass.SHEET__PAGING_INPUT);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.VALUE, first);
                        if (!unknown) {
                            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, Integer.toString(pages).length());
                        }
                        writer.endElement(HtmlElements.INPUT);
                        writer.writeText(formatted.substring(pos + "{#}".length()));
                    } else {
                        writer.writeText(formatted);
                    }
                } else {
                    writer.writeText(TobagoResourceBundle.getString(facesContext, "sheetPagingInfoEmptyPage"));
                }
                ComponentUtils.removeFacet((UIComponent)sheet, Facets.pagerPage);
                writer.endElement(HtmlElements.SPAN);
                writer.endElement(HtmlElements.LI);
                if (sheet.isShowPageRangeArrows()) {
                    boolean disabled = sheet.isAtEnd();
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.next, null, Icons.FORWARD, null);
                    this.encodeLink(facesContext, sheet, application, disabled || !sheet.hasRowCount(), SheetAction.last, null, Icons.STEP_FORWARD, null);
                }
                writer.endElement(HtmlElements.UL);
            }
            writer.endElement(HtmlElements.FOOTER);
        }
        if (sheet.isTreeModel()) {
            writer.startElement(HtmlElements.INPUT);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
            String expandedId = sheetId + "::" + "expanded";
            writer.writeNameAttribute(expandedId);
            writer.writeIdAttribute(expandedId);
            writer.writeClassAttribute(TobagoClass.SHEET__EXPANDED);
            writer.writeAttribute(HtmlAttributes.VALUE, expandedValue.toString(), false);
            writer.endElement(HtmlElements.INPUT);
        }
        writer.endElement(HtmlElements.DIV);
        UIComponent header = sheet.getHeader();
        if (header.isTransient()) {
            sheet.getFacets().remove("header");
        }
    }

    private void encodeTableBody(FacesContext facesContext, AbstractUISheet sheet, TobagoResponseWriter writer, String sheetId, Selectable selectable, List<Integer> columnWidths, List<Integer> selectedRows, List<AbstractUIColumnBase> columns, boolean autoLayout, StringBuilder expandedValue) throws IOException {
        ExpandedState expandedState;
        boolean showHeader = sheet.isShowHeader();
        Markup sheetMarkup = sheet.getMarkup() != null ? sheet.getMarkup() : Markup.NULL;
        ExpandedState expandedState2 = expandedState = sheet.isTreeModel() ? sheet.getExpandedState() : null;
        if (showHeader && !autoLayout) {
            writer.startElement(HtmlElements.HEADER);
            writer.writeClassAttribute(TobagoClass.SHEET__HEADER);
            writer.startElement(HtmlElements.TABLE);
            writer.writeAttribute(HtmlAttributes.CELLSPACING, "0", false);
            writer.writeAttribute(HtmlAttributes.CELLPADDING, "0", false);
            writer.writeAttribute(HtmlAttributes.SUMMARY, "", false);
            writer.writeClassAttribute(BootstrapClass.TABLE, TobagoClass.SHEET__HEADER_TABLE, sheetMarkup.contains(Markup.INVERSE) ? BootstrapClass.TABLE_INVERSE : null, sheetMarkup.contains(Markup.DARK) ? BootstrapClass.TABLE_DARK : null, sheetMarkup.contains(Markup.BORDERED) ? BootstrapClass.TABLE_BORDERED : null, sheetMarkup.contains(Markup.SMALL) ? BootstrapClass.TABLE_SM : null, TobagoClass.TABLE_LAYOUT__FIXED);
            this.writeColgroup(writer, columnWidths, columns, true);
            writer.startElement(HtmlElements.TBODY);
            this.encodeHeaderRows(facesContext, sheet, writer, columns);
            writer.endElement(HtmlElements.TBODY);
            writer.endElement(HtmlElements.TABLE);
            writer.endElement(HtmlElements.HEADER);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(sheetId + "::" + "data_div");
        writer.writeClassAttribute(TobagoClass.SHEET__BODY);
        writer.startElement(HtmlElements.TABLE);
        writer.writeAttribute(HtmlAttributes.CELLSPACING, "0", false);
        writer.writeAttribute(HtmlAttributes.CELLPADDING, "0", false);
        writer.writeAttribute(HtmlAttributes.SUMMARY, "", false);
        writer.writeClassAttribute(BootstrapClass.TABLE, TobagoClass.SHEET__BODY_TABLE, sheetMarkup.contains(Markup.INVERSE) ? BootstrapClass.TABLE_INVERSE : null, sheetMarkup.contains(Markup.DARK) ? BootstrapClass.TABLE_DARK : null, sheetMarkup.contains(Markup.STRIPED) ? BootstrapClass.TABLE_STRIPED : null, sheetMarkup.contains(Markup.BORDERED) ? BootstrapClass.TABLE_BORDERED : null, sheetMarkup.contains(Markup.HOVER) ? BootstrapClass.TABLE_HOVER : null, sheetMarkup.contains(Markup.SMALL) ? BootstrapClass.TABLE_SM : null, !autoLayout ? TobagoClass.TABLE_LAYOUT__FIXED : null);
        if (showHeader && autoLayout) {
            writer.startElement(HtmlElements.THEAD);
            this.encodeHeaderRows(facesContext, sheet, writer, columns);
            writer.endElement(HtmlElements.THEAD);
        }
        if (!autoLayout) {
            this.writeColgroup(writer, columnWidths, columns, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("first = " + sheet.getFirst() + "   rows = " + sheet.getRows());
        }
        writer.startElement(HtmlElements.TBODY);
        String var = sheet.getVar();
        boolean emptySheet = true;
        int last = sheet.isRowsUnlimited() ? Integer.MAX_VALUE : sheet.getFirst() + sheet.getRows();
        for (int rowIndex = sheet.getFirst(); rowIndex < last; ++rowIndex) {
            String parentId;
            sheet.setRowIndex(rowIndex);
            if (!sheet.isRowAvailable()) break;
            Object v = sheet.getAttributes().get("rowRendered");
            if (v instanceof Boolean && !((Boolean)v).booleanValue()) continue;
            emptySheet = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("var       " + var);
                LOG.debug("list      " + sheet.getValue());
            }
            if (sheet.isTreeModel()) {
                TreePath path = sheet.getPath();
                if (sheet.isFolder() && expandedState.isExpanded(path)) {
                    expandedValue.append(rowIndex);
                    expandedValue.append(",");
                }
            }
            writer.startElement(HtmlElements.TR);
            writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.ROW_INDEX, rowIndex);
            boolean selected = selectedRows.contains(rowIndex);
            String[] rowMarkups = (String[])sheet.getAttributes().get("rowMarkup");
            Markup rowMarkup = Markup.NULL;
            if (selected) {
                rowMarkup = rowMarkup.add(Markup.SELECTED);
            }
            if (rowMarkups != null) {
                rowMarkup = rowMarkup.add(Markup.valueOf(rowMarkups));
            }
            if ((parentId = sheet.getRowParentClientId()) != null) {
                writer.writeAttribute(DataAttributes.TREE_PARENT, parentId, false);
            }
            String rowClientId = sheet.getRowClientId();
            CustomClass rowClass = null;
            for (UIColumn uIColumn : columns) {
                if (!uIColumn.isRendered() || !(uIColumn instanceof AbstractUIRow)) continue;
                AbstractUIRow row = (AbstractUIRow)uIColumn;
                writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, row)));
                rowClientId = row.getClientId(facesContext);
                rowClass = row.getCustomClass();
            }
            writer.writeIdAttribute(rowClientId);
            writer.writeClassAttribute((CssItem)TobagoClass.SHEET__ROW, TobagoClass.SHEET__ROW.createMarkup(rowMarkup), new CssItem[]{selected ? BootstrapClass.TABLE_INFO : null, rowClass, sheet.isRowVisible() ? null : BootstrapClass.D_NONE});
            for (AbstractUIColumnBase abstractUIColumnBase : columns) {
                if (!abstractUIColumnBase.isRendered() || !(abstractUIColumnBase instanceof AbstractUIColumn) && !(abstractUIColumnBase instanceof AbstractUIColumnSelector) && !(abstractUIColumnBase instanceof AbstractUIColumnNode)) continue;
                writer.startElement(HtmlElements.TD);
                Markup markup = abstractUIColumnBase.getMarkup();
                if (markup == null) {
                    markup = Markup.NULL;
                }
                if (abstractUIColumnBase instanceof AbstractUIColumn) {
                    AbstractUIColumn normalColumn = (AbstractUIColumn)abstractUIColumnBase;
                    markup = markup.add(this.getMarkupForAlign(normalColumn));
                    markup = markup.add(this.getMarkupForVerticalAlign(normalColumn));
                }
                writer.writeClassAttribute((CssItem)TobagoClass.SHEET__CELL, TobagoClass.SHEET__CELL.createMarkup(markup), new CssItem[]{abstractUIColumnBase.getCustomClass()});
                if (abstractUIColumnBase instanceof AbstractUIColumnSelector) {
                    AbstractUIColumnSelector selector = (AbstractUIColumnSelector)abstractUIColumnBase;
                    writer.startElement(HtmlElements.INPUT);
                    writer.writeNameAttribute(sheetId + "_data_row_selector_" + rowIndex);
                    if (selectable.isSingle()) {
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.RADIO);
                    } else {
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                    }
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, selected);
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, selector.isDisabled());
                    writer.writeClassAttribute(BootstrapClass.FORM_CHECK_INLINE, TobagoClass.SHEET__COLUMN_SELECTOR);
                    writer.endElement(HtmlElements.INPUT);
                } else {
                    abstractUIColumnBase.encodeAll(facesContext);
                }
                writer.endElement(HtmlElements.TD);
            }
            if (!autoLayout) {
                writer.startElement(HtmlElements.TD);
                writer.writeClassAttribute((CssItem)TobagoClass.SHEET__CELL, TobagoClass.SHEET__CELL.createMarkup(Markup.FILLER), new CssItem[0]);
                writer.startElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.TD);
            }
            writer.endElement(HtmlElements.TR);
        }
        sheet.setRowIndex(-1);
        if (emptySheet && showHeader) {
            writer.startElement(HtmlElements.TR);
            for (UIColumn uIColumn : columns) {
                if (uIColumn instanceof AbstractUIRow) continue;
                writer.startElement(HtmlElements.TD);
                writer.startElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.TD);
            }
            if (!autoLayout) {
                writer.startElement(HtmlElements.TD);
                writer.writeClassAttribute((CssItem)TobagoClass.SHEET__CELL, TobagoClass.SHEET__CELL.createMarkup(Markup.FILLER), new CssItem[0]);
                writer.startElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.TD);
            }
            writer.endElement(HtmlElements.TR);
        }
        writer.endElement(HtmlElements.TBODY);
        writer.endElement(HtmlElements.TABLE);
        writer.endElement(HtmlElements.DIV);
    }

    private void encodeHiddenInput(TobagoResponseWriter writer, String value, String idWithSuffix) throws IOException {
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(idWithSuffix);
        writer.writeNameAttribute(idWithSuffix);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.VALUE, value, false);
        writer.endElement(HtmlElements.INPUT);
    }

    private void ensureColumnWidthsSize(List<Integer> columnWidths, List<AbstractUIColumnBase> columns, List<Integer> samples) {
        int i = 0;
        int j = 0;
        for (AbstractUIColumnBase column : columns) {
            Integer newValue;
            if (column instanceof AbstractUIRow) continue;
            if (j < samples.size()) {
                newValue = samples.get(j);
                ++j;
            } else {
                newValue = null;
            }
            if (columnWidths.size() > i) {
                if (newValue != null) {
                    columnWidths.set(i, newValue);
                }
            } else {
                columnWidths.add(newValue != null ? newValue : -1);
            }
            ++i;
        }
    }

    private Markup getMarkupForAlign(UIColumn column) {
        String textAlign = ComponentUtils.getStringAttribute((UIComponent)column, Attributes.align);
        if (textAlign != null) {
            switch (TextAlign.valueOf(textAlign)) {
                case right: {
                    return Markup.RIGHT;
                }
                case center: {
                    return Markup.CENTER;
                }
                case justify: {
                    return Markup.JUSTIFY;
                }
            }
        }
        return null;
    }

    private Markup getMarkupForVerticalAlign(AbstractUIColumn column) {
        VerticalAlign verticalAlign = column.getVerticalAlign();
        if (verticalAlign != null) {
            switch (verticalAlign) {
                case bottom: {
                    return Markup.BOTTOM;
                }
                case middle: {
                    return Markup.MIDDLE;
                }
            }
        }
        return null;
    }

    private void encodeHeaderRows(FacesContext facesContext, AbstractUISheet sheet, TobagoResponseWriter writer, List<AbstractUIColumnBase> columns) throws IOException {
        Selectable selectable = sheet.getSelectable();
        Grid grid = sheet.getHeaderGrid();
        boolean autoLayout = sheet.isAutoLayout();
        boolean multiHeader = grid.getRowCount() > 1;
        int offset = 0;
        for (int i = 0; i < grid.getRowCount(); ++i) {
            writer.startElement(HtmlElements.TR);
            AbstractUIRow row = ComponentUtils.findChild((UIComponent)sheet, AbstractUIRow.class);
            if (row != null) {
                writer.writeClassAttribute(row.getCustomClass());
            }
            for (int j = 0; j < columns.size(); ++j) {
                boolean sortable;
                Markup align;
                AbstractUIColumnBase column = columns.get(j);
                if (!column.isRendered() || column instanceof AbstractUIRow) {
                    ++offset;
                    continue;
                }
                Cell cell = grid.getCell(j - offset, i);
                if (!(cell instanceof OriginCell)) continue;
                writer.startElement(HtmlElements.TH);
                if (cell.getColumnSpan() > 1) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.COLSPAN, cell.getColumnSpan());
                }
                if (cell.getRowSpan() > 1) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROWSPAN, cell.getRowSpan());
                }
                UIComponent cellComponent = cell.getComponent();
                String alignString = ComponentUtils.getStringAttribute((UIComponent)column, Attributes.align);
                if (multiHeader && cell.getColumnSpan() > 1) {
                    align = Markup.CENTER;
                } else if (alignString != null) {
                    switch (TextAlign.valueOf(alignString)) {
                        case right: {
                            align = Markup.RIGHT;
                            break;
                        }
                        case center: {
                            align = Markup.CENTER;
                            break;
                        }
                        case justify: {
                            align = Markup.JUSTIFY;
                            break;
                        }
                        default: {
                            align = null;
                            break;
                        }
                    }
                } else {
                    align = null;
                }
                writer.writeClassAttribute((CssItem)TobagoClass.SHEET__HEADER_CELL, TobagoClass.SHEET__CELL.createMarkup(align), new CssItem[]{column.getCustomClass()});
                writer.startElement(HtmlElements.SPAN);
                Markup markup = Markup.NULL;
                String tip = ComponentUtils.getStringAttribute((UIComponent)column, Attributes.tip);
                if (cell.getColumnSpan() == 1 && cellComponent instanceof AbstractUIOut && (sortable = ComponentUtils.getBooleanAttribute((UIComponent)column, Attributes.sortable))) {
                    AbstractUILink sortCommand = (AbstractUILink)ComponentUtils.getFacet((UIComponent)column, Facets.sorter);
                    if (sortCommand == null) {
                        column.getClientId(facesContext);
                        String sorterId = column.getId() + "_" + "sorter";
                        sortCommand = (AbstractUILink)ComponentUtils.createComponent(facesContext, Tags.link.componentType(), RendererTypes.Link, sorterId);
                        sortCommand.setTransient(true);
                        AjaxBehavior reloadBehavior = this.createReloadBehavior(sheet);
                        sortCommand.addClientBehavior("click", (ClientBehavior)reloadBehavior);
                        ComponentUtils.setFacet((UIComponent)column, Facets.sorter, (UIComponent)sortCommand);
                    }
                    writer.writeIdAttribute(sortCommand.getClientId(facesContext));
                    writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, sortCommand)));
                    ComponentUtils.removeFacet((UIComponent)column, Facets.sorter);
                    tip = tip == null ? "" : tip + " - ";
                    tip = tip + TobagoResourceBundle.getString(facesContext, "sheetTipSorting");
                    markup = markup.add(Markup.SORTABLE);
                    SheetState sheetState = sheet.getSheetState(facesContext);
                    if (column.getId().equals(sheetState.getSortedColumnId())) {
                        String sortTitle;
                        if (sheetState.isAscending()) {
                            sortTitle = TobagoResourceBundle.getString(facesContext, "sheetAscending");
                            markup = markup.add(Markup.ASCENDING);
                        } else {
                            sortTitle = TobagoResourceBundle.getString(facesContext, "sheetDescending");
                            markup = markup.add(Markup.DESCENDING);
                        }
                        if (sortTitle != null) {
                            tip = tip + " - " + sortTitle;
                        }
                    }
                }
                writer.writeClassAttribute((CssItem)TobagoClass.SHEET__HEADER, TobagoClass.SHEET__HEADER.createMarkup(markup), new CssItem[0]);
                writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
                if (column instanceof AbstractUIColumnSelector && selectable.isMulti()) {
                    writer.startElement(HtmlElements.INPUT);
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                    writer.writeClassAttribute(TobagoClass.SHEET__COLUMN_SELECTOR);
                    writer.writeAttribute(HtmlAttributes.TITLE, TobagoResourceBundle.getString(facesContext, "sheetMenuSelect"), true);
                    writer.endElement(HtmlElements.INPUT);
                } else {
                    cellComponent.encodeAll(facesContext);
                }
                writer.endElement(HtmlElements.SPAN);
                if (!autoLayout && column.isResizable()) {
                    this.encodeResizing(writer, sheet, j - offset + cell.getColumnSpan() - 1);
                }
                writer.endElement(HtmlElements.TH);
            }
            if (!autoLayout) {
                this.encodeHeaderFiller(writer, sheet);
                this.encodeHeaderFiller(writer, sheet);
            }
            writer.endElement(HtmlElements.TR);
        }
    }

    private void encodeHeaderFiller(TobagoResponseWriter writer, AbstractUISheet sheet) throws IOException {
        writer.startElement(HtmlElements.TH);
        writer.writeClassAttribute((CssItem)TobagoClass.SHEET__HEADER_CELL, TobagoClass.SHEET__HEADER_CELL.createMarkup(Markup.FILLER), new CssItem[0]);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.SHEET__HEADER);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.TH);
    }

    private void writeColgroup(TobagoResponseWriter writer, List<Integer> columnWidths, List<AbstractUIColumnBase> columns, boolean isHeader) throws IOException {
        writer.startElement(HtmlElements.COLGROUP);
        int i = 0;
        for (AbstractUIColumnBase column : columns) {
            if (column instanceof AbstractUIRow) continue;
            if (column.isRendered()) {
                Integer width = columnWidths.get(i);
                this.writeCol(writer, width >= 0 ? width : null);
            }
            ++i;
        }
        this.writeCol(writer, 0);
        this.writeCol(writer, 20);
        writer.endElement(HtmlElements.COLGROUP);
    }

    private void writeCol(TobagoResponseWriter writer, Integer columnWidth) throws IOException {
        writer.startElement(HtmlElements.COL);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.WIDTH, columnWidth);
        writer.endElement(HtmlElements.COL);
    }

    private Markup markupForLeftCenterRight(ShowPosition position) {
        switch (position) {
            case left: {
                return Markup.LEFT;
            }
            case center: {
                return Markup.CENTER;
            }
            case right: {
                return Markup.RIGHT;
            }
        }
        return Markup.NULL;
    }

    public boolean getRendersChildren() {
        return true;
    }

    private List<Integer> getSelectedRows(AbstractUISheet data, SheetState state) {
        List<Integer> selected = (List<Integer>)ComponentUtils.getAttribute((UIComponent)data, Attributes.selectedListString);
        if (selected == null && state != null) {
            selected = state.getSelectedRows();
        }
        if (selected == null) {
            selected = Collections.emptyList();
        }
        return selected;
    }

    private void encodeLink(FacesContext facesContext, AbstractUISheet data, Application application, boolean disabled, SheetAction action, Integer target, Icons icon, CssItem liClass) throws IOException {
        String facet = action == SheetAction.toPage || action == SheetAction.toRow ? action.name() + "-" + target : action.name();
        AbstractUILink command = this.ensurePagingCommand(facesContext, data, facet, facet, disabled);
        if (target != null) {
            ComponentUtils.setAttribute((UIComponent)command, Attributes.pagingTarget, target);
        }
        Locale locale = facesContext.getViewRoot().getLocale();
        String message = TobagoResourceBundle.getString(facesContext, action.getBundleKey());
        String tip = new MessageFormat(message, locale).format(new Integer[]{target});
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.LI);
        writer.writeClassAttribute(liClass, disabled ? BootstrapClass.DISABLED : null, BootstrapClass.PAGE_ITEM);
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(BootstrapClass.PAGE_LINK);
        writer.writeIdAttribute(command.getClientId(facesContext));
        writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        if (!disabled) {
            writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, command)));
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        if (icon != null) {
            writer.startElement(HtmlElements.I);
            writer.writeClassAttribute(Icons.FA, icon);
            writer.endElement(HtmlElements.I);
        } else {
            writer.writeText(String.valueOf(target));
        }
        data.getFacets().remove(facet);
        writer.endElement(HtmlElements.BUTTON);
        writer.endElement(HtmlElements.LI);
    }

    private void encodeResizing(TobagoResponseWriter writer, AbstractUISheet sheet, int columnIndex) throws IOException {
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.SHEET__HEADER_RESIZE);
        writer.writeAttribute(DataAttributes.COLUMN_INDEX, Integer.toString(columnIndex), false);
        writer.write("&nbsp;&nbsp;");
        writer.endElement(HtmlElements.SPAN);
    }

    private void encodeDirectPagingLinks(FacesContext facesContext, Application application, AbstractUISheet sheet) throws IOException {
        int skip;
        int linkCount = ComponentUtils.getIntAttribute((UIComponent)sheet, Attributes.directLinkCount);
        ArrayList<Integer> prevs = new ArrayList<Integer>(--linkCount);
        int page = sheet.getCurrentPage() + 1;
        for (int i = 0; i < linkCount && page > 1; ++i) {
            if (--page <= 0) continue;
            prevs.add(0, page);
        }
        ArrayList<Integer> nexts = new ArrayList<Integer>(linkCount);
        page = sheet.getCurrentPage() + 1;
        int pages = sheet.hasRowCount() || sheet.isRowsUnlimited() ? sheet.getPages() : Integer.MAX_VALUE;
        for (int i = 0; i < linkCount && page < pages; ++i) {
            if (++page <= 1) continue;
            nexts.add(page);
        }
        if (prevs.size() > linkCount / 2 && nexts.size() > linkCount - linkCount / 2) {
            while (prevs.size() > linkCount / 2) {
                prevs.remove(0);
            }
            while (nexts.size() > linkCount - linkCount / 2) {
                nexts.remove(nexts.size() - 1);
            }
        } else if (prevs.size() <= linkCount / 2) {
            while (prevs.size() + nexts.size() > linkCount) {
                nexts.remove(nexts.size() - 1);
            }
        } else {
            while (prevs.size() + nexts.size() > linkCount) {
                prevs.remove(0);
            }
        }
        int n = skip = prevs.size() > 0 ? (Integer)prevs.get(0) : 1;
        if (!sheet.isShowDirectLinksArrows() && skip > 1) {
            skip -= linkCount - linkCount / 2;
            if (--skip < 1) {
                skip = 1;
            }
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, skip, Icons.ELLIPSIS_H, null);
        }
        for (Integer prev : prevs) {
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, prev, null, null);
        }
        this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, sheet.getCurrentPage() + 1, null, BootstrapClass.ACTIVE);
        for (Integer next : nexts) {
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, next, null, null);
        }
        int n2 = skip = nexts.size() > 0 ? (Integer)nexts.get(nexts.size() - 1) : pages;
        if (!sheet.isShowDirectLinksArrows() && skip < pages) {
            skip += linkCount / 2;
            if (++skip > pages) {
                skip = pages;
            }
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, skip, Icons.ELLIPSIS_H, null);
        }
    }

    private AbstractUILink ensurePagingCommand(FacesContext facesContext, AbstractUISheet sheet, String facet, String id, boolean disabled) {
        Map facets = sheet.getFacets();
        AbstractUILink command = (AbstractUILink)facets.get(facet);
        if (command == null) {
            command = (AbstractUILink)ComponentUtils.createComponent(facesContext, Tags.link.componentType(), RendererTypes.Link, SUFFIX_PAGE_ACTION + id);
            command.setRendered(true);
            command.setDisabled(disabled);
            command.setTransient(true);
            facets.put(facet, command);
            AjaxBehavior behavior = this.createReloadBehavior(sheet);
            command.addClientBehavior("click", (ClientBehavior)behavior);
        }
        return command;
    }

    private AjaxBehavior createReloadBehavior(AbstractUISheet sheet) {
        ArrayList<String> executeIds;
        AjaxBehavior reloadBehavior = this.findReloadBehavior(sheet);
        ArrayList<String> renderIds = new ArrayList<String>();
        if (!renderIds.contains(sheet.getId())) {
            renderIds.add(sheet.getId());
        }
        if (reloadBehavior != null) {
            renderIds.addAll(reloadBehavior.getRender());
        }
        if (!(executeIds = new ArrayList<String>()).contains(sheet.getId())) {
            executeIds.add(sheet.getId());
        }
        if (reloadBehavior != null) {
            executeIds.addAll(reloadBehavior.getExecute());
        }
        AjaxBehavior behavior = new AjaxBehavior();
        behavior.setExecute(executeIds);
        behavior.setRender(renderIds);
        behavior.setTransient(true);
        return behavior;
    }

    private AjaxBehavior findReloadBehavior(ClientBehaviorHolder holder) {
        List reload = (List)holder.getClientBehaviors().get("reload");
        if (reload != null && !reload.isEmpty() && reload.get(0) instanceof AjaxBehavior) {
            return (AjaxBehavior)reload.get(0);
        }
        return null;
    }
}

