/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum HtmlElements {
    A("a", Qualifier.INLINE),
    ABBR("abbr", Qualifier.INLINE),
    ADDRESS("address", new Qualifier[0]),
    AREA("area", Qualifier.VOID),
    ARTICLE("article", new Qualifier[0]),
    ASIDE("aside", new Qualifier[0]),
    AUDIO("audio", new Qualifier[0]),
    B("b", Qualifier.INLINE),
    BASE("base", Qualifier.VOID),
    BDI("bdi", new Qualifier[0]),
    BDO("bdo", new Qualifier[0]),
    BLOCKQUOTE("blockquote", new Qualifier[0]),
    BODY("body", new Qualifier[0]),
    BR("br", Qualifier.VOID),
    BUTTON("button", Qualifier.INLINE),
    CANVAS("canvas", new Qualifier[0]),
    CAPTION("caption", new Qualifier[0]),
    CITE("cite", Qualifier.INLINE),
    CODE("code", Qualifier.INLINE),
    COL("col", Qualifier.VOID),
    COLGROUP("colgroup", new Qualifier[0]),
    COMMAND("command", Qualifier.VOID),
    DATALIST("datalist", new Qualifier[0]),
    DD("dd", new Qualifier[0]),
    DEL("del", new Qualifier[0]),
    DETAILS("details", new Qualifier[0]),
    DFN("dfn", new Qualifier[0]),
    DIV("div", new Qualifier[0]),
    DL("dl", new Qualifier[0]),
    DT("dt", new Qualifier[0]),
    EM("em", Qualifier.INLINE),
    EMBED("embed", Qualifier.VOID),
    FIELDSET("fieldset", new Qualifier[0]),
    FIGCAPTION("figcaption", new Qualifier[0]),
    FIGURE("figure", new Qualifier[0]),
    FOOTER("footer", new Qualifier[0]),
    FORM("form", new Qualifier[0]),
    H1("h1", new Qualifier[0]),
    H2("h2", new Qualifier[0]),
    H3("h3", new Qualifier[0]),
    H4("h4", new Qualifier[0]),
    H5("h5", new Qualifier[0]),
    H6("h6", new Qualifier[0]),
    HEAD("head", new Qualifier[0]),
    HEADER("header", new Qualifier[0]),
    HGROUP("hgroup", new Qualifier[0]),
    HR("hr", Qualifier.VOID),
    HTML("html", new Qualifier[0]),
    I("i", Qualifier.INLINE),
    IFRAME("iframe", new Qualifier[0]),
    IMG("img", Qualifier.VOID, Qualifier.INLINE),
    INPUT("input", Qualifier.VOID, Qualifier.INLINE),
    INS("ins", new Qualifier[0]),
    KBD("kbd", new Qualifier[0]),
    KEYGEN("keygen", Qualifier.VOID),
    LABEL("label", Qualifier.INLINE),
    LEGEND("legend", new Qualifier[0]),
    LI("li", new Qualifier[0]),
    LINK("link", Qualifier.VOID),
    MAP("map", new Qualifier[0]),
    MARK("mark", new Qualifier[0]),
    MENU("menu", new Qualifier[0]),
    META("meta", Qualifier.VOID),
    METER("meter", new Qualifier[0]),
    NAV("nav", new Qualifier[0]),
    NOSCRIPT("noscript", new Qualifier[0]),
    OBJECT("object", new Qualifier[0]),
    OL("ol", new Qualifier[0]),
    OPTGROUP("optgroup", new Qualifier[0]),
    OPTION("option", new Qualifier[0]),
    P("p", new Qualifier[0]),
    PARAM("param", Qualifier.VOID),
    PRE("pre", Qualifier.INLINE),
    PROGRESS("progress", new Qualifier[0]),
    Q("q", new Qualifier[0]),
    RP("rp", new Qualifier[0]),
    RT("rt", new Qualifier[0]),
    RUBY("ruby", new Qualifier[0]),
    S("s", new Qualifier[0]),
    SAMP("samp", new Qualifier[0]),
    SCRIPT("script", Qualifier.INLINE),
    SECTION("section", new Qualifier[0]),
    SELECT("select", Qualifier.INLINE),
    SMALL("small", new Qualifier[0]),
    SOURCE("source", Qualifier.VOID),
    SPAN("span", Qualifier.INLINE),
    STRONG("strong", new Qualifier[0]),
    STYLE("style", new Qualifier[0]),
    SUB("sub", Qualifier.INLINE),
    SUMMARY("summary", new Qualifier[0]),
    SUP("sup", Qualifier.INLINE),
    TABLE("table", new Qualifier[0]),
    TBODY("tbody", new Qualifier[0]),
    TD("td", new Qualifier[0]),
    TEXTAREA("textarea", Qualifier.INLINE),
    TFOOT("tfoot", new Qualifier[0]),
    TH("th", new Qualifier[0]),
    THEAD("thead", new Qualifier[0]),
    TIME("time", new Qualifier[0]),
    TITLE("title", new Qualifier[0]),
    TR("tr", new Qualifier[0]),
    TRACK("track", Qualifier.VOID),
    U("u", Qualifier.INLINE),
    UL("ul", new Qualifier[0]),
    VAR("var", new Qualifier[0]),
    VIDEO("video", new Qualifier[0]),
    WBR("wbr", Qualifier.VOID),
    TOBAGO_BADGE("tobago-badge", new Qualifier[0]),
    TOBAGO_BAR("tobago-bar", new Qualifier[0]),
    TOBAGO_BEHAVIOR("tobago-behavior", Qualifier.INLINE),
    TOBAGO_BUTTONS("tobago-buttons", new Qualifier[0]),
    TOBAGO_BOX("tobago-box", new Qualifier[0]),
    TOBAGO_CONFIG("tobago-config", new Qualifier[0]),
    TOBAGO_DATE("tobago-date", new Qualifier[0]),
    TOBAGO_DROPDOWN("tobago-dropdown", new Qualifier[0]),
    TOBAGO_FILE("tobago-file", new Qualifier[0]),
    TOBAGO_FLEX_LAYOUT("tobago-flex-layout", new Qualifier[0]),
    TOBAGO_FLOW_LAYOUT("tobago-flow-layout", new Qualifier[0]),
    TOBAGO_FOCUS("tobago-focus", new Qualifier[0]),
    TOBAGO_FOOTER("tobago-footer", new Qualifier[0]),
    TOBAGO_FORM("tobago-form", new Qualifier[0]),
    TOBAGO_GRID_LAYOUT("tobago-grid-layout", new Qualifier[0]),
    TOBAGO_HEADER("tobago-header", new Qualifier[0]),
    TOBAGO_IMAGE("tobago-image", new Qualifier[0]),
    TOBAGO_IN("tobago-in", new Qualifier[0]),
    TOBAGO_LINKS("tobago-links", new Qualifier[0]),
    TOBAGO_MESSAGES("tobago-messages", new Qualifier[0]),
    TOBAGO_OUT("tobago-out", Qualifier.INLINE),
    TOBAGO_PAGE("tobago-page", new Qualifier[0]),
    TOBAGO_PANEL("tobago-panel", new Qualifier[0]),
    TOBAGO_POPOVER("tobago-popover", new Qualifier[0]),
    TOBAGO_POPUP("tobago-popup", new Qualifier[0]),
    TOBAGO_PROGRESS("tobago-progress", new Qualifier[0]),
    TOBAGO_RANGE("tobago-range", new Qualifier[0]),
    TOBAGO_RELOAD("tobago-reload", new Qualifier[0]),
    TOBAGO_SCROLL("tobago-scroll", new Qualifier[0]),
    TOBAGO_SECTION("tobago-section", new Qualifier[0]),
    TOBAGO_SEGMENT_LAYOUT("tobago-segment-layout", new Qualifier[0]),
    TOBAGO_SELECT_BOOLEAN_CHECKBOX("tobago-select-boolean-checkbox", new Qualifier[0]),
    TOBAGO_SELECT_BOOLEAN_TOGGLE("tobago-select-boolean-toggle", new Qualifier[0]),
    TOBAGO_SELECT_MANY_CHECKBOX("tobago-select-many-checkbox", new Qualifier[0]),
    TOBAGO_SELECT_MANY_LIST("tobago-select-many-list", new Qualifier[0]),
    TOBAGO_SELECT_MANY_LISTBOX("tobago-select-many-listbox", new Qualifier[0]),
    TOBAGO_SELECT_MANY_SHUTTLE("tobago-select-many-shuttle", new Qualifier[0]),
    TOBAGO_SELECT_ONE_CHOICE("tobago-select-one-choice", new Qualifier[0]),
    TOBAGO_SELECT_ONE_LISTBOX("tobago-select-one-listbox", new Qualifier[0]),
    TOBAGO_SELECT_ONE_RADIO("tobago-select-one-radio", new Qualifier[0]),
    TOBAGO_SEPARATOR("tobago-separator", new Qualifier[0]),
    TOBAGO_SHEET("tobago-sheet", new Qualifier[0]),
    TOBAGO_SPLIT_LAYOUT("tobago-split-layout", new Qualifier[0]),
    TOBAGO_STARS("tobago-stars", new Qualifier[0]),
    TOBAGO_SUGGEST("tobago-suggest", new Qualifier[0]),
    TOBAGO_TAB("tobago-tab", new Qualifier[0]),
    TOBAGO_TAB_GROUP("tobago-tab-group", new Qualifier[0]),
    TOBAGO_TEXTAREA("tobago-textarea", new Qualifier[0]),
    TOBAGO_TREE("tobago-tree", new Qualifier[0]),
    TOBAGO_TREE_LISTBOX("tobago-tree-listbox", new Qualifier[0]),
    TOBAGO_TREE_NODE("tobago-tree-node", new Qualifier[0]),
    TOBAGO_TREE_SELECT("tobago-tree-select", new Qualifier[0]);

    private final String value;
    private final boolean voidElement;
    private final boolean inlineElement;
    private static final Set<String> VOIDS;
    private static final Set<String> INLINES;

    private HtmlElements(String value, Qualifier ... qualifiers) {
        this.value = value;
        this.voidElement = Arrays.asList(qualifiers).contains((Object)Qualifier.VOID);
        this.inlineElement = Arrays.asList(qualifiers).contains((Object)Qualifier.INLINE);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isVoid() {
        return this.voidElement;
    }

    public boolean isInline() {
        return this.inlineElement;
    }

    public static boolean isVoid(String name) {
        return VOIDS.contains(name);
    }

    public static boolean isInline(String name) {
        return INLINES.contains(name);
    }

    static {
        VOIDS = new HashSet<String>();
        INLINES = new HashSet<String>();
        for (HtmlElements htmlElement : HtmlElements.values()) {
            if (htmlElement.isVoid()) {
                VOIDS.add(htmlElement.getValue());
            }
            if (!htmlElement.isInline()) continue;
            INLINES.add(htmlElement.getValue());
        }
    }

    private static enum Qualifier {
        VOID,
        INLINE;

    }
}

