/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.internal.component.AbstractUIDate;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecorationPositionRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.model.DateType;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateRenderer<T extends AbstractUIDate>
extends DecorationPositionRendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String TYPE_DATE = "date";
    private static final String TYPE_TIME = "time";
    private static final String TYPE_BOTH = "both";
    private static final String TYPE_LOCAL_DATE = "localDate";
    private static final String TYPE_LOCAL_TIME = "localTime";
    private static final String TYPE_LOCAL_DATE_TIME = "localDateTime";
    private static final String TYPE_OFFSET_TIME = "offsetTime";
    private static final String TYPE_OFFSET_DATE_TIME = "offsetDateTime";
    private static final String TYPE_ZONED_DATE_TIME = "zonedDateTime";
    private static final String TYPE_MONTH = "month";
    private static final String TYPE_WEEK = "week";

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        this.prepare(facesContext, component);
        super.encodeBeginInternal(facesContext, component);
    }

    @Override
    protected boolean isOutputOnly(T component) {
        return ((AbstractUIInput)component).isDisabled() || ((AbstractUIInput)component).isReadonly();
    }

    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_DATE;
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, T date) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UIComponent after = ComponentUtils.getFacet(date, Facets.after);
        UIComponent before = ComponentUtils.getFacet(date, Facets.before);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.INPUT_GROUP);
        this.encodeGroupAddon(facesContext, writer, before, false);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, date);
        DateType type = ((AbstractUIDate)date).getType();
        String currentValue = this.getCurrentValue(facesContext, date);
        String clientId = date.getClientId(facesContext);
        String fieldId = ((AbstractUIInput)date).getFieldId(facesContext);
        boolean readonly = ((AbstractUIInput)date).isReadonly();
        boolean disabled = ((AbstractUIInput)date).isDisabled();
        boolean required = ComponentUtils.getBooleanAttribute(date, Attributes.required);
        writer.startElement(HtmlElements.INPUT);
        if (date.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(date.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, date.getAccessKey(), clientId);
        }
        writer.writeAttribute(HtmlAttributes.TYPE, type.getName(), false);
        Double step = ((AbstractUIDate)date).getStep();
        if (step != null) {
            writer.writeAttribute(HtmlAttributes.STEP, Double.toString(step), false);
        }
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, date);
        writer.writeAttribute(HtmlAttributes.VALUE, currentValue, true);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUIInput)date).getTabIndex());
        writer.writeAttribute(HtmlAttributes.MIN, this.convertToString(((AbstractUIDate)date).getMin()), true);
        writer.writeAttribute(HtmlAttributes.MAX, this.convertToString(((AbstractUIDate)date).getMax()), true);
        writer.writeClassAttribute(BootstrapClass.validationColor(ComponentUtils.getMaximumSeverity(date)), BootstrapClass.FORM_CONTROL, date.getCustomClass());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
        DateRenderer.renderFocus(clientId, ((AbstractUIInput)date).isFocus(), ((AbstractUIInput)date).isError(), facesContext, writer);
        writer.endElement(HtmlElements.INPUT);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)date);
        this.encodeGroupAddon(facesContext, writer, after, true);
        if (((AbstractUIDate)date).isTodayButton()) {
            this.encodeButton(facesContext, date, type);
        }
    }

    private String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof LocalDate) {
            return ((LocalDate)value).format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        LOG.warn("Unknown type for min/max: '{}'", value);
        return value.toString();
    }

    private void encodeButton(FacesContext facesContext, T component, DateType type) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String title = ResourceUtils.getString(facesContext, type == DateType.DATETIME_LOCAL || type == DateType.TIME ? "date.now" : "date.today");
        writer.startElement(HtmlElements.BUTTON);
        writer.writeClassAttribute(BootstrapClass.BTN, BootstrapClass.BTN_SECONDARY, TobagoClass.NOW);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, ((AbstractUIInput)component).isDisabled() || ((AbstractUIInput)component).isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUIInput)component).getTabIndex());
        writer.startElement(HtmlElements.I);
        writer.writeClassAttribute(Icons.ARROW_DOWN);
        writer.endElement(HtmlElements.I);
        writer.endElement(HtmlElements.BUTTON);
    }

    @Override
    public void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUIInput)component).getFieldId(facesContext);
    }

    @Override
    protected Converter getConverter(FacesContext facesContext, T component, Object value) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        Class<Object> estimatedType = this.estimateValueType(facesContext, component);
        if (estimatedType == null) {
            LOG.warn("Can't estimate type (clientId='{}')!", (Object)component.getClientId(facesContext));
            return null;
        }
        if (estimatedType.isAssignableFrom(String.class)) {
            LOG.warn("No converter for java.lang.String");
            return null;
        }
        DateTimeConverter dateTimeConverter = (DateTimeConverter)facesContext.getApplication().createConverter("javax.faces.DateTime");
        if (estimatedType.isAssignableFrom(LocalDateTime.class)) {
            dateTimeConverter.setType(TYPE_LOCAL_DATE_TIME);
            Double step = ((AbstractUIDate)component).getStep();
            if (step == null || step >= 60.0) {
                dateTimeConverter.setPattern("yyyy-MM-dd'T'HH:mm");
            } else if (step >= 1.0) {
                dateTimeConverter.setPattern("yyyy-MM-dd'T'HH:mm:ss");
            } else {
                dateTimeConverter.setPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
            }
        } else if (estimatedType.isAssignableFrom(LocalDate.class)) {
            dateTimeConverter.setType(TYPE_LOCAL_DATE);
            dateTimeConverter.setPattern("yyyy-MM-dd");
        } else if (estimatedType.isAssignableFrom(LocalTime.class)) {
            dateTimeConverter.setType(TYPE_LOCAL_TIME);
            Double step = ((AbstractUIDate)component).getStep();
            if (step == null || step >= 60.0) {
                dateTimeConverter.setPattern("HH:mm");
            } else if (step >= 1.0) {
                dateTimeConverter.setPattern("HH:mm:ss");
            } else {
                dateTimeConverter.setPattern("HH:mm:ss.SSS");
            }
        } else if (estimatedType.isAssignableFrom(ZonedDateTime.class)) {
            dateTimeConverter.setType(TYPE_ZONED_DATE_TIME);
            Double step = ((AbstractUIDate)component).getStep();
            if (step == null || step >= 60.0) {
                dateTimeConverter.setPattern("yyyy-MM-dd'T'HH:mm");
            } else if (step >= 1.0) {
                dateTimeConverter.setPattern("yyyy-MM-dd'T'HH:mm:ss");
            } else {
                dateTimeConverter.setPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
            }
        } else if (estimatedType.isAssignableFrom(Long.class)) {
            dateTimeConverter.setType(TYPE_DATE);
            dateTimeConverter.setPattern("yyyy-MM-dd");
        } else if (estimatedType.isAssignableFrom(Date.class)) {
            dateTimeConverter.setType(TYPE_DATE);
            DateType type = ((AbstractUIDate)component).getType();
            if (DateType.DATETIME_LOCAL.equals(type)) {
                Double step = ((AbstractUIDate)component).getStep();
                if (step == null || step >= 60.0) {
                    dateTimeConverter.setPattern("yyyy-MM-dd'T'HH:mm");
                } else if (step >= 1.0) {
                    dateTimeConverter.setPattern("yyyy-MM-dd'T'HH:mm:ss");
                } else {
                    dateTimeConverter.setPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
                }
            } else if (DateType.TIME.equals(type)) {
                Double step = ((AbstractUIDate)component).getStep();
                if (step == null || step >= 60.0) {
                    dateTimeConverter.setPattern("HH:mm");
                } else if (step >= 1.0) {
                    dateTimeConverter.setPattern("HH:mm:ss");
                } else {
                    dateTimeConverter.setPattern("HH:mm:ss.SSS");
                }
            } else {
                dateTimeConverter.setPattern("yyyy-MM-dd");
            }
        } else if (estimatedType.isAssignableFrom(Number.class)) {
            LOG.error(TYPE_DATE);
            dateTimeConverter.setType(TYPE_DATE);
            dateTimeConverter.setPattern("yyyy-MM-dd");
        } else {
            LOG.warn("Type might not be supported (type='{}' clientId='{}')!", (Object)estimatedType.getName(), (Object)component.getClientId(facesContext));
            throw new RuntimeException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("type='{}' pattern='{}'", (Object)dateTimeConverter.getType(), (Object)dateTimeConverter.getPattern());
        }
        return dateTimeConverter;
    }

    private Class<?> estimateValueType(FacesContext facesContext, T component) {
        Object value;
        Object submittedValue;
        Class<?> estimatedType = null;
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression != null) {
            try {
                estimatedType = valueExpression.getType(facesContext.getELContext());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (estimatedType == null && (submittedValue = component.getSubmittedValue()) != null) {
            estimatedType = submittedValue.getClass();
        }
        if (estimatedType == null && (value = component.getValue()) != null) {
            estimatedType = value.getClass();
        }
        return estimatedType;
    }

    private void prepare(FacesContext facesContext, T component) {
        Converter someConverter;
        DateType type = ((AbstractUIDate)component).getType();
        String pattern = ((AbstractUIDate)component).getPattern();
        DateTimeConverter converter = null;
        if ((type == null || pattern == null) && (someConverter = this.getConverter(facesContext, component, component.getSubmittedValue())) instanceof DateTimeConverter) {
            converter = (DateTimeConverter)someConverter;
        }
        if (type == null) {
            String typeFromConverter;
            type = converter != null ? (TYPE_DATE.equals(typeFromConverter = converter.getType()) ? DateType.DATE : (TYPE_BOTH.equals(typeFromConverter) ? DateType.DATETIME_LOCAL : (TYPE_TIME.equals(typeFromConverter) ? DateType.TIME : (TYPE_LOCAL_DATE.equals(typeFromConverter) ? DateType.DATE : (TYPE_LOCAL_DATE_TIME.equals(typeFromConverter) ? DateType.DATETIME_LOCAL : (TYPE_LOCAL_TIME.equals(typeFromConverter) ? DateType.TIME : (TYPE_ZONED_DATE_TIME.equals(typeFromConverter) ? DateType.DATETIME_LOCAL : (TYPE_OFFSET_DATE_TIME.equals(typeFromConverter) ? DateType.DATETIME_LOCAL : (TYPE_OFFSET_TIME.equals(typeFromConverter) ? DateType.TIME : (TYPE_MONTH.equals(typeFromConverter) ? DateType.MONTH : (TYPE_WEEK.equals(typeFromConverter) ? DateType.WEEK : DateType.DATE))))))))))) : DateType.DATE;
        }
        if (pattern == null && converter != null) {
            pattern = converter.getPattern();
        }
        if (pattern == null) {
            pattern = type.getPattern();
        }
        ((AbstractUIDate)component).setPattern(pattern);
        ((AbstractUIDate)component).setType(type);
    }
}

