/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.lang.invoke.MethodHandles;
import java.util.Locale;
import javax.faces.component.UIComponent;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LabelWithAccessKey {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String label;
    private final Character accessKey;
    private final int pos;

    public LabelWithAccessKey(SupportsAccessKey component) {
        this(component, false);
    }

    public LabelWithAccessKey(SupportsAccessKey component, boolean preferItemLabel) {
        Character accessKey0;
        String itemLabel;
        int pos0 = -1;
        String label0 = component.getLabel();
        if (preferItemLabel && (itemLabel = ComponentUtils.getStringAttribute((UIComponent)component, Attributes.itemLabel)) != null) {
            label0 = itemLabel;
        }
        if ((accessKey0 = component.getAccessKey()) != null && !this.isPermitted(accessKey0 = Character.valueOf(Character.toLowerCase(accessKey0.charValue())))) {
            LOG.warn("Ignoring illegal access key: " + accessKey0);
            accessKey0 = null;
        }
        if (accessKey0 != null && label0 != null) {
            pos0 = label0.toLowerCase(Locale.ENGLISH).indexOf(accessKey0.charValue());
        }
        this.label = label0;
        this.accessKey = accessKey0;
        this.pos = pos0;
    }

    public String getLabel() {
        return this.label;
    }

    public Character getAccessKey() {
        return this.accessKey;
    }

    public int getPos() {
        return this.pos;
    }

    private boolean isPermitted(Character key) {
        return key == null || key.charValue() >= 'a' && key.charValue() <= 'z' || key.charValue() >= '0' && key.charValue() <= '9';
    }
}

