/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.myfaces.portlet.faces.util.TextUtils;

public class HTTPUtils {
    private static final boolean[] sValidChar;
    private static final char[] sHexLookup;
    private static char[] sCharLookup;
    private static byte[] sByteLookup;

    public static DateFormat getCookieDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format;
    }

    public static String buildUrlAsString(String scheme, String host, int port, String path) {
        if (scheme == null || scheme.equals("") || host == null || host.equals("") || port == 0) {
            throw new IllegalArgumentException("Cannot build a URL using following scheme: " + scheme + " host: " + host + " port: " + port + " path: " + path);
        }
        StringBuilder url = new StringBuilder(200);
        url.append(scheme).append("://").append(host);
        if (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443) {
            url.append(":").append(port);
        }
        if (path != null) {
            url.append(path);
        }
        return url.toString();
    }

    public static String encode(String value, String encoding) throws UnsupportedEncodingException {
        int len = value.length();
        StringBuilder out = new StringBuilder(len * 3 / 2);
        for (int charIndex = 0; charIndex < len; ++charIndex) {
            byte[] charBytes;
            char aChar = value.charAt(charIndex);
            if (aChar <= '\u007f' && sValidChar[aChar]) {
                out.append(aChar);
                continue;
            }
            if (aChar == ' ') {
                out.append('+');
                continue;
            }
            for (byte element : charBytes = String.valueOf(aChar).getBytes(encoding)) {
                out.append('%');
                out.append(sHexLookup[(element & 0xF0) >> 4]);
                out.append(sHexLookup[element & 0xF]);
            }
        }
        return out.toString();
    }

    public static String encodeUTF(String value) {
        String encodedValue = null;
        try {
            encodedValue = HTTPUtils.encode(value, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encodedValue;
    }

    public static String decode(String value, String encoding) throws UnsupportedEncodingException {
        if (!HTTPUtils.needsDecoding(value)) {
            return value;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int charIndex = 0;
        int length = value.length();
        while (charIndex < length) {
            char aChar = value.charAt(charIndex);
            if (aChar == '%') {
                do {
                    int byteVal = Character.digit(value.charAt(charIndex + 1), 16) << 4 | Character.digit(value.charAt(charIndex + 2), 16);
                    bos.write(byteVal);
                } while ((charIndex += 3) < length && (aChar = value.charAt(charIndex)) == '%');
                continue;
            }
            if (aChar == '+') {
                bos.write(32);
            } else {
                bos.write(aChar);
            }
            ++charIndex;
        }
        return bos.toString(encoding);
    }

    public static String decodeUTF(String value) {
        String decodedValue = null;
        try {
            decodedValue = HTTPUtils.decode(value, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedValue;
    }

    public static boolean isErrorStatusCode(int statusCode) {
        return statusCode >= 400 && statusCode < 600;
    }

    public static final boolean needsDecoding(String token) {
        if (token == null) {
            return false;
        }
        return token.indexOf(43) != -1 || token.indexOf(37) != -1;
    }

    public static String getCookie(String cookieName, String cookies) {
        return HTTPUtils.getParameterValue(cookieName, cookies);
    }

    protected static String getParameterValue(String paramName, String params) {
        int paramsLen;
        int paramNameLen;
        if (paramName == null || (paramNameLen = paramName.length()) == 0) {
            return null;
        }
        if (params == null || (paramsLen = params.length()) == 0) {
            return null;
        }
        int index = 0;
        while (true) {
            int equalsIndex;
            if (params.charAt(index) == ' ' && index < paramsLen) {
                ++index;
                continue;
            }
            if (params.startsWith(paramName, index) && (equalsIndex = params.indexOf(61, index)) != -1) {
                int i;
                for (i = equalsIndex - 1; params.charAt(i) == ' ' && i > index; --i) {
                }
                if (paramNameLen == i - index + 1) {
                    int beginIndex = equalsIndex + 1;
                    if (beginIndex == paramsLen) {
                        return "";
                    }
                    int endIndex = params.indexOf(59, beginIndex);
                    if (endIndex == -1) {
                        endIndex = paramsLen - 1;
                    } else {
                        if (beginIndex == endIndex) {
                            return "";
                        }
                        --endIndex;
                    }
                    while (params.charAt(beginIndex) == ' ' && beginIndex < endIndex) {
                        ++beginIndex;
                    }
                    while (params.charAt(endIndex) == ' ' && endIndex > beginIndex) {
                        --endIndex;
                    }
                    String paramValue = params.substring(beginIndex, endIndex + 1);
                    if (0 == paramValue.length()) {
                        return "";
                    }
                    return paramValue;
                }
            }
            if ((index = params.indexOf(59, index)) == -1) {
                return null;
            }
            if (index == paramsLen - 1) {
                return null;
            }
            ++index;
        }
    }

    public static String toHTTPLocale(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (country.length() > 0 || variant.length() > 0) {
            StringBuilder buff = new StringBuilder(20).append(language).append('-').append(country);
            if (variant.length() > 0) {
                buff.append('-').append(variant);
            }
            return buff.toString();
        }
        return language;
    }

    public static String setCookie(String cookieName, String cookieValue, String cookies) {
        int cookiesLen;
        int cookieNameLen;
        String newCookies = cookies;
        if (cookieName == null || (cookieNameLen = cookieName.length()) == 0) {
            return cookies;
        }
        if (cookies == null || (cookiesLen = cookies.length()) == 0) {
            if (cookieValue != null) {
                newCookies = cookieName + "=" + cookieValue;
            }
        } else {
            int index = 0;
            while (true) {
                int equalsIndex;
                if (index < cookiesLen && cookies.charAt(index) == ' ') {
                    ++index;
                    continue;
                }
                if (cookies.startsWith(cookieName, index) && (equalsIndex = cookies.indexOf(61, index)) != -1) {
                    int i;
                    for (i = equalsIndex - 1; cookies.charAt(i) == ' ' && i > index; --i) {
                    }
                    if (cookieNameLen == i - index + 1) {
                        int beginIndex = equalsIndex + 1;
                        int endIndex = cookies.indexOf(59, beginIndex);
                        endIndex = endIndex == -1 ? cookiesLen - 1 : --endIndex;
                        newCookies = cookieValue == null ? cookies.substring(0, index) + cookies.substring(endIndex + 1) : cookies.substring(0, beginIndex) + cookieValue + cookies.substring(endIndex + 1);
                        return newCookies;
                    }
                }
                if ((index = cookies.indexOf(59, index)) == -1 || index == cookiesLen - 1) {
                    if (cookieValue != null) {
                        if (newCookies.length() != 0) {
                            newCookies = newCookies + ";";
                        }
                        newCookies = newCookies + cookieName + "=" + cookieValue;
                    }
                    return newCookies;
                }
                ++index;
            }
        }
        return newCookies;
    }

    public static String base64Encode(byte[] bytes) {
        int i = 0;
        int bytesToWrite = bytes.length;
        StringBuilder buff = new StringBuilder(bytes.length * 4 / 3);
        while (bytesToWrite >= 3) {
            buff.append(sCharLookup[bytes[i] >>> 2 & 0x3F]);
            buff.append(sCharLookup[((bytes[i] & 3) << 4) + (bytes[i + 1] >>> 4 & 0xF)]);
            buff.append(sCharLookup[((bytes[i + 1] & 0xF) << 2) + (bytes[i + 2] >>> 6 & 3)]);
            buff.append(sCharLookup[bytes[i + 2] & 0x3F]);
            bytesToWrite -= 3;
            i += 3;
        }
        switch (bytesToWrite) {
            case 2: {
                buff.append(sCharLookup[bytes[i] >>> 2 & 0x3F]);
                buff.append(sCharLookup[((bytes[i] & 3) << 4) + (bytes[i + 1] >>> 4 & 0xF)]);
                buff.append(sCharLookup[(bytes[i + 1] & 0xF) << 2]);
                buff.append('=');
                break;
            }
            case 1: {
                buff.append(sCharLookup[bytes[i] >> 2 & 0x3F]);
                buff.append(sCharLookup[(bytes[i] & 3) << 4]);
                buff.append('=');
                buff.append('=');
            }
        }
        return buff.toString();
    }

    public static byte[] base64Decode(String string) {
        int charsToWrite;
        string = TextUtils.globalReplace(string, "\n", "");
        string = TextUtils.globalReplace(string, "\r", "");
        char[] chars = string.toCharArray();
        int i = 0;
        ByteArrayOutputStream buff = new ByteArrayOutputStream(chars.length);
        byte[] b = new byte[4];
        for (charsToWrite = chars.length; charsToWrite >= 4; charsToWrite -= 4) {
            try {
                b[0] = sByteLookup[chars[i++]];
                if (b[0] == -1 || (b[1] = sByteLookup[chars[i++]]) == -1) {
                    throw new IllegalArgumentException(string);
                }
                buff.write(b[0] << 2 | b[1] >>> 4);
                b[2] = sByteLookup[chars[i++]];
                if (b[2] == -1) {
                    charsToWrite -= 4;
                    break;
                }
                buff.write(b[1] << 4 | b[2] >>> 2);
                b[3] = sByteLookup[chars[i++]];
                if (b[3] == -1) {
                    charsToWrite -= 4;
                    break;
                }
                buff.write(b[2] << 6 | b[3]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aiobe) {
                throw new IllegalArgumentException(string);
            }
        }
        if (charsToWrite > 0) {
            throw new IllegalArgumentException(string);
        }
        return buff.toByteArray();
    }

    static {
        int c;
        int c2;
        sValidChar = new boolean[128];
        sHexLookup = new char[16];
        for (c2 = 97; c2 <= 122; c2 = (int)((char)(c2 + 1))) {
            HTTPUtils.sValidChar[c2] = true;
        }
        for (c2 = 65; c2 <= 90; c2 = (int)((char)(c2 + 1))) {
            HTTPUtils.sValidChar[c2] = true;
        }
        for (c2 = 48; c2 <= 57; c2 = (int)((char)(c2 + 1))) {
            HTTPUtils.sValidChar[c2] = true;
        }
        HTTPUtils.sValidChar[45] = true;
        HTTPUtils.sValidChar[95] = true;
        HTTPUtils.sValidChar[46] = true;
        HTTPUtils.sValidChar[126] = true;
        HTTPUtils.sValidChar[39] = true;
        for (int b = 0; b < 16; b = (int)((byte)(b + 1))) {
            HTTPUtils.sHexLookup[b] = Character.toUpperCase(Character.forDigit(b, 16));
        }
        sCharLookup = new char[64];
        sByteLookup = new byte[127];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            HTTPUtils.sCharLookup[i] = c;
            int n = i;
            i = (byte)(i + 1);
            HTTPUtils.sByteLookup[c] = n;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            HTTPUtils.sCharLookup[i] = c;
            int n = i;
            i = (byte)(i + 1);
            HTTPUtils.sByteLookup[c] = n;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            HTTPUtils.sCharLookup[i] = c;
            int n = i;
            i = (byte)(i + 1);
            HTTPUtils.sByteLookup[c] = n;
        }
        HTTPUtils.sCharLookup[i] = 43;
        int n = i;
        i = (byte)(i + 1);
        HTTPUtils.sByteLookup[43] = n;
        HTTPUtils.sCharLookup[i] = 47;
        HTTPUtils.sByteLookup[47] = i;
        HTTPUtils.sByteLookup[61] = -1;
    }
}

