/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.myfaces.portlet.faces.testsuite.tests.chapter_5.section_5_3;

import java.util.Map;

import javax.el.ELResolver;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;


import javax.faces.render.ResponseStateManager;


import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

import org.apache.myfaces.portlet.faces.testsuite.annotation.BridgeTest;
import org.apache.myfaces.portlet.faces.testsuite.beans.TestRunnerBean;
import org.apache.myfaces.portlet.faces.testsuite.common.Constants;

public class Tests
  extends Object
{
  
  
  // Test is MultiRequest -- Render/Action
  // Test #5.41
  @BridgeTest(test = "noViewStateParamOnModeChangeTest")
  public String noViewStateParamOnModeChangeTest(TestRunnerBean testRunner)
  {    
    // In the action portion create/attach things to request scope that should either be preserved or
    // are explicitly excluded -- test for presence/absence in render
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
      return "noViewStateParamOnModeChangeTest"; // action Navigation result
    }
    else
    {
      FacesContext ctx = FacesContext.getCurrentInstance();
      ExternalContext extCtx = ctx.getExternalContext();
      
      testRunner.setTestComplete(true);
      if (extCtx.getRequestParameterMap().get(ResponseStateManager.VIEW_STATE_PARAM) == null)
      {
        testRunner.setTestResult(true,
                                "Render after mode change properly doesn't expose the ResponseStateManager.VIEW_STATE_PARAM.");
        return Constants.TEST_SUCCESS;  
      }
      else
      {
        testRunner.setTestResult(false,
                                "Render after mode change incorrectly exposes the ResponseStateManager.VIEW_STATE_PARAM.");
        return Constants.TEST_FAILED;
      }
    }
  } 
  
  // Test is SingleRequest -- Render
  // Test #5.43
  @BridgeTest(test = "checkViewHistoryTest")
  public String checkViewHistoryTest(TestRunnerBean testRunner)
  {    
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    Map<String, Object> m = extCtx.getSessionMap();
    ELResolver facesResolver = ctx.getELContext().getELResolver();
    PortletConfig config = (PortletConfig) facesResolver.getValue(ctx.getELContext(), null, "portletConfig");
      
    testRunner.setTestComplete(true);
    String view = (String) m.get("javax.portlet.faces.viewIdHistory.view");
    String edit = (String) m.get("javax.portlet.faces.viewIdHistory.edit");
    String help = (String) m.get("javax.portlet.faces.viewIdHistory.help");
    
    Map<String, String> defaultViewIdMap = (Map<String, String>) ((PortletContext)extCtx.getContext())
                          .getAttribute(Bridge.BRIDGE_PACKAGE_PREFIX + config.getPortletName() + "." + 
                                     Bridge.DEFAULT_VIEWID_MAP);
    
    if (view == null)
    {
      testRunner.setTestResult(false,
                                "javax.portlet.faces.viewIdHistory.view session attribute doesn't exist.");
      return Constants.TEST_FAILED;
    }
    
    if (edit == null)
    {
      testRunner.setTestResult(false,
                                "javax.portlet.faces.viewIdHistory.edit session attribute doesn't exist.");
      return Constants.TEST_FAILED;
    }
    
    if (help == null)
    {
      testRunner.setTestResult(false,
                                "javax.portlet.faces.viewIdHistory.help session attribute doesn't exist.");
      return Constants.TEST_FAILED;
    }
    
    if (!view.startsWith(defaultViewIdMap.get("view")))
    {
      testRunner.setTestResult(false,
                               "javax.portlet.faces.viewIdHistory.view contains unexpected value. Expected: "
                               + defaultViewIdMap.get("view") + " but value was: " + view);
      return Constants.TEST_FAILED;
    }
    
    if (!edit.startsWith(defaultViewIdMap.get("edit")))
    {
      testRunner.setTestResult(false,
                               "javax.portlet.faces.viewIdHistory.edit contains unexpected value. Expected: "
                               + defaultViewIdMap.get("edit") + " but value was: " + edit);
      return Constants.TEST_FAILED;
    }
    
    if (!help.startsWith(defaultViewIdMap.get("help")))
    {
      testRunner.setTestResult(false,
                               "javax.portlet.faces.viewIdHistory.help contains unexpected value. Expected: "
                               + defaultViewIdMap.get("help") + " but value was: " + help);
      return Constants.TEST_FAILED;
    }
    
    testRunner.setTestResult(true,
                                "Correctly contained the viewId history session attributes.");
    return Constants.TEST_SUCCESS;  
  } 
  
  
  // Test is MultiRequest -- Render/Action
  // Test #5.46
  @BridgeTest(test = "navigateToLastViewTest")
  public String navigateToLastViewTest(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    PortletMode mode = (PortletMode) ((PortletRequest)extCtx.getRequest()).getPortletMode();
    
    // In the action portion create/attach things to request scope that should either be preserved or
    // are explicitly excluded -- test for presence/absence in render
    String theView = ctx.getViewRoot().getViewId();
    String theHistoryView = (String) extCtx.getSessionMap().get("javax.portlet.faces.viewIdHistory.view");
    String theHistoryEdit = (String) extCtx.getSessionMap().get("javax.portlet.faces.viewIdHistory.view");
    String renderParam =  (String) extCtx.getRequestParameterMap().get("org.apache.myfaces.portlet.faces.tck.testAttr") ;
    
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
      String viewId = ctx.getViewRoot().getViewId();
      if (viewId.equals("/tests/MultiRequestTest.jsp"))
      {
        if (mode.toString().equals("view"))
        {
        // First page -- navigate to the second page
          return "navigateToLastViewTest1"; // action Navigation result
        }
        else 
        // (mode.toString().equals("edit"))
        {
          // Third page -- mark the test as complete so can test/render the result
          // Done on session attribute because we cross the request scope boundary (mode change)
          // and hence the current test bean is lost
          extCtx.getSessionMap().put("org.apache.myfaces.portlet.faces.tck.testCompleted", Boolean.TRUE);
          return "navigateToLastViewTest3"; // returns from edit mode
        }
      }
      else 
      // (viewId.equals("/tests/RedsiplayActionRequestTest.jsp"))
      {
        //Coming from the first page
        // Second page -- navigate to the edit mode
        // Render parameter added in the navigation
        return "navigateToLastViewTest2"; // action Navigation result -- goes to edit mode
      }
    }
    else
    {    
      // Should only get here from 
      if (Boolean.TRUE.equals((Boolean)extCtx.getSessionMap().get("org.apache.myfaces.portlet.faces.tck.testCompleted")))
      {
        testRunner.setTestComplete(true);
        extCtx.getSessionMap().remove("org.apache.myfaces.portlet.faces.tck.testCompleted");
        
        if (extCtx.getRequestParameterMap().get("org.apache.myfaces.portlet.faces.tck.testAttr") != null)
        {
          testRunner.setTestResult(true,
                                     "Successfully returned from edit mode to last view with its existing render parameters.");
          return Constants.TEST_SUCCESS;
        }
        else
        {
          testRunner.setTestResult(false,
                                     "Though we returned from edit mode to last view it was without its existing render parameters.");
          return Constants.TEST_FAILED;
        }
      }
      else
      {
        return "Test is still being run.";
      }
    }
  } 
  
}
