/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.DataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.NewspaperTable;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.ext.HtmlDataTableHack;
import org.apache.myfaces.component.html.ext.SortCriterion;
import org.apache.myfaces.component.html.ext.SortableModel;
import org.apache.myfaces.component.html.ext.UIComponentPerspective;
import org.apache.myfaces.component.html.ext._DetailStampFacetAndChildrenIterator;
import org.apache.myfaces.component.html.ext._SerializableArrayDataModel;
import org.apache.myfaces.component.html.ext._SerializableDataModel;
import org.apache.myfaces.component.html.ext._SerializableListDataModel;
import org.apache.myfaces.component.html.ext._SerializableResultDataModel;
import org.apache.myfaces.component.html.ext._SerializableResultSetDataModel;
import org.apache.myfaces.component.html.ext._SerializableScalarDataModel;
import org.apache.myfaces.custom.column.HtmlSimpleColumn;
import org.apache.myfaces.custom.crosstable.UIColumns;
import org.apache.myfaces.custom.sortheader.HtmlCommandSortHeader;
import org.apache.myfaces.renderkit.html.util.TableContext;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

public abstract class AbstractHtmlDataTable
extends HtmlDataTableHack
implements UserRoleAware,
NewspaperTable {
    private static final Log log = LogFactory.getLog(AbstractHtmlDataTable.class);
    private static final int PROCESS_DECODES = 1;
    private static final int PROCESS_VALIDATORS = 2;
    private static final int PROCESS_UPDATES = 3;
    private static final boolean DEFAULT_SORTASCENDING = true;
    private static final boolean DEFAULT_SORTABLE = false;
    private static final boolean DEFAULT_EMBEDDED = false;
    private static final boolean DEFAULT_DETAILSTAMP_EXPANDED = false;
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private static final Integer DEFAULT_NEWSPAPER_COLUMNS = new Integer(1);
    private static final String DEFAULT_NEWSPAPER_ORIENTATION = "vertical";
    private static final String DEFAULT_DETAILSTAMP_LOCATION = "after";
    public static final String NEWSPAPER_COLUMNS_PROPERTY = "newspaperColumns";
    public static final String SPACER_FACET_NAME = "spacer";
    public static final String NEWSPAPER_ORIENTATION_PROPERTY = "newspaperOrientation";
    public static final String DETAIL_STAMP_FACET_NAME = "detailStamp";
    private _SerializableDataModel _preservedDataModel;
    private String _forceIdIndexFormula = null;
    private String _sortColumn = null;
    private Boolean _sortAscending = null;
    private String _sortProperty = null;
    private String _rowStyleClass = null;
    private String _rowStyle = null;
    private String _varDetailToggler = null;
    private int _sortColumnIndex = -1;
    private boolean _isValidChildren = true;
    private Map _expandedNodes = new HashMap();
    private TableContext _tableContext = null;
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlDataTable";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Table";
    private static final boolean DEFAULT_PRESERVEDATAMODEL = false;
    private static final boolean DEFAULT_PRESERVESORT = true;
    private static final boolean DEFAULT_RENDEREDIFEMPTY = true;
    private Boolean _preserveDataModel = null;
    private Boolean _preserveSort = null;

    public TableContext getTableContext() {
        if (this._tableContext == null) {
            this._tableContext = new TableContext();
        }
        return this._tableContext;
    }

    public void setDetailStamp(UIComponent facet) {
        this.getFacets().put(DETAIL_STAMP_FACET_NAME, facet);
    }

    public UIComponent getDetailStamp() {
        return (UIComponent)this.getFacets().get(DETAIL_STAMP_FACET_NAME);
    }

    public String getClientId(FacesContext context) {
        String standardClientId = super.getClientId(context);
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return standardClientId;
        }
        String forcedIdIndex = this.getForceIdIndexFormula();
        if (forcedIdIndex == null || forcedIdIndex.length() == 0) {
            return standardClientId;
        }
        int indexLast_ = standardClientId.lastIndexOf(58);
        if (indexLast_ == -1) {
            log.info((Object)"Could not parse super.getClientId. forcedIdIndex will contain the rowIndex.");
            return standardClientId + ':' + forcedIdIndex;
        }
        String parsedForcedClientId = standardClientId.substring(0, indexLast_ + 1) + forcedIdIndex;
        return parsedForcedClientId;
    }

    public UIComponent findComponent(String expr) {
        if (expr.length() > 0 && Character.isDigit(expr.charAt(0))) {
            int separatorIndex = expr.indexOf(58);
            String rowIndexStr = expr;
            String remainingPart = null;
            if (separatorIndex != -1) {
                rowIndexStr = expr.substring(0, separatorIndex);
                remainingPart = expr.substring(separatorIndex + 1);
            }
            int rowIndex = Integer.valueOf(rowIndexStr);
            if (remainingPart == null) {
                log.error((Object)("Wrong syntax of expression : " + expr + " rowIndex was provided, but no component name."));
                return null;
            }
            UIComponent comp = super.findComponent(remainingPart);
            if (comp == null) {
                return null;
            }
            UIComponentPerspective perspective = new UIComponentPerspective((UIData)this, comp, rowIndex);
            return perspective;
        }
        return super.findComponent(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (context == null || clientId == null || callback == null) {
            throw new NullPointerException();
        }
        String baseClientId = this.getClientId(context);
        boolean returnValue = baseClientId.equals(clientId);
        if (returnValue) {
            try {
                callback.invokeContextCallback(context, (UIComponent)this);
                return true;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        Iterator it = this.getFacets().values().iterator();
        while (!returnValue && it.hasNext()) {
            returnValue = ((UIComponent)it.next()).invokeOnComponent(context, clientId, callback);
        }
        if (returnValue) {
            return returnValue;
        }
        if (clientId.startsWith(baseClientId)) {
            char separator = ':';
            ValueExpression rowKeyVE = this.getValueExpression("rowKey");
            boolean rowKeyFound = false;
            if (rowKeyVE != null) {
                int oldRow = this.getRowIndex();
                try {
                    int rowsToProcess = this.getRows();
                    if (rowsToProcess == 0) {
                        rowsToProcess = this.getRowCount();
                    }
                    int rowIndex = this.getFirst();
                    int rowsProcessed = 0;
                    while (rowsProcessed < rowsToProcess) {
                        this.setRowIndex(rowIndex);
                        if (!this.isRowAvailable()) break;
                        if (clientId.startsWith(this.getContainerClientId(context))) {
                            rowKeyFound = true;
                            break;
                        }
                        ++rowsProcessed;
                        ++rowIndex;
                    }
                    if (rowKeyFound) {
                        returnValue = this.invokeOnComponentTraverseRow(context, clientId, callback);
                    }
                }
                finally {
                    this.setRowIndex(oldRow);
                }
            }
            if (rowKeyVE == null && clientId.matches(baseClientId + separator + "[0-9]+" + separator + ".*")) {
                String subId = clientId.substring(baseClientId.length() + 1);
                String clientRow = subId.substring(0, subId.indexOf(separator));
                int oldRow = this.getRowIndex();
                try {
                    this.setRowIndex(Integer.parseInt(clientRow));
                    if (!this.isRowAvailable()) {
                        boolean bl = false;
                        return bl;
                    }
                    returnValue = this.invokeOnComponentTraverseRow(context, clientId, callback);
                }
                finally {
                    this.setRowIndex(oldRow);
                }
            }
            Iterator itChildren = this.getChildren().iterator();
            while (!returnValue && itChildren.hasNext()) {
                UIComponent child = (UIComponent)itChildren.next();
                if (child instanceof UIColumn && clientId.equals(child.getClientId(context))) {
                    try {
                        callback.invokeContextCallback(context, child);
                    }
                    catch (Exception e) {
                        throw new FacesException((Throwable)e);
                    }
                    returnValue = true;
                }
                Iterator itChildFacets = child.getFacets().values().iterator();
                while (!returnValue && itChildFacets.hasNext()) {
                    returnValue = ((UIComponent)itChildFacets.next()).invokeOnComponent(context, clientId, callback);
                }
            }
        }
        return returnValue;
    }

    private boolean invokeOnComponentTraverseRow(FacesContext context, String clientId, ContextCallback callback) {
        UIComponent detailStampFacet;
        boolean returnValue = false;
        Iterator it1 = this.getChildren().iterator();
        while (!returnValue && it1.hasNext()) {
            returnValue = ((UIComponent)it1.next()).invokeOnComponent(context, clientId, callback);
        }
        if (!returnValue && (detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)) != null) {
            returnValue = detailStampFacet.invokeOnComponent(context, clientId, callback);
        }
        return returnValue;
    }

    public void setRowIndex(int rowIndex) {
        Map requestMap;
        if (rowIndex < -1) {
            throw new IllegalArgumentException("rowIndex is less than -1");
        }
        String rowIndexVar = this.getRowIndexVar();
        String rowCountVar = this.getRowCountVar();
        String previousRowDataVar = this.getPreviousRowDataVar();
        if (rowIndexVar != null || rowCountVar != null || previousRowDataVar != null) {
            requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            if (previousRowDataVar != null && rowIndex >= 0) {
                if (this.isRowAvailable()) {
                    requestMap.put(previousRowDataVar, this.getRowData());
                } else {
                    requestMap.put(previousRowDataVar, null);
                }
            }
            super.setRowIndex(rowIndex);
            if (rowIndex >= 0) {
                if (rowIndexVar != null) {
                    requestMap.put(rowIndexVar, new Integer(rowIndex));
                }
                if (rowCountVar != null) {
                    requestMap.put(rowCountVar, new Integer(this.getRowCount()));
                }
            } else {
                if (rowIndexVar != null) {
                    requestMap.remove(rowIndexVar);
                }
                if (rowCountVar != null) {
                    requestMap.remove(rowCountVar);
                }
                if (previousRowDataVar != null) {
                    requestMap.remove(previousRowDataVar);
                }
            }
        } else {
            super.setRowIndex(rowIndex);
        }
        if (this._varDetailToggler != null) {
            requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            requestMap.put(this._varDetailToggler, this);
        }
    }

    protected Object saveDescendantComponentStates() {
        UIComponent detailStampFacet;
        if (!this.getFacets().isEmpty() && (detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)) != null) {
            return this.saveDescendantComponentStates(new _DetailStampFacetAndChildrenIterator(detailStampFacet, this.getChildren()), false);
        }
        return super.saveDescendantComponentStates();
    }

    protected void restoreDescendantComponentStates(Object state) {
        UIComponent detailStampFacet;
        if (!this.getFacets().isEmpty() && (detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)) != null) {
            this.restoreDescendantComponentStates(new _DetailStampFacetAndChildrenIterator(detailStampFacet, this.getChildren()), state, false);
            return;
        }
        super.restoreDescendantComponentStates(state);
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 1);
        this.processColumnFacets(context, 1);
        this.processColumnChildren(context, 1);
        this.setRowIndex(-1);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        this.setRowIndex(-1);
        this.processColumns(context, 1);
        this.setRowIndex(-1);
        this.processDetails(context, 1);
        this.setRowIndex(-1);
    }

    private void processFacets(FacesContext context, int processAction) {
        for (Map.Entry entry : this.getFacets().entrySet()) {
            if (DETAIL_STAMP_FACET_NAME.equals((String)entry.getKey())) continue;
            this.process(context, (UIComponent)entry.getValue(), processAction);
        }
    }

    private void processColumnFacets(FacesContext context, int processAction) {
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof UIColumn) || !child.isRendered()) continue;
            for (UIComponent facet : child.getFacets().values()) {
                this.process(context, facet, processAction);
            }
        }
    }

    private void processColumnChildren(FacesContext context, int processAction) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; last == -1 || rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UIColumn) || !child.isRendered()) continue;
                for (UIComponent columnChild : child.getChildren()) {
                    this.process(context, columnChild, processAction);
                }
            }
        }
    }

    private void processDetails(FacesContext context, int processAction) {
        UIComponent facet = this.getFacet(DETAIL_STAMP_FACET_NAME);
        if (facet != null) {
            int first = this.getFirst();
            int rows = this.getRows();
            int last = rows == 0 ? this.getRowCount() : first + rows;
            for (int rowIndex = first; last == -1 || rowIndex < last; ++rowIndex) {
                this.setRowIndex(rowIndex);
                if (!this.isRowAvailable()) break;
                if (!this.isCurrentDetailExpanded()) continue;
                if (1 == processAction) {
                    this.resetAllSubmittedValues(facet);
                }
                this.process(context, facet, processAction);
            }
        }
    }

    private void resetAllSubmittedValues(UIComponent component) {
        if (component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).setSubmittedValue(null);
        }
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            this.resetAllSubmittedValues((UIComponent)it.next());
        }
    }

    private void processColumns(FacesContext context, int processAction) {
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof UIColumns)) continue;
            this.process(context, child, processAction);
        }
    }

    private void process(FacesContext context, UIComponent component, int processAction) {
        switch (processAction) {
            case 1: {
                component.processDecodes(context);
                break;
            }
            case 2: {
                component.processValidators(context);
                break;
            }
            case 3: {
                component.processUpdates(context);
            }
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 2);
        this.processColumnFacets(context, 2);
        this.processColumnChildren(context, 2);
        this.setRowIndex(-1);
        this.processColumns(context, 2);
        this.setRowIndex(-1);
        this.processDetails(context, 2);
        this.setRowIndex(-1);
        if (context.getRenderResponse()) {
            this._isValidChildren = false;
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 3);
        this.processColumnFacets(context, 3);
        this.processColumnChildren(context, 3);
        this.setRowIndex(-1);
        this.processColumns(context, 3);
        this.setRowIndex(-1);
        this.processDetails(context, 3);
        this.setRowIndex(-1);
        if (this.isPreserveDataModel()) {
            this.updateModelFromPreservedDataModel(context);
        }
        if (context.getRenderResponse()) {
            this._isValidChildren = false;
        }
    }

    private void updateModelFromPreservedDataModel(FacesContext context) {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null && !vb.isReadOnly(context)) {
            _SerializableDataModel dm = (_SerializableDataModel)this.getDataModel();
            Class type = this.getValueType() == null ? vb.getType(context) : ClassUtils.simpleClassForName(this.getValueType());
            Class<?> dmType = dm.getClass();
            if (DataModel.class.isAssignableFrom(type)) {
                vb.setValue(context, (Object)dm);
            } else if (List.class.isAssignableFrom(type) || _SerializableListDataModel.class.isAssignableFrom(dmType)) {
                vb.setValue(context, dm.getWrappedData());
            } else if (OBJECT_ARRAY_CLASS.isAssignableFrom(type)) {
                List lst = (List)dm.getWrappedData();
                vb.setValue(context, (Object)lst.toArray(new Object[lst.size()]));
            } else {
                if (ResultSet.class.isAssignableFrom(type)) {
                    throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
                }
                List lst = (List)dm.getWrappedData();
                if (lst != null && lst.size() > 0) {
                    vb.setValue(context, lst.get(0));
                } else {
                    vb.setValue(context, null);
                }
            }
        }
        this._preservedDataModel = null;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        if (this._isValidChildren && !this.hasErrorMessages(context)) {
            this._preservedDataModel = null;
        }
        for (UIComponent component : this.getChildren()) {
            if (!(component instanceof UIColumns)) continue;
            ((UIColumns)component).encodeTableBegin(context);
        }
        for (UIComponent component : this.getChildren()) {
            HtmlCommandSortHeader sortHeader;
            if (!(component instanceof UIColumn)) continue;
            UIColumn aColumn = (UIColumn)component;
            UIComponent headerFacet = aColumn.getHeader();
            boolean replaceHeaderFacets = this.isSortable();
            String columnName = null;
            String propertyName = null;
            boolean defaultSorted = false;
            if (aColumn instanceof HtmlSimpleColumn) {
                HtmlSimpleColumn asColumn = (HtmlSimpleColumn)aColumn;
                propertyName = asColumn.getSortPropertyName();
                defaultSorted = asColumn.isDefaultSorted();
                if (asColumn.isSortable()) {
                    replaceHeaderFacets = true;
                }
            }
            if (replaceHeaderFacets && this.isSortHeaderNeeded(aColumn, headerFacet)) {
                String string = propertyName = propertyName != null ? propertyName : this.getSortPropertyFromEL((UIComponent)aColumn);
                if (propertyName == null) {
                    log.warn((Object)("Couldn't determine sort property for column [" + aColumn.getId() + "]."));
                }
                if (headerFacet != null) {
                    sortHeader = this.createSortHeaderComponent(context, aColumn, headerFacet, propertyName);
                    columnName = sortHeader.getColumnName();
                    aColumn.setHeader((UIComponent)sortHeader);
                    sortHeader.setParent((UIComponent)aColumn);
                }
            } else if (headerFacet instanceof HtmlCommandSortHeader) {
                sortHeader = (HtmlCommandSortHeader)headerFacet;
                columnName = sortHeader.getColumnName();
                propertyName = sortHeader.getPropertyName();
                if (propertyName == null) {
                    propertyName = this.getSortPropertyFromEL((UIComponent)aColumn);
                    sortHeader.setPropertyName(propertyName);
                }
                if (propertyName == null) {
                    log.warn((Object)("Couldn't determine sort property for column [" + aColumn.getId() + "]."));
                }
            }
            if (!defaultSorted || this.getSortColumn() != null) continue;
            this.setSortColumn(columnName);
            this.setSortProperty(propertyName);
        }
        super.encodeBegin(context);
    }

    protected boolean isSortHeaderNeeded(UIColumn parentColumn, UIComponent headerFacet) {
        return !(headerFacet instanceof HtmlCommandSortHeader);
    }

    protected HtmlCommandSortHeader createSortHeaderComponent(FacesContext context, UIColumn parentColumn, UIComponent initialHeaderFacet, String propertyName) {
        Application application = context.getApplication();
        HtmlCommandSortHeader sortHeader = (HtmlCommandSortHeader)application.createComponent("org.apache.myfaces.HtmlCommandSortHeader");
        String id = context.getViewRoot().createUniqueId();
        sortHeader.setId(id);
        sortHeader.setColumnName(id);
        sortHeader.setPropertyName(propertyName);
        sortHeader.setArrow(true);
        sortHeader.setImmediate(true);
        sortHeader.getChildren().add(initialHeaderFacet);
        initialHeaderFacet.setParent((UIComponent)sortHeader);
        return sortHeader;
    }

    protected String getSortPropertyFromEL(UIComponent component) {
        if (this.getVar() == null) {
            log.warn((Object)"There is no 'var' specified on the dataTable, sort properties cannot be determined automaticaly.");
            return null;
        }
        for (UIComponent aChild : component.getChildren()) {
            if (!aChild.isRendered()) continue;
            ValueBinding vb = aChild.getValueBinding("value");
            if (vb != null) {
                int varEndIndex;
                String tempProp;
                StringTokenizer tokenizer;
                String expressionString = vb.getExpressionString();
                int varIndex = expressionString.indexOf(this.getVar() + ".");
                if (varIndex == -1 || !(tokenizer = new StringTokenizer(tempProp = expressionString.substring((varEndIndex = varIndex + this.getVar().length()) + 1, expressionString.length()), " +[]{}-/*|?:&<>!=()%")).hasMoreTokens()) continue;
                return tokenizer.nextToken();
            }
            String sortProperty = this.getSortPropertyFromEL(aChild);
            if (sortProperty == null) continue;
            return sortProperty;
        }
        return null;
    }

    protected int columnNameToIndex(String columnName) {
        int index = 0;
        for (UIComponent aChild : this.getChildren()) {
            UIComponent headerFacet;
            if (aChild instanceof UIColumn && (headerFacet = ((UIColumn)aChild).getHeader()) != null && headerFacet instanceof HtmlCommandSortHeader) {
                HtmlCommandSortHeader sortHeader = (HtmlCommandSortHeader)headerFacet;
                if (columnName != null && columnName.equals(sortHeader.getColumnName())) {
                    return index;
                }
            }
            ++index;
        }
        return -1;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        for (UIComponent component : this.getChildren()) {
            if (!(component instanceof UIColumns)) continue;
            ((UIColumns)component).encodeTableEnd(context);
        }
    }

    public int getFirst() {
        if (this._preservedDataModel != null) {
            return this._preservedDataModel.getFirst();
        }
        return super.getFirst();
    }

    public void setFirst(int first) {
        if (this._preservedDataModel != null) {
            this._preservedDataModel.setFirst(first);
        }
        super.setFirst(first);
    }

    public int getRows() {
        if (this._preservedDataModel != null) {
            return this._preservedDataModel.getRows();
        }
        return super.getRows();
    }

    public void setRows(int rows) {
        if (this._preservedDataModel != null) {
            this._preservedDataModel.setRows(rows);
        }
        super.setRows(rows);
    }

    public Object saveState(FacesContext context) {
        boolean preserveSort = this.isPreserveSort();
        Object[] values = new Object[15];
        values[0] = super.saveState(context);
        values[1] = this._preserveDataModel;
        if (this.isPreserveDataModel()) {
            this._preservedDataModel = this.getSerializableDataModel();
            values[2] = AbstractHtmlDataTable.saveAttachedState((FacesContext)context, (Object)this._preservedDataModel);
        } else {
            values[2] = null;
        }
        values[3] = this._preserveSort;
        values[4] = this._forceIdIndexFormula;
        values[5] = this._sortColumn;
        values[6] = this._sortAscending;
        values[7] = this._sortProperty;
        values[8] = this._rowStyleClass;
        values[9] = this._rowStyle;
        values[10] = preserveSort ? this.getSortColumn() : null;
        values[11] = preserveSort ? Boolean.valueOf(this.isSortAscending()) : null;
        values[12] = this._varDetailToggler;
        values[13] = this._expandedNodes;
        values[14] = new Integer(this._sortColumnIndex);
        return values;
    }

    protected DataModel getDataModel() {
        if (this._preservedDataModel != null) {
            this.setDataModel(this._preservedDataModel);
            this._preservedDataModel = null;
        }
        return super.getDataModel();
    }

    protected DataModel createDataModel() {
        DataModel dataModel = super.createDataModel();
        boolean isSortable = this.isSortable();
        if (!(dataModel instanceof SortableModel)) {
            for (UIComponent component : this.getChildren()) {
                if (!(component instanceof HtmlSimpleColumn)) continue;
                HtmlSimpleColumn aColumn = (HtmlSimpleColumn)component;
                if (this.isSortable()) {
                    aColumn.setSortable(true);
                }
                if (aColumn.isSortable()) {
                    isSortable = true;
                }
                if (!aColumn.isDefaultSorted() || this.getSortColumn() != null) continue;
                this.setSortProperty(aColumn.getSortPropertyName());
            }
            if (isSortable) {
                dataModel = new SortableModel(dataModel);
            }
        }
        if (isSortable && this.getSortProperty() != null) {
            SortCriterion criterion = new SortCriterion(this.getSortProperty(), this.isSortAscending());
            ArrayList<SortCriterion> criteria = new ArrayList<SortCriterion>();
            criteria.add(criterion);
            ((SortableModel)dataModel).setSortCriteria(criteria);
        }
        return dataModel;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._preserveDataModel = (Boolean)values[1];
        this._preservedDataModel = this.isPreserveDataModel() ? (_SerializableDataModel)AbstractHtmlDataTable.restoreAttachedState((FacesContext)context, (Object)values[2]) : null;
        this._preserveSort = (Boolean)values[3];
        this._forceIdIndexFormula = (String)values[4];
        this._sortColumn = (String)values[5];
        this._sortAscending = (Boolean)values[6];
        this._sortProperty = (String)values[7];
        this._rowStyleClass = (String)values[8];
        this._rowStyle = (String)values[9];
        if (this.isPreserveSort()) {
            String sortColumn = (String)values[10];
            Boolean sortAscending = (Boolean)values[11];
            if (sortColumn != null && sortAscending != null) {
                ValueBinding vb = this.getValueBinding("sortColumn");
                if (vb != null && !vb.isReadOnly(context)) {
                    vb.setValue(context, (Object)sortColumn);
                }
                if ((vb = this.getValueBinding("sortAscending")) != null && !vb.isReadOnly(context)) {
                    vb.setValue(context, (Object)sortAscending);
                }
            }
        }
        this._varDetailToggler = (String)values[12];
        this._expandedNodes = (Map)values[13];
        this._sortColumnIndex = values[14] != null ? (Integer)values[14] : -1;
    }

    public _SerializableDataModel getSerializableDataModel() {
        DataModel dm = this.getDataModel();
        if (dm instanceof _SerializableDataModel) {
            return (_SerializableDataModel)dm;
        }
        return this.createSerializableDataModel();
    }

    private _SerializableDataModel createSerializableDataModel() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof DataModel) {
            return new _SerializableDataModel(this.getFirst(), this.getRows(), (DataModel)value);
        }
        if (value instanceof List) {
            return new _SerializableListDataModel(this.getFirst(), this.getRows(), (List)value);
        }
        if (value instanceof Collection) {
            return new _SerializableListDataModel(this.getFirst(), this.getRows(), new ArrayList((Collection)value));
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new _SerializableArrayDataModel(this.getFirst(), this.getRows(), (Object[])value);
        }
        if (value instanceof ResultSet) {
            return new _SerializableResultSetDataModel(this.getFirst(), this.getRows(), (ResultSet)value);
        }
        if (value instanceof Result) {
            return new _SerializableResultDataModel(this.getFirst(), this.getRows(), (Result)value);
        }
        return new _SerializableScalarDataModel(this.getFirst(), this.getRows(), value);
    }

    public boolean isRendered() {
        if (!UserRoleUtils.isVisibleOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public void setForceIdIndexFormula(String forceIdIndexFormula) {
        this._forceIdIndexFormula = forceIdIndexFormula;
        ValueBinding vb = this.getValueBinding("forceIdIndexFormula");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)this._forceIdIndexFormula);
            this._forceIdIndexFormula = null;
        }
    }

    public String getForceIdIndexFormula() {
        if (this._forceIdIndexFormula != null) {
            return this._forceIdIndexFormula;
        }
        ValueBinding vb = this.getValueBinding("forceIdIndexFormula");
        if (vb == null) {
            return null;
        }
        Object eval = vb.getValue(this.getFacesContext());
        return eval == null ? null : eval.toString();
    }

    public void setSortColumn(String sortColumn) {
        this._sortColumn = sortColumn;
        ValueBinding vb = this.getValueBinding("sortColumn");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)this._sortColumn);
            this._sortColumn = null;
        }
        this.setSortColumnIndex(this.columnNameToIndex(sortColumn));
    }

    public String getSortColumn() {
        if (this._sortColumn != null) {
            return this._sortColumn;
        }
        ValueBinding vb = this.getValueBinding("sortColumn");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setSortAscending(boolean sortAscending) {
        this._sortAscending = sortAscending;
        ValueBinding vb = this.getValueBinding("sortAscending");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)this._sortAscending);
            this._sortAscending = null;
        }
    }

    public boolean isSortAscending() {
        if (this._sortAscending != null) {
            return this._sortAscending;
        }
        ValueBinding vb = this.getValueBinding("sortAscending");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public void setSortProperty(String sortProperty) {
        this._sortProperty = sortProperty;
    }

    public String getSortProperty() {
        return this._sortProperty;
    }

    public abstract boolean isSortable();

    public abstract boolean isEmbedded();

    public abstract boolean isDetailStampExpandedDefault();

    public abstract String getDetailStampLocation();

    public abstract String getRowOnMouseOver();

    public abstract String getRowOnMouseOut();

    public abstract String getRowOnClick();

    public abstract String getRowOnDblClick();

    public abstract String getRowOnKeyDown();

    public abstract String getRowOnKeyPress();

    public abstract String getRowOnKeyUp();

    public String getRowStyleClass() {
        if (this._rowStyleClass != null) {
            return this._rowStyleClass;
        }
        ValueBinding vb = this.getValueBinding("org.apache.myfaces.dataTable.ROW_STYLECLASS");
        if (vb != null) {
            log.warn((Object)"org.apache.myfaces.dataTable.ROW_STYLECLASS is deprecated. Please use rowStyleClass instead.");
        } else {
            vb = this.getValueBinding("rowStyleClass");
        }
        if (vb == null) {
            return null;
        }
        String bindingValue = (String)vb.getValue(this.getFacesContext());
        if (bindingValue == "") {
            return null;
        }
        return bindingValue;
    }

    public void setRowStyleClass(String rowStyleClass) {
        this._rowStyleClass = rowStyleClass;
    }

    public String getRowStyle() {
        if (this._rowStyle != null) {
            return this._rowStyle;
        }
        ValueBinding vb = this.getValueBinding("org.apache.myfaces.dataTable.ROW_STYLE");
        if (vb != null) {
            log.warn((Object)"org.apache.myfaces.dataTable.ROW_STYLE is deprecated. Please use rowStyle instead.");
        } else {
            vb = this.getValueBinding("rowStyle");
        }
        if (vb == null) {
            return null;
        }
        String bindingValue = (String)vb.getValue(this.getFacesContext());
        if (bindingValue == "") {
            return null;
        }
        return bindingValue;
    }

    public void setRowStyle(String rowStyle) {
        this._rowStyle = rowStyle;
    }

    public abstract String getRowOnMouseDown();

    public abstract String getRowOnMouseMove();

    public abstract String getRowOnMouseUp();

    protected boolean isValidChildren() {
        return this._isValidChildren;
    }

    protected void setIsValidChildren(boolean isValidChildren) {
        this._isValidChildren = isValidChildren;
    }

    protected _SerializableDataModel getPreservedDataModel() {
        return this._preservedDataModel;
    }

    protected void setPreservedDataModel(_SerializableDataModel preservedDataModel) {
        this._preservedDataModel = preservedDataModel;
    }

    public boolean isCurrentDetailExpanded() {
        Boolean expanded = (Boolean)this._expandedNodes.get(this.getClientId(this.getFacesContext()));
        if (expanded != null) {
            return expanded;
        }
        return this.isDetailStampExpandedDefault();
    }

    public void setVarDetailToggler(String varDetailToggler) {
        this._varDetailToggler = varDetailToggler;
    }

    public String getVarDetailToggler() {
        if (this._varDetailToggler != null) {
            return this._varDetailToggler;
        }
        ValueBinding vb = this.getValueBinding("varDetailToggler");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public abstract String getRowGroupStyle();

    public abstract String getRowGroupStyleClass();

    public abstract String getBodyStyle();

    public abstract String getBodyStyleClass();

    public AbstractHtmlDataTable() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public void toggleDetail() {
        String derivedRowKey = this.getClientId(this.getFacesContext());
        boolean expanded = this.isDetailExpanded();
        if (expanded) {
            if (this.isDetailStampExpandedDefault()) {
                this._expandedNodes.put(derivedRowKey, Boolean.FALSE);
            } else {
                this._expandedNodes.remove(derivedRowKey);
            }
        } else if (this.isDetailStampExpandedDefault()) {
            this._expandedNodes.remove(derivedRowKey);
        } else {
            this._expandedNodes.put(derivedRowKey, Boolean.TRUE);
        }
    }

    public boolean isDetailExpanded() {
        Boolean expanded = (Boolean)this._expandedNodes.get(this.getClientId(this.getFacesContext()));
        if (expanded == null) {
            return this.isDetailStampExpandedDefault();
        }
        return expanded;
    }

    public int getSortColumnIndex() {
        if (this._sortColumnIndex == -1) {
            this._sortColumnIndex = this.columnNameToIndex(this.getSortColumn());
        }
        return this._sortColumnIndex;
    }

    public void setSortColumnIndex(int sortColumnIndex) {
        this._sortColumnIndex = sortColumnIndex;
    }

    public abstract int getNewspaperColumns();

    public abstract String getNewspaperOrientation();

    public UIComponent getSpacer() {
        return (UIComponent)this.getFacets().get(SPACER_FACET_NAME);
    }

    public void setSpacer(UIComponent spacer) {
        this.getFacets().put(SPACER_FACET_NAME, spacer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandAllDetails() {
        int rowCount = this.getRowCount();
        this._expandedNodes.clear();
        if (this.getRowKey() != null) {
            int oldRow = this.getRowIndex();
            try {
                for (int row = 0; row < rowCount; ++row) {
                    this.setRowIndex(row);
                    this._expandedNodes.put(this.getClientId(this.getFacesContext()), Boolean.TRUE);
                }
            }
            finally {
                this.setRowIndex(oldRow);
            }
        } else {
            for (int row = 0; row < rowCount; ++row) {
                this._expandedNodes.put(new Integer(row).toString(), Boolean.TRUE);
            }
        }
    }

    public void collapseAllDetails() {
        this._expandedNodes.clear();
    }

    public boolean isExpandedEmpty() {
        boolean expandedEmpty = true;
        if (this._expandedNodes != null) {
            expandedEmpty = this._expandedNodes.isEmpty();
        }
        return expandedEmpty;
    }

    public void setExpandedEmpty(boolean expandedEmpty) {
        if (expandedEmpty && this._expandedNodes != null) {
            this._expandedNodes.clear();
        }
    }

    public void setPreserveDataModel(boolean preserveDataModel) {
        this._preserveDataModel = preserveDataModel;
    }

    public boolean isPreserveDataModel() {
        if (this._preserveDataModel != null) {
            return this._preserveDataModel;
        }
        ValueBinding vb = this.getValueBinding("preserveDataModel");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setPreserveSort(boolean preserveSort) {
        this._preserveSort = preserveSort;
    }

    public boolean isPreserveSort() {
        if (this._preserveSort != null) {
            return this._preserveSort;
        }
        ValueBinding vb = this.getValueBinding("preserveSort");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public abstract boolean isRenderedIfEmpty();

    public abstract String getRowIndexVar();

    public abstract String getRowCountVar();

    public abstract String getPreviousRowDataVar();

    public abstract String getSortedColumnVar();

    public abstract String getAlign();

    public abstract String getRowId();

    public abstract String getDatafld();

    public abstract String getDatasrc();

    public abstract String getDataformatas();

    public abstract String getValueType();
}

