/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.myfaces.trinidad.context.Version;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.style.StyleConstants;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.xml.XMLConstants;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheetNodeParser
extends BaseNodeParser
implements XMLConstants,
StyleConstants {
    private Vector<StyleNode> _styles;
    private Locale[] _locales;
    private int _direction;
    private int _mode;
    private int[] _browsers;
    private Version[] _versions;
    private int[] _platforms;
    private Set<String> _accProperties;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleSheetNodeParser.class);

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        this._initLocales(attrs.getValue("locales"));
        this._direction = NameUtils.getDirection(attrs.getValue("direction"));
        this._mode = NameUtils.getMode(attrs.getValue("mode"));
        this._initBrowsers(attrs.getValue("browsers"));
        this._initVersions(attrs.getValue("versions"));
        this._initPlatforms(attrs.getValue("platforms"));
        this._initAccessibilityProperties(attrs.getValue("accessibilityProfile"));
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        Object[] styles = null;
        if (this._styles != null) {
            styles = new StyleNode[this._styles.size()];
            this._styles.copyInto(styles);
        }
        int versionCount = this._versions != null ? this._versions.length : 0;
        HashSet<Version> versions = new HashSet<Version>(versionCount);
        for (int i = 0; i < versionCount; ++i) {
            versions.add(this._versions[i]);
        }
        int browserCount = this._browsers != null ? this._browsers.length : 0;
        HashMap<Integer, Set<Version>> browsers = new HashMap<Integer, Set<Version>>(browserCount);
        for (int i = 0; i < browserCount; ++i) {
            browsers.put(this._browsers[i], new HashSet(versions));
        }
        return new StyleSheetNode((StyleNode[])styles, null, null, this._locales, this._direction, browsers, this._platforms, this._mode, this._accProperties);
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("style")) {
            return context.getParser(StyleNode.class, namespaceURI, localName);
        }
        return null;
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) {
        if (child instanceof StyleNode) {
            if (this._styles == null) {
                this._styles = new Vector();
            }
            this._styles.addElement((StyleNode)child);
        }
    }

    private Locale _getLocale(String str) {
        int length = str.length();
        if (length == 2) {
            return new Locale(str, "");
        }
        if (length == 5 && str.charAt(2) == '_') {
            return new Locale(str.substring(0, 2), str.substring(3, 5));
        }
        return null;
    }

    private void _initLocales(String localeAttr) {
        if (localeAttr == null) {
            return;
        }
        Vector<Locale> locales = new Vector<Locale>();
        Iterator<String> tokens = this._getTokens(localeAttr);
        while (tokens.hasNext()) {
            Locale locale = this._getLocale(tokens.next());
            if (locale == null) continue;
            locales.addElement(locale);
        }
        if (locales != null) {
            this._locales = new Locale[locales.size()];
            locales.copyInto(this._locales);
        }
    }

    private void _initBrowsers(String browserAttr) {
        Iterator<String> browsers = this._getTokens(browserAttr);
        if (browsers == null) {
            return;
        }
        Vector<Integer> v = new Vector<Integer>();
        while (browsers.hasNext()) {
            int browser = NameUtils.getBrowser(browsers.next());
            if (browser == 0) continue;
            v.addElement(browser);
        }
        this._browsers = this._getIntegers(v);
    }

    private void _initVersions(String versionAttr) {
        Iterator<String> versions = this._getTokens(versionAttr);
        if (versions == null) {
            return;
        }
        Vector<Version> v = new Vector<Version>();
        while (versions.hasNext()) {
            String version = versions.next();
            if (version == null) continue;
            v.add(new Version(version, "*"));
        }
        this._versions = v.toArray(new Version[v.size()]);
    }

    private void _initPlatforms(String platformAttr) {
        Iterator<String> platforms = this._getTokens(platformAttr);
        if (platforms == null) {
            return;
        }
        Vector<Integer> v = new Vector<Integer>();
        while (platforms.hasNext()) {
            String platformName = platforms.next();
            int platform = NameUtils.getPlatform(platformName);
            if (platform == 0 && "unix".equals(platformName)) {
                platform = Integer.MAX_VALUE;
            }
            if (platform == 0) continue;
            v.addElement(platform);
        }
        this._platforms = this._getIntegers(v);
    }

    private void _initAccessibilityProperties(String accProfileAttr) {
        Iterator<String> tokens = this._getTokens(accProfileAttr);
        if (tokens == null) {
            return;
        }
        HashSet<String> props = new HashSet<String>(11);
        while (tokens.hasNext()) {
            String token = tokens.next();
            if (NameUtils.isAccessibilityPropertyName(token)) {
                props.add(token);
                continue;
            }
            _LOG.warning("INVALID_ACC_PROFILE", new Object[]{token});
        }
        this._accProperties = props;
    }

    private int[] _getIntegers(Vector<Integer> v) {
        int count = v.size();
        if (count == 0) {
            return null;
        }
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = v.elementAt(i);
        }
        return array;
    }

    private Iterator<String> _getTokens(String attr) {
        if (attr == null) {
            return null;
        }
        return Arrays.asList(XMLUtils.parseNameTokens(attr)).iterator();
    }
}

