/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util.nls;

public class StringUtils {
    public static final int MNEMONIC_INDEX_NONE = -1;
    private static final char _MNEMONIC_INDICATOR = '&';
    private static final String _ELLIPSIS = "...";
    private static final int _ELLIPSIS_LENGTH = "...".length();
    private static final int _TRUNCATE_AT_MINIMUM = 13;

    public static String truncateString(String text, int truncateAt) {
        if (text == null) {
            return null;
        }
        if (truncateAt < 13) {
            truncateAt = 13;
        }
        if (text.length() > truncateAt) {
            text = text.substring(0, truncateAt - _ELLIPSIS_LENGTH) + _ELLIPSIS;
        }
        return text;
    }

    public static int getMnemonicIndex(String string) {
        int index;
        if (string == null) {
            return -1;
        }
        int lengthMinusOne = string.length() - 1;
        int i = 0;
        int count = 0;
        while (i < lengthMinusOne && (index = string.indexOf(38, i)) != -1 && index < lengthMinusOne) {
            if (string.charAt(index + 1) != '&') {
                return index - count;
            }
            i = index + 2;
            ++count;
        }
        return -1;
    }

    public static String stripMnemonic(String string) {
        if (string == null) {
            return null;
        }
        int length = string.length();
        if (length <= 1) {
            return string;
        }
        StringBuffer buffer = null;
        int i = 0;
        while (i < length) {
            int index = string.indexOf(38, i);
            if (index < 0 || index >= length - 1) {
                if (buffer == null) break;
                buffer.append(string.substring(i));
                break;
            }
            if (buffer == null) {
                if (index == 0 && string.charAt(1) != '&') {
                    string = string.substring(1);
                    --length;
                    continue;
                }
                buffer = new StringBuffer(length - 1);
            }
            buffer.append(string.substring(i, index));
            buffer.append(string.charAt(index + 1));
            i = index + 2;
        }
        if (buffer == null) {
            return string;
        }
        return new String(buffer);
    }
}

