/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.Version;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.agent.AgentNameUtil;
import org.apache.myfaces.trinidadinternal.agent.CapabilitiesProvider;
import org.apache.myfaces.trinidadinternal.agent.CapabilityKey;
import org.apache.myfaces.trinidadinternal.agent.CapabilityMap;
import org.apache.myfaces.trinidadinternal.agent.DeviceRepository;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;

public class TrinidadAgentImpl
extends TrinidadAgent {
    private static volatile URL _capUrl;
    private static final String _CAPABILITIES_FILE = "META-INF/agent/capabilities.xml";
    private static final String _DEVICE_REPOSITORY_URL = "org.apache.myfaces.trinidadinternal.agent.DeviceRepository";
    private static final TrinidadLogger _LOG;
    private static volatile DeviceRepository _deviceRepository;
    private final Agent _delegate;
    private CapabilityMap _capMap;
    private final int _type;
    private final TrinidadAgent.Application _application;
    private final int _os;
    private final int _major;
    private final String _skinFamilyType;
    private final Version _version;

    public TrinidadAgentImpl(FacesContext context, Agent agent) {
        this._delegate = agent;
        this._type = AgentNameUtil.getAgentType(this.getType());
        this._application = TrinidadAgent.Application.fromAgentName(this.getAgentName());
        this._os = AgentNameUtil.getPlatform(this.getPlatformName());
        String versionString = this.getAgentVersion();
        this._major = TrinidadAgent.Application.GECKO == this._application ? 1 : TrinidadAgentImpl._getMajorVersion(versionString);
        this._version = new Version(versionString);
        this._skinFamilyType = this._getSkinFamilyType(this._os, this._application);
        this._capMap = this._getCapabilityMap(context);
        Map requestCaps = this._delegate.getCapabilities();
        if (!requestCaps.isEmpty()) {
            this._capMap = this._capMap.merge(requestCaps);
        }
    }

    public TrinidadAgentImpl(Agent agent) {
        this(null, agent);
    }

    public Object getType() {
        return this._delegate.getType();
    }

    @Override
    public int getAgentType() {
        return this._type;
    }

    public String getAgentName() {
        return this._delegate.getAgentName();
    }

    @Override
    public TrinidadAgent.Application getAgentApplication() {
        return this._application;
    }

    public String getAgentVersion() {
        return this._delegate.getAgentVersion();
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    @Override
    public int getAgentMajorVersion() {
        return this._major;
    }

    public String getPlatformName() {
        return this._delegate.getPlatformName();
    }

    public String getPlatformVersion() {
        return this._delegate.getPlatformVersion();
    }

    public Map<Object, Object> getCapabilities() {
        return this._capMap;
    }

    @Override
    public int getAgentOS() {
        return this._os;
    }

    public String getHardwareMakeModel() {
        return this._delegate.getHardwareMakeModel();
    }

    @Override
    public Object getCapability(CapabilityKey key) {
        return this._capMap.getCapability(key);
    }

    @Override
    public String getSkinFamilyType() {
        return this._skinFamilyType;
    }

    @Override
    public Object clone() {
        TrinidadAgentImpl that = (TrinidadAgentImpl)this.cloneTrinidadAgent();
        that._capMap = (CapabilityMap)this._capMap.clone();
        return that;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Agent[");
        buffer.append(this.getType());
        buffer.append(',');
        String name = this.getAgentName();
        if (name != null) {
            buffer.append(name);
        } else {
            buffer.append("unknown");
        }
        String version = this.getAgentVersion();
        if (version != null) {
            buffer.append(' ');
            buffer.append(version);
        }
        buffer.append(',');
        name = this.getPlatformName();
        if (name != null) {
            buffer.append(name);
        } else {
            buffer.append("unknown");
        }
        buffer.append(']');
        version = this.getPlatformVersion();
        if (version != null) {
            buffer.append(' ');
            buffer.append(version);
        }
        return new String(buffer);
    }

    private CapabilityMap _getCapabilityMap(FacesContext context) {
        CapabilityMap capMap = null;
        DeviceRepository repository = TrinidadAgentImpl._getDeviceRepository();
        capMap = repository.getCapabilityMap(context, this);
        if (capMap == null) {
            URL url = TrinidadAgentImpl._getCapabilitiesFile();
            if (url == null) {
                _LOG.severe("CANNOT_LOCATE_CAPABILITIES_DOCUMENT");
            }
            CapabilitiesProvider capProvider = CapabilitiesProvider.getCapabilitiesProvider(url);
            capMap = capProvider.getCapabilities(this);
        }
        return capMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DeviceRepository _getDeviceRepository() {
        if (_deviceRepository != null) return _deviceRepository;
        String string = _DEVICE_REPOSITORY_URL;
        synchronized (_DEVICE_REPOSITORY_URL) {
            if (_deviceRepository != null) return _deviceRepository;
            List list = ClassLoaderUtils.getServices((String)_DEVICE_REPOSITORY_URL);
            _deviceRepository = list.isEmpty() ? EmptyDeviceRepository.getInstance() : (DeviceRepository)list.get(0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return _deviceRepository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL _getCapabilitiesFile() {
        if (_capUrl != null) {
            return _capUrl;
        }
        URL path = null;
        Class<TrinidadAgentImpl> clazz = TrinidadAgentImpl.class;
        synchronized (TrinidadAgentImpl.class) {
            if (_capUrl != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return _capUrl;
            }
            if (path == null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = TrinidadAgentImpl.class.getClassLoader();
                }
                path = loader.getResource(_CAPABILITIES_FILE);
            }
            if (path == null) {
                _LOG.severe("CANNOT_RESOLVE_CAPABILITIES_FILE");
            }
            _capUrl = path;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _capUrl;
        }
    }

    private static int _getMajorVersion(String source) {
        double version = 0.0;
        if (source != null) {
            boolean hasDecimal = false;
            double divisor = 10.0;
            int sourceLength = source.length();
            for (int currIndex = 0; currIndex < sourceLength; ++currIndex) {
                char currChar = source.charAt(currIndex);
                if (currChar >= '0' && currChar <= '9') {
                    double addValue = currChar - 48;
                    if (hasDecimal) {
                        addValue /= divisor;
                        divisor *= 10.0;
                    } else {
                        version *= 10.0;
                    }
                    version += addValue;
                    continue;
                }
                if (hasDecimal || currChar != '.') break;
                hasDecimal = true;
            }
        }
        return (int)version;
    }

    private String _getSkinFamilyType(int os, TrinidadAgent.Application application) {
        if (os == 6) {
            return "windowsmobile";
        }
        if (application == TrinidadAgent.Application.NOKIA_S60) {
            return "nokiawebkit";
        }
        if (application == TrinidadAgent.Application.SAFARI) {
            if (os == 8) {
                return "iPhonewebkit";
            }
            if (os == 3) {
                return "linuxwebkit";
            }
            if (os == 2) {
                return "macwebkit";
            }
            if (os == 1) {
                return "windowswebkit";
            }
            return "defaultwebkit";
        }
        if (application == TrinidadAgent.Application.GENERICPDA) {
            return "genericpda";
        }
        if (application == TrinidadAgent.Application.BLACKBERRY) {
            String version = this.getAgentVersion();
            if ((double)Float.parseFloat(version = version.substring(0, version.indexOf(".") + 2)) > 4.5) {
                return "blackberry";
            }
            return "blackberryminimal";
        }
        return null;
    }

    void __mergeCapabilities(Map<Object, Object> capabilities) {
        this._capMap = this._capMap.merge(capabilities);
    }

    static {
        _LOG = TrinidadLogger.createTrinidadLogger(TrinidadAgentImpl.class);
    }

    private static final class EmptyDeviceRepository
    extends DeviceRepository {
        private static final DeviceRepository _INSTANCE = new EmptyDeviceRepository();

        private EmptyDeviceRepository() {
        }

        @Override
        public CapabilityMap getCapabilityMap(FacesContext context, Agent agent) {
            return null;
        }

        public static DeviceRepository getInstance() {
            return _INSTANCE;
        }
    }
}

