/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.myfaces.trinidad.util.StringUtils;

public final class MimeUtility {
    private static final String _QP_WORD_SPECIALS = "=_?\"#$%&'(),.:;<>@[\\]^`{|}~";
    private static final byte[] _ENCODING_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static String encodeHTTPHeader(String word, boolean isIE) {
        if (isIE) {
            try {
                return StringUtils.replace((String)URLEncoder.encode(word, "UTF-8"), (String)"+", (String)"%20");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        int sizeLimit = 63;
        StringBuffer result = new StringBuffer();
        try {
            MimeUtility._encodeQuotedPrintable(word, result, sizeLimit, "UTF-8", true, false, _QP_WORD_SPECIALS);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result.toString();
    }

    private static void _encodeQuotedPrintable(String data, StringBuffer out, int sizeLimit, String charset, boolean firstSegment, boolean foldSegments, String specials) throws UnsupportedEncodingException {
        byte[] bytes = data.getBytes(charset);
        int estimatedSize = MimeUtility._estimateQPEncodedLength(bytes, specials);
        if (estimatedSize > sizeLimit) {
            MimeUtility._encodeQuotedPrintable(data.substring(0, data.length() / 2), out, sizeLimit, charset, firstSegment, foldSegments, specials);
            MimeUtility._encodeQuotedPrintable(data.substring(data.length() / 2), out, sizeLimit, charset, false, foldSegments, specials);
        } else {
            if (!firstSegment) {
                if (foldSegments) {
                    out.append("\r\n");
                } else {
                    out.append(' ');
                }
            }
            MimeUtility._encodeQPWord(bytes, out, charset, specials);
        }
    }

    private static void _encodeQPWord(byte[] data, StringBuffer out, String charset, String specials) {
        out.append("=?");
        out.append(charset);
        out.append("?Q?");
        MimeUtility._encodeQPWordData(data, out, specials);
        out.append("?=");
    }

    private static void _encodeQPWordData(byte[] data, StringBuffer out, String specials) {
        for (int i = 0; i < data.length; ++i) {
            int ch = data[i] & 0xFF;
            if (ch == 32) {
                out.append('_');
                continue;
            }
            if (ch < 32 || ch >= 127 || specials.indexOf(ch) != -1) {
                out.append('=');
                out.append((char)_ENCODING_TABLE[ch >> 4]);
                out.append((char)_ENCODING_TABLE[ch & 0xF]);
                continue;
            }
            out.append((char)ch);
        }
    }

    private static int _estimateQPEncodedLength(byte[] data, String specials) {
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            int ch = data[i] & 0xFF;
            if (ch < 32 || ch >= 127 || specials.indexOf(ch) != -1) {
                count += 3;
                continue;
            }
            ++count;
        }
        return count;
    }

    private MimeUtility() {
    }
}

