/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.desktop;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXTree;
import org.apache.myfaces.trinidad.component.UIXTreeTable;
import org.apache.myfaces.trinidad.component.core.data.CoreTreeTable;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.desktop.DesktopTableRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ResourceKeyUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.CellUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.ColumnData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.FocusColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RowData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.SpecialColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeNodeColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeTableNavRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeTableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;

public class TreeTableRenderer
extends DesktopTableRenderer {
    private static final CoreRenderer _NAV_TOP = new TreeTableNavRenderer(true);
    private static final CoreRenderer _NAV_BOTTOM = new TreeTableNavRenderer(false);
    private static final SpecialColumnRenderer _FOCUS = new FocusColumnRenderer();
    private static final CoreRenderer _TREE_NODE = new TreeNodeColumnRenderer();
    private static final CoreRenderer _CRUMBS = new BreadCrumbsRenderer();
    private static final String _EXPAND_ALL_TEXT_KEY = "af_treeTable.EXPAND_ALL";
    private static final String _COLLAPSE_ALL_TEXT_KEY = "af_treeTable.COLLAPSE_ALL";
    private static final String _BREADCRUMBS_START_KEY = "af_treeTable.BREADCRUMB_START_TIP";
    private PropertyKey _immediateKey;
    private PropertyKey _expandAllEnabledKey;
    private PropertyKey _rootNodeRendered;
    private static final Object _JS_LIBS_KEY = new Object();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TreeTableRenderer.class);

    public TreeTableRenderer() {
        super(CoreTreeTable.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._immediateKey = type.findKey("immediate");
        this._expandAllEnabledKey = type.findKey("expandAllEnabled");
        this._rootNodeRendered = type.findKey("rootNodeRendered");
    }

    @Override
    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        this.decodeSelection(facesContext, component);
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        Object source = parameters.get("source");
        String string = clientId = clientId == null ? component.getClientId(facesContext) : clientId;
        if (clientId.equals(source)) {
            UIXTreeTable treeTable = (UIXTreeTable)component;
            TreeUtils.decodeExpandEvents(parameters, component, TreeUtils.getFocusRowKey(treeTable));
            TreeUtils.decodeFocusEvent(parameters, component);
            TreeUtils.decodeGotoEvent(parameters, component);
            RequestContext.getCurrentInstance().addPartialTarget(component);
        }
    }

    @Override
    protected TableRenderingContext createRenderingContext(FacesContext context, RenderingContext rc, UIComponent component) {
        return new TreeTableRenderingContext(context, rc, component);
    }

    @Override
    protected boolean renderTableWithoutColumns(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        return false;
    }

    @Override
    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        FormData fData = rc.getFormData();
        if (fData != null) {
            fData.addNeededValue("partialTargets");
            fData.addNeededValue("partial");
        }
        if (((UIXTreeTable)component).getNodeStamp() == null) {
            _LOG.warning("NODESTAMP_FACET_MISSING");
            return;
        }
        TreeUtils.setDefaultFocusRowKey((UIXTree)component);
        TreeUtils.expandFocusRowKey((UIXTree)component);
        super.encodeAll(context, rc, component, bean);
        if (rc.getProperties().put(_JS_LIBS_KEY, Boolean.TRUE) == null && TreeTableRenderer.supportsScripting(rc)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", null);
            TreeTableRenderer.renderScriptDeferAttribute(context, rc);
            TreeTableRenderer.renderScriptTypeAttribute(context, rc);
            boolean validate = !this.isImmediate(component, bean);
            String buff = TreeUtils.setupJSTreeCollectionComponent(validate);
            writer.writeText((Object)buff, null);
            writer.endElement("script");
        }
    }

    @Override
    protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
        return null;
    }

    protected boolean isImmediate(UIComponent component, FacesBean bean) {
        return Boolean.TRUE.equals(bean.getProperty(this._immediateKey));
    }

    @Override
    protected void renderNavigationHeaderBars(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component, FacesBean bean) throws IOException {
        super.renderNavigationHeaderBars(context, rc, tContext, component, bean);
        this._renderBreadCrumbs(context, rc, tContext, component, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void renderRangePagingControl(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent table) throws IOException {
        UIXHierarchy comp = (UIXHierarchy)table;
        Object focusKey = comp.getFocusRowKey();
        Object oldKey = comp.getRowKey();
        try {
            comp.setRowKey(focusKey);
            super.renderRangePagingControl(context, rc, tContext, table);
        }
        finally {
            comp.setRowKey(oldKey);
        }
    }

    @Override
    protected boolean hasControlBarLinks(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        return super.hasControlBarLinks(context, rc, tContext, component) || this.isExpandAllEnabled(component);
    }

    @Override
    protected void renderControlBarLinks(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component, boolean useDivider) throws IOException {
        boolean hasExpandAll = this.isExpandAllEnabled(component);
        super.renderControlBarLinks(context, rc, tContext, component, hasExpandAll || useDivider);
        if (hasExpandAll && TreeTableRenderer.supportsScripting(rc)) {
            String preId = component.getClientId(context) + ':';
            TreeTableRenderingContext hContext = (TreeTableRenderingContext)tContext;
            String onclick = TreeUtils.callJSExpandAll((UIXHierarchy)hContext.getUIXTreeTable(), tContext.getJSVarName(), true);
            this.renderControlBarLink(context, rc, onclick, _EXPAND_ALL_TEXT_KEY, rc.getIcon("af|treeTable::expand-all-icon"), preId + "eAll", true);
            onclick = TreeUtils.callJSExpandAll((UIXHierarchy)hContext.getUIXTreeTable(), tContext.getJSVarName(), false);
            this.renderControlBarLink(context, rc, onclick, _COLLAPSE_ALL_TEXT_KEY, rc.getIcon("af|treeTable::collapse-all-icon"), preId + "cAll", useDivider);
        }
    }

    protected void renderControlBarLink(FacesContext context, RenderingContext rc, String onclick, String translationKey, Icon icon, String id, boolean hasDivider) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("id", (Object)id, null);
        TreeTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"OraNavBarActiveLink");
        writer.writeAttribute("onclick", (Object)onclick, null);
        writer.writeURIAttribute("href", (Object)"#", null);
        if (icon != null) {
            OutputUtils.renderIcon(context, rc, icon, rc.getTranslatedString(translationKey), null);
        } else {
            writer.writeText((Object)rc.getTranslatedString(translationKey), null);
        }
        writer.endElement("a");
        if (hasDivider) {
            writer.writeText((Object)"\u00a0|\u00a0", null);
        }
    }

    protected boolean isExpandAllEnabled(UIComponent component) {
        FacesBean bean = this.getFacesBean(component);
        Object bool = bean.getProperty(this._expandAllEnabledKey);
        if (bool == null) {
            bool = this._expandAllEnabledKey.getDefault();
        }
        return Boolean.TRUE.equals(bool);
    }

    @Override
    protected int renderSpecialColumns(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component, int physicalColumnIndex) throws IOException {
        physicalColumnIndex = super.renderSpecialColumns(context, rc, tContext, component, physicalColumnIndex);
        ColumnData colData = tContext.getColumnData();
        TreeTableRenderingContext ttrc = (TreeTableRenderingContext)tContext;
        if (ttrc.isFocusColumnVisible()) {
            colData.setColumnIndex(physicalColumnIndex++, -1);
            SpecialColumnRenderer focusRenderer = this.getFocusColumnRenderer();
            UIComponent column = focusRenderer.getSpecialColumn();
            this.delegateRenderer(context, rc, column, this.getFacesBean(column), focusRenderer);
        }
        colData.setColumnIndex(physicalColumnIndex++, -1);
        UIComponent treeNodeColumn = ttrc.getTreeNodeStamp();
        this.delegateRenderer(context, rc, treeNodeColumn, this.getFacesBean(treeNodeColumn), _TREE_NODE);
        return physicalColumnIndex;
    }

    @Override
    protected void renderTableRows(FacesContext context, RenderingContext rc, TableRenderingContext trc, UIComponent component, FacesBean bean) throws IOException {
        TreeTableRenderingContext ttrc = (TreeTableRenderingContext)trc;
        RowData rowData = trc.getRowData();
        boolean isEmptyTable = rowData.isEmptyTable();
        if (isEmptyTable) {
            this._renderEmptyTableRow(context, rc, ttrc);
        } else {
            this._renderTableRows(context, rc, ttrc, component, bean);
        }
        this.renderFooter(context, rc, trc, component);
    }

    @Override
    protected String getControlLinkIconName(String translationKey) {
        if (translationKey == null) {
            return null;
        }
        return translationKey.equals("af_tableSelectMany.SELECT_ALL") ? "af|treeTable::select-all-icon" : "af|treeTable::select-none-icon";
    }

    protected SpecialColumnRenderer getFocusColumnRenderer() {
        return _FOCUS;
    }

    protected boolean isRootNodeRendered(UIComponent component, FacesBean bean) {
        if (this._rootNodeRendered == null) {
            return true;
        }
        return !Boolean.FALSE.equals(bean.getProperty(this._rootNodeRendered));
    }

    private void _renderLocatorIcon(FacesContext fc, RenderingContext rc) throws IOException {
        Icon icon = rc.getIcon("af|treeTable::locator-icon");
        if (icon != null) {
            String altText = rc.getTranslatedString(_BREADCRUMBS_START_KEY);
            String align = OutputUtils.getMiddleIconAlignment(rc);
            OutputUtils.renderIcon(fc, rc, icon, altText, align);
        }
    }

    private void _renderBreadCrumbs(FacesContext fc, RenderingContext rc, TableRenderingContext context, UIComponent tree, FacesBean bean) throws IOException {
        TreeTableRenderingContext hContext = (TreeTableRenderingContext)context;
        if (hContext.isFocusColumnVisible()) {
            ResponseWriter writer = fc.getResponseWriter();
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.writeAttribute("height", (Object)"30", null);
            String borderStyleClass = CellUtils.getBorderClass(true, true, false, true);
            TreeTableRenderer.renderStyleClasses((FacesContext)fc, (RenderingContext)rc, (String[])new String[]{"OraHGridLocatorHeader", borderStyleClass});
            int colspan = context.getActualColumnCount();
            writer.writeAttribute("colspan", (Object)IntegerUtils.getString((int)colspan), null);
            this.renderSpacer(fc, rc, "0", "2");
            this._renderLocatorIcon(fc, rc);
            this.delegateRenderer(fc, rc, tree, bean, _CRUMBS);
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    private void _renderTableRows(FacesContext context, final RenderingContext rc, final TreeTableRenderingContext ttrc, UIComponent component, FacesBean bean) throws IOException {
        final UIXTreeTable treeTableBase = ttrc.getUIXTreeTable();
        final ResponseWriter writer = context.getResponseWriter();
        final RowKeySet treeState = treeTableBase.getDisclosedRowKeys();
        final int specialColCount = this._getSpecialColCount(ttrc);
        final boolean rootNodeRendered = this.isRootNodeRendered(component, bean);
        TableUtils.RowLoop loop = new TableUtils.RowLoop(){

            @Override
            protected void loop(FacesContext context, CollectionComponent treeTable) throws IOException {
                Object focusPath = TreeUtils.getFocusRowKey(treeTableBase);
                treeTableBase.setRowKey(focusPath);
                this.processRow(context, treeTable);
            }

            @Override
            protected void processRowImpl(FacesContext context, CollectionComponent treeTable) throws IOException {
                if (rootNodeRendered || treeTableBase.getDepth() > 0) {
                    writer.startElement("tr", null);
                    TreeTableRenderer.this.renderSingleRow(context, rc, ttrc, (UIComponent)treeTableBase);
                    writer.endElement("tr");
                }
                if (treeTableBase.isContainer() && (treeState.isContained() || !rootNodeRendered && treeTableBase.getDepth() == 0)) {
                    boolean renderNavRow;
                    treeTableBase.enterContainer();
                    int rows = treeTableBase.getRows();
                    int rowCount = treeTableBase.getRowCount();
                    boolean bl = renderNavRow = rows > 0 && (rowCount < 0 || rowCount > rows);
                    if (renderNavRow) {
                        TreeTableRenderer.this.renderEmptyTableRow(context, rc, ttrc, specialColCount, _NAV_TOP);
                    }
                    super.loop(context, treeTable);
                    if (renderNavRow) {
                        TreeTableRenderer.this.renderEmptyTableRow(context, rc, ttrc, specialColCount, _NAV_BOTTOM);
                    }
                    treeTableBase.exitContainer();
                }
            }
        };
        loop.run(context, (CollectionComponent)treeTableBase);
    }

    private int _renderEmptyTableRow(FacesContext context, RenderingContext rc, TreeTableRenderingContext ttrc) throws IOException {
        this.renderEmptyTableRow(context, rc, ttrc, this._getSpecialColCount(ttrc));
        return 0;
    }

    private int _getSpecialColCount(TreeTableRenderingContext ttrc) {
        int specialCols = 0;
        if (ttrc.hasSelection()) {
            ++specialCols;
        }
        if (ttrc.isFocusColumnVisible()) {
            ++specialCols;
        }
        return specialCols;
    }

    @Override
    protected Map<String, String> createResourceKeyMap() {
        Map<String, String> tablemap = super.createResourceKeyMap();
        Map<String, String> map = ResourceKeyUtils.convertResourceKeyMap(tablemap, "table", "treeTable");
        map.put("af|breadCrumbs::separator-icon", "af|treeTable::separator-icon");
        map.put("af|breadCrumbs", "af|treeTable::path");
        map.put("af|table::content", "af|treeTable::content");
        map.put("af|table::sub-control-bar", "af|treeTable::sub-control-bar");
        map.put("af|table::control-bar-top", "af|treeTable::control-bar-top");
        map.put("af|table::control-bar-bottom", "af|treeTable::control-bar-bottom");
        return Collections.unmodifiableMap(map);
    }

    private static final class BreadCrumbsRenderer
    extends org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.BreadCrumbsRenderer {
        private BreadCrumbsRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void renderLink(FacesContext context, RenderingContext rc, UIComponent child, int renderedCount, boolean isLastChild) throws IOException {
            TreeTableRenderingContext ttrc = TreeTableRenderingContext.getInstance();
            UIXTreeTable tree = ttrc.getUIXTreeTable();
            ResponseWriter out = context.getResponseWriter();
            out.startElement("a", (UIComponent)tree);
            out.writeURIAttribute("href", (Object)"#", null);
            if (isLastChild) {
                BreadCrumbsRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|treeTable::path-selected-step");
            } else {
                BreadCrumbsRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|treeTable::path-step");
            }
            Object oldPath = tree.getRowKey();
            Object focusRowKey = ttrc.getFocusRowKey();
            List focusPath = tree.getAllAncestorContainerRowKeys(focusRowKey);
            Object crumbPath = renderedCount < focusPath.size() ? focusPath.get(renderedCount) : focusRowKey;
            try {
                tree.setRowKey(crumbPath);
                String onclick = TreeUtils.callJSFocusNode((UIXHierarchy)tree, ttrc.getJSVarName());
                out.writeAttribute("onclick", (Object)onclick, null);
                super.renderLink(context, rc, child, renderedCount, isLastChild);
            }
            finally {
                tree.setRowKey(oldPath);
            }
            out.endElement("a");
        }

        @Override
        protected boolean hasChildren(UIComponent component) {
            return false;
        }

        @Override
        protected boolean shouldRenderId(FacesContext context, UIComponent component) {
            return false;
        }

        @Override
        protected UIComponent getStamp(FacesContext context, RenderingContext rc, UIXHierarchy component, FacesBean bean) {
            UIComponent stamp = component.getFacet("pathStamp");
            return stamp;
        }
    }
}

