/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.change.ChangeUtils;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.w3c.dom.Node;

public final class MoveChildComponentChange
extends ComponentChange
implements DocumentChange {
    private final String _moveCompScopedIdAtSource;
    private final String _moveCompAbsoluteScopedIdAtSource;
    private final String _moveCompAbsoluteLogicalScopedIdAtSource;
    private final String _moveCompDocPath;
    private final String _moveCompParentScopedId;
    private final String _moveCompAbsoluteScopedIdAtDestination;
    private final String _moveCompAbsoluteLogicalScopedIdAtDestination;
    private final String _destinationContainerScopedId;
    private final String _destinationContainerDocPath;
    private final String _commonParentScopedId;
    private final String _commonParentDocPath;
    private final String _insertBeforeCompId;
    private static final long serialVersionUID = 1L;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(MoveChildComponentChange.class);

    public MoveChildComponentChange(UIComponent movableChild, UIComponent destinationContainer) {
        this(movableChild, destinationContainer, null);
    }

    public MoveChildComponentChange(UIComponent movableChild, UIComponent destinationContainer, UIComponent insertBeforeComponent) {
        if (movableChild == null) {
            throw new IllegalArgumentException(_LOG.getMessage("MOVABLE_CHILD_REQUIRED"));
        }
        FacesContext context = FacesContext.getCurrentInstance();
        this._moveCompDocPath = ComponentUtils.getDocumentLocationForComponent(context, movableChild);
        this._destinationContainerDocPath = ComponentUtils.getDocumentLocationForComponent(context, destinationContainer);
        if (this._moveCompDocPath == null || this._destinationContainerDocPath == null) {
            throw new IllegalArgumentException(_LOG.getMessage("NO_CONTAINING_DOC_FOUND", this._moveCompDocPath == null ? movableChild : destinationContainer));
        }
        destinationContainer = MoveChildComponentChange._getValidatedDestinationContainer(destinationContainer, insertBeforeComponent);
        UIComponent commonParent = this._getValidatedCommonParent(context, movableChild, destinationContainer);
        this._commonParentDocPath = ComponentUtils.getDocumentLocationForComponent(context, commonParent);
        UIViewRoot viewRoot = context.getViewRoot();
        this._moveCompScopedIdAtSource = ComponentUtils.getScopedIdForComponent(movableChild, commonParent);
        this._moveCompParentScopedId = ComponentUtils.getScopedIdForComponent(movableChild.getParent(), commonParent);
        this._destinationContainerScopedId = ComponentUtils.getScopedIdForComponent(destinationContainer, commonParent);
        this._commonParentScopedId = ComponentUtils.getScopedIdForComponent(commonParent, (UIComponent)viewRoot);
        if (this._moveCompScopedIdAtSource == null || this._moveCompParentScopedId == null || this._destinationContainerScopedId == null || this._commonParentScopedId == null) {
            throw new IllegalArgumentException(_LOG.getMessage("MOVE_PARTICIPANTS_WITHOUT_ID"));
        }
        String commonParentPrefix = this._getScopedIdPrefix(commonParent, this._commonParentScopedId);
        this._moveCompAbsoluteScopedIdAtSource = commonParentPrefix != null ? commonParentPrefix + ':' + this._moveCompScopedIdAtSource : this._moveCompScopedIdAtSource;
        this._moveCompAbsoluteLogicalScopedIdAtSource = ComponentUtils.getLogicalScopedIdForComponent(movableChild, (UIComponent)viewRoot);
        String destinationContainerPrefix = this._getScopedIdPrefix(destinationContainer, this._destinationContainerScopedId);
        StringBuilder moveCompAtDestinationScopedIdBuilder = new StringBuilder();
        if (commonParentPrefix != null) {
            moveCompAtDestinationScopedIdBuilder.append(commonParentPrefix).append(':');
        }
        if (destinationContainerPrefix != null) {
            moveCompAtDestinationScopedIdBuilder.append(destinationContainerPrefix).append(':');
        }
        String movableChildId = movableChild.getId();
        this._moveCompAbsoluteScopedIdAtDestination = moveCompAtDestinationScopedIdBuilder.append(movableChildId).toString();
        String destinationLogicalPrefix = this._getScopedIdPrefix(destinationContainer, ComponentUtils.getLogicalScopedIdForComponent(destinationContainer, (UIComponent)viewRoot));
        this._moveCompAbsoluteLogicalScopedIdAtDestination = destinationLogicalPrefix != null ? destinationLogicalPrefix + ':' + movableChildId : movableChildId;
        this._insertBeforeCompId = insertBeforeComponent == null ? null : insertBeforeComponent.getId();
    }

    public UIComponent add(FacesContext facesContext, ChangeManager changeManager) {
        UIComponent commonParent = facesContext.getViewRoot().findComponent(this._commonParentScopedId);
        if (commonParent == null) {
            _LOG.warning("COMMON_PARENT_NOT_FOUND", this._commonParentScopedId);
            return null;
        }
        changeManager.addComponentChange(facesContext, commonParent, this);
        return commonParent;
    }

    @Override
    public void changeComponent(UIComponent changeTargetComponent) {
        if (changeTargetComponent == null) {
            throw new IllegalArgumentException(_LOG.getMessage("COMPONENT_REQUIRED"));
        }
        UIComponent destinationContainer = changeTargetComponent.findComponent(this._destinationContainerScopedId);
        if (destinationContainer == null) {
            _LOG.warning("DESTINATION_CONTAINER_NOT_FOUND", this._destinationContainerScopedId);
            return;
        }
        UIComponent sourceParent = changeTargetComponent.findComponent(this._moveCompParentScopedId);
        UIComponent foundChild = changeTargetComponent.findComponent(this._moveCompScopedIdAtSource);
        boolean isChildIdAtDestination = false;
        UIComponent movableChild = null;
        int movableChildIndex = 0;
        UIComponent movedChild = null;
        int movedChildIndex = 0;
        UIComponent duplicateChild = null;
        int duplicateChildIndex = 0;
        UIComponent duplicateChildParent = null;
        while (foundChild != null) {
            if (foundChild.getParent().equals(sourceParent)) {
                movableChild = foundChild;
                movableChildIndex = sourceParent.getChildren().indexOf(movableChild);
            } else if (foundChild.getParent().equals(destinationContainer)) {
                isChildIdAtDestination = true;
                movedChild = foundChild;
                movedChildIndex = destinationContainer.getChildren().indexOf(movedChild);
            } else {
                duplicateChild = foundChild;
                duplicateChildIndex = foundChild.getParent().getChildren().indexOf(foundChild);
                duplicateChildParent = foundChild.getParent();
            }
            foundChild.getParent().getChildren().remove(foundChild);
            foundChild = changeTargetComponent.findComponent(this._moveCompScopedIdAtSource);
        }
        if (duplicateChild != null) {
            duplicateChildParent.getChildren().add(duplicateChildIndex, duplicateChild);
        }
        if (movableChild == null) {
            _LOG.warning("MOVABLE_CHILD_NOT_FOUND", this._moveCompScopedIdAtSource);
            if (movedChild != null) {
                destinationContainer.getChildren().add(movedChildIndex, movedChild);
            }
            return;
        }
        if (!isChildIdAtDestination) {
            String movableChildId = movableChild.getId();
            for (UIComponent childComponent : destinationContainer.getChildren()) {
                if (!movableChildId.equals(childComponent.getId())) continue;
                isChildIdAtDestination = true;
                movedChild = childComponent;
                movedChild.getParent().getChildren().remove(movedChild);
                break;
            }
        }
        if (isChildIdAtDestination) {
            _LOG.warning("MOVABLE_CHILD_SAME_ID_FOUND", this._moveCompScopedIdAtSource);
            if (movableChild.getFamily().equals(movedChild.getFamily()) && movableChild.getRendererType().equals(movedChild.getRendererType())) {
                destinationContainer.getChildren().add(movedChildIndex, movedChild);
            } else {
                sourceParent.getChildren().add(movableChildIndex, movableChild);
            }
            return;
        }
        sourceParent.getChildren().add(movableChildIndex, movableChild);
        int insertIndex = -1;
        if (this._insertBeforeCompId != null) {
            for (UIComponent childComponent : destinationContainer.getChildren()) {
                if (!this._insertBeforeCompId.equals(childComponent.getId())) continue;
                insertIndex = destinationContainer.getChildren().indexOf(childComponent);
                break;
            }
            if (insertIndex == -1) {
                _LOG.warning("INSERT_BEFORE_NOT_FOUND", this._insertBeforeCompId);
                return;
            }
        }
        if (insertIndex == -1) {
            destinationContainer.getChildren().add(movableChild);
        } else {
            destinationContainer.getChildren().add(insertIndex, movableChild);
        }
    }

    @Override
    public void changeDocument(Node changeTargetNode) {
        Node insertBeforeNode;
        if (changeTargetNode == null) {
            throw new IllegalArgumentException(_LOG.getMessage("NO_NODE_SPECIFIED"));
        }
        if (!this._moveCompDocPath.equals(this._destinationContainerDocPath) || !this._moveCompDocPath.equals(this._commonParentDocPath)) {
            throw new IllegalStateException(_LOG.getMessage("MOVE_PARTICIPANTS_NOT_IN_SAME_DOC", new Object[]{this._moveCompDocPath, this._destinationContainerDocPath, this._commonParentDocPath}));
        }
        Node movableChildNode = ChangeUtils.__findNodeByScopedId(changeTargetNode, this._moveCompScopedIdAtSource, Integer.MAX_VALUE);
        if (movableChildNode == null) {
            _LOG.warning("MOVABLE_CHILD_NOT_FOUND", this._moveCompScopedIdAtSource);
            return;
        }
        Node destinationContainerNode = ChangeUtils.__findNodeByScopedId(changeTargetNode, this._destinationContainerScopedId, Integer.MAX_VALUE);
        if (destinationContainerNode == null) {
            _LOG.warning("DESTINATION_CONTAINER_NOT_FOUND", this._destinationContainerScopedId);
            return;
        }
        Node node = insertBeforeNode = this._insertBeforeCompId == null ? null : ChangeUtils.__findNodeByScopedId(destinationContainerNode, this._insertBeforeCompId, 1);
        if (this._insertBeforeCompId != null && insertBeforeNode == null) {
            _LOG.warning("INSERT_BEFORE_NOT_FOUND", this._insertBeforeCompId);
            return;
        }
        destinationContainerNode.insertBefore(movableChildNode, insertBeforeNode);
    }

    @Override
    public boolean getForcesDocumentReload() {
        return true;
    }

    public String getSourceScopedId() {
        return this._moveCompAbsoluteScopedIdAtSource;
    }

    public String getDestinationScopedId() {
        return this._moveCompAbsoluteScopedIdAtDestination;
    }

    public String getSourceLogicalScopedId() {
        return this._moveCompAbsoluteLogicalScopedIdAtSource;
    }

    public String getDestinationLogicalScopedId() {
        return this._moveCompAbsoluteLogicalScopedIdAtDestination;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoveChildComponentChange)) {
            return false;
        }
        MoveChildComponentChange other = (MoveChildComponentChange)o;
        return this._equalsOrNull(this._moveCompScopedIdAtSource, other._moveCompScopedIdAtSource) && this._equalsOrNull(this._moveCompAbsoluteScopedIdAtSource, other._moveCompAbsoluteScopedIdAtSource) && this._equalsOrNull(this._moveCompAbsoluteLogicalScopedIdAtSource, other._moveCompAbsoluteLogicalScopedIdAtSource) && this._equalsOrNull(this._moveCompDocPath, other._moveCompDocPath) && this._equalsOrNull(this._moveCompParentScopedId, other._moveCompParentScopedId) && this._equalsOrNull(this._moveCompAbsoluteScopedIdAtDestination, other._moveCompAbsoluteScopedIdAtDestination) && this._equalsOrNull(this._moveCompAbsoluteLogicalScopedIdAtDestination, other._moveCompAbsoluteLogicalScopedIdAtDestination) && this._equalsOrNull(this._destinationContainerScopedId, other._destinationContainerScopedId) && this._equalsOrNull(this._destinationContainerDocPath, other._destinationContainerDocPath) && this._equalsOrNull(this._commonParentScopedId, other._commonParentScopedId) && this._equalsOrNull(this._commonParentDocPath, other._commonParentDocPath) && this._equalsOrNull(this._insertBeforeCompId, other._insertBeforeCompId);
    }

    public int hashCode() {
        return (this._moveCompScopedIdAtSource == null ? 0 : this._moveCompScopedIdAtSource.hashCode()) + 37 * (this._moveCompAbsoluteScopedIdAtSource == null ? 0 : this._moveCompAbsoluteScopedIdAtSource.hashCode()) + 37 * (this._moveCompAbsoluteLogicalScopedIdAtSource == null ? 0 : this._moveCompAbsoluteLogicalScopedIdAtSource.hashCode()) + 37 * (this._moveCompDocPath == null ? 0 : this._moveCompDocPath.hashCode()) + 37 * (this._moveCompParentScopedId == null ? 0 : this._moveCompParentScopedId.hashCode()) + 37 * (this._moveCompAbsoluteScopedIdAtDestination == null ? 0 : this._moveCompAbsoluteScopedIdAtDestination.hashCode()) + 37 * (this._moveCompAbsoluteLogicalScopedIdAtDestination == null ? 0 : this._moveCompAbsoluteLogicalScopedIdAtDestination.hashCode()) + 37 * (this._destinationContainerScopedId == null ? 0 : this._destinationContainerScopedId.hashCode()) + 37 * (this._destinationContainerDocPath == null ? 0 : this._destinationContainerDocPath.hashCode()) + 37 * (this._commonParentScopedId == null ? 0 : this._commonParentScopedId.hashCode()) + 37 * (this._commonParentDocPath == null ? 0 : this._commonParentDocPath.hashCode()) + 37 * (this._insertBeforeCompId == null ? 0 : this._insertBeforeCompId.hashCode());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("[moveCompAbsoluteLogicalScopedIdAtSource=").append(this._moveCompAbsoluteScopedIdAtSource);
        sb.append(" moveCompAbsoluteLogicalScopedIdAtDestination=").append(this._moveCompAbsoluteLogicalScopedIdAtDestination);
        sb.append(" moveCompAbsoluteScopedIdAtSource=").append(this._moveCompAbsoluteScopedIdAtSource);
        sb.append(" moveCompAbsoluteScopedIdAtDestination=").append(this._moveCompAbsoluteScopedIdAtDestination);
        sb.append(" insertBeforeCompId=").append(this._insertBeforeCompId);
        sb.append(" commonParentScopedId=").append(this._commonParentScopedId);
        sb.append(" moveCompDocPath=").append(this._moveCompDocPath);
        sb.append(" destinationContainerDocPath=").append(this._destinationContainerDocPath);
        return sb.append("]").toString();
    }

    private UIComponent _getValidatedCommonParent(FacesContext context, UIComponent componentToMove, UIComponent parentAtDestination) {
        int firstDepth = MoveChildComponentChange._computeDepth(componentToMove);
        int secondDepth = MoveChildComponentChange._computeDepth(parentAtDestination);
        if (secondDepth > firstDepth) {
            parentAtDestination = MoveChildComponentChange._getAncestor(parentAtDestination, secondDepth - firstDepth);
        } else if (secondDepth < firstDepth) {
            componentToMove = MoveChildComponentChange._getAncestor(componentToMove, firstDepth - secondDepth);
        }
        while (componentToMove != null && componentToMove != parentAtDestination) {
            componentToMove = componentToMove.getParent();
            parentAtDestination = parentAtDestination.getParent();
        }
        UIComponent commonParent = componentToMove;
        if (this._moveCompDocPath.equals(this._destinationContainerDocPath)) {
            commonParent = this._getUIXComponentAncestorInDoc(context, commonParent);
        }
        if (commonParent == null) {
            throw new IllegalArgumentException(_LOG.getMessage("COMMON_PARENT_NOT_FOUND"));
        }
        return commonParent;
    }

    private UIComponent _getUIXComponentAncestorInDoc(FacesContext context, UIComponent baseComp) {
        for (UIComponent ancestor = baseComp; ancestor != null; ancestor = ancestor.getParent()) {
            if (!(ancestor instanceof UIXComponent) || !this._moveCompDocPath.equals(ComponentUtils.getDocumentLocationForComponent(context, ancestor))) continue;
            return ancestor;
        }
        return baseComp;
    }

    private String _getScopedIdPrefix(UIComponent component, String scopedId) {
        if (component instanceof NamingContainer) {
            return scopedId;
        }
        int separatorIndex = scopedId.lastIndexOf(58);
        if (separatorIndex >= 0) {
            return scopedId.substring(0, separatorIndex);
        }
        return null;
    }

    private boolean _equalsOrNull(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    private static UIComponent _getValidatedDestinationContainer(UIComponent destinationContainer, UIComponent insertBeforeComponent) {
        if (insertBeforeComponent != null) {
            UIComponent parent = insertBeforeComponent.getParent();
            if (destinationContainer == null) {
                destinationContainer = parent;
            } else if (destinationContainer != parent) {
                throw new IllegalArgumentException(_LOG.getMessage("DESTINATION_CONTAINER_NOT_INSERTBEFORES_PARENT"));
            }
        } else if (destinationContainer == null) {
            throw new IllegalArgumentException(_LOG.getMessage("DESTINATION_CONTAINER_REQUIRED"));
        }
        return destinationContainer;
    }

    private static int _computeDepth(UIComponent comp) {
        int i = 0;
        while ((comp = comp.getParent()) != null) {
            ++i;
        }
        return i;
    }

    private static UIComponent _getAncestor(UIComponent component, int level) {
        assert (level >= 0);
        while (level > 0) {
            component = component.getParent();
            --level;
        }
        return component;
    }
}

