/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.facelets;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.MethodExpression;
import javax.faces.el.MethodBinding;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import org.apache.myfaces.trinidadinternal.facelets.LegacyMethodBinding;

final class TrinidadListenersTagRule
extends MetaRule {
    public static final MetaRule Instance = new TrinidadListenersTagRule();

    TrinidadListenersTagRule() {
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method m;
        boolean isMethodExpression;
        Class metaType = meta.getPropertyType(name);
        boolean isMethodBinding = metaType == MethodBinding.class;
        boolean bl = isMethodExpression = metaType == MethodExpression.class;
        if ((isMethodBinding || isMethodExpression) && name.endsWith("Listener") && (m = meta.getWriteMethod(name)) != null) {
            PropertyDescriptor listeners = meta.getProperty(name + "s");
            if (listeners == null) {
                return null;
            }
            Class<?> arrayType = listeners.getPropertyType();
            if (!arrayType.isArray()) {
                return null;
            }
            Class<?> listenerClass = arrayType.getComponentType();
            if (!listenerClass.getName().startsWith("org.apache.myfaces.trinidad.")) {
                return null;
            }
            Class<?> eventClass = TrinidadListenersTagRule._getEventClass(listenerClass);
            if (eventClass == null) {
                return null;
            }
            if (isMethodBinding) {
                return new ListenerMBPropertyMetadata(m, attribute, new Class[]{eventClass});
            }
            return new ListenerMEPropertyMetadata(m, attribute, new Class[]{eventClass});
        }
        return null;
    }

    private static Class<?> _getEventClass(Class<?> listenerClass) {
        String listenerName = listenerClass.getName();
        if (!listenerName.endsWith("Listener")) {
            return null;
        }
        String eventName = listenerName.substring(0, listenerName.length() - "Listener".length()) + "Event";
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(eventName, true, loader);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    private static class ListenerMEPropertyMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class[] _paramList;

        public ListenerMEPropertyMetadata(Method method, TagAttribute attribute, Class[] paramList) {
            this._method = method;
            this._attribute = attribute;
            this._paramList = paramList;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            MethodExpression expr = this._attribute.getMethodExpression(ctx, null, this._paramList);
            try {
                this._method.invoke(instance, expr);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }

    private static class ListenerMBPropertyMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class[] _paramList;

        public ListenerMBPropertyMetadata(Method method, TagAttribute attribute, Class[] paramList) {
            this._method = method;
            this._attribute = attribute;
            this._paramList = paramList;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            MethodExpression expr = this._attribute.getMethodExpression(ctx, null, this._paramList);
            try {
                this._method.invoke(instance, new LegacyMethodBinding(expr));
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }
}

