/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.pages;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.core.nav.CoreGoButton;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.util.nls.StringUtils;

class JspUtils {
    JspUtils() {
    }

    public static CoreGoButton createGoButton(RenderingContext arc, String textKey) {
        CoreGoButton button = new CoreGoButton();
        String selectText = arc.getTranslatedString(textKey);
        button.setText(StringUtils.stripMnemonic(selectText));
        char ch = JspUtils._getMnemonic(selectText);
        if (ch != '\u0000') {
            button.setAccessKey(ch);
        }
        return button;
    }

    public static String getEncoding(FacesContext context, String defaultEncoding) {
        String enc = JspUtils.getEncoding(context);
        if (enc == null) {
            enc = defaultEncoding;
        }
        return enc;
    }

    public static String getEncoding(FacesContext context) {
        String encoding = (String)context.getExternalContext().getRequestParameterMap().get("enc");
        if (encoding != null && (encoding.indexOf(13) >= 0 || encoding.indexOf(10) >= 0)) {
            throw new IllegalArgumentException("Encoding parameter contains line/header delimiters");
        }
        return encoding;
    }

    public static Integer integerValueOfParam(Map<String, String> requestParams, String key) {
        String value = requestParams.get(key);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static Long longValueOfParam(Map<String, String> requestParams, String key) {
        String value = requestParams.get(key);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private static char _getMnemonic(String text) {
        if (text == null) {
            return '\u0000';
        }
        int accessKeyIndex = StringUtils.getMnemonicIndex(text);
        if (accessKeyIndex != -1) {
            return text.charAt(accessKeyIndex + 1);
        }
        return '\u0000';
    }
}

