/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinMetadata;
import org.apache.myfaces.trinidad.skin.SkinProvider;
import org.apache.myfaces.trinidad.skin.SkinVersion;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.skin.SkinUtils;
import org.apache.myfaces.trinidadinternal.skin.provider.BaseSkinProvider;
import org.apache.myfaces.trinidadinternal.skin.provider.ExternalSkinProvider;
import org.apache.myfaces.trinidadinternal.skin.provider.TrinidadBaseSkinProvider;
import org.apache.myfaces.trinidadinternal.skin.provider.TrinidadSkinProvider;

public class SkinProviderRegistry
extends SkinProvider {
    private final List<SkinProvider> _providers;
    private static final String _SKIN_PROVIDER_CONTEXT = "org.apache.myfaces.trinidadinternal.skin.provider.SkinProviderRegistry.Context";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinProviderRegistry.class);

    public SkinProviderRegistry() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        List services = ClassLoaderUtils.getServices((String)SkinProvider.class.getName());
        if (_LOG.isFine()) {
            _LOG.fine("Adding providers from registered SPIs... " + services.size());
        }
        ArrayList<BaseSkinProvider> providers = new ArrayList<BaseSkinProvider>(services.size() + 2);
        providers.addAll(services);
        if (_LOG.isFine()) {
            _LOG.fine("Adding TrinidadSkinProvider... ");
        }
        providers.add(TrinidadSkinProvider.getCurrentInstance(externalContext));
        if (_LOG.isFine()) {
            _LOG.fine("Adding TrinidadBaseSkinProvider... ");
        }
        providers.add(new TrinidadBaseSkinProvider());
        if (_LOG.isFine()) {
            _LOG.fine("Adding ExternalSkinProvider... ");
        }
        providers.add(ExternalSkinProvider.getCurrentInstance(externalContext));
        this._providers = Collections.unmodifiableList(providers);
    }

    public Collection<SkinMetadata> getSkinMetadata(ExternalContext externalContext) {
        ArrayList metadata = new ArrayList();
        for (SkinProvider provider : this._providers) {
            metadata.addAll(provider.getSkinMetadata(externalContext));
        }
        return Collections.unmodifiableCollection(metadata);
    }

    public Skin getSkin(ExternalContext externalContext, SkinMetadata skinMetadata) {
        this._handleCircularDependency(skinMetadata);
        List<Skin> matchingSkins = new ArrayList<Skin>();
        Skin matchingSkin = null;
        if (_LOG.isFine()) {
            _LOG.fine("Skin request for metadata: " + skinMetadata);
        }
        for (SkinProvider provider : this._providers) {
            matchingSkin = provider.getSkin(externalContext, skinMetadata);
            if (matchingSkin == null) continue;
            if (_LOG.isFine()) {
                _LOG.fine("Skin obtained for metadata: " + skinMetadata + " from provider: " + provider);
            }
            matchingSkins.add(matchingSkin);
        }
        if (_LOG.isFine()) {
            _LOG.fine("Matches obtained for " + skinMetadata + ": " + matchingSkins.size());
        }
        if ((matchingSkins = this._filterSkins(matchingSkins, skinMetadata)).isEmpty()) {
            if (_LOG.isFine()) {
                _LOG.fine("NO MATCH. Will return a simple skin or null for skin metadata: " + skinMetadata);
            }
            assert (skinMetadata.getRenderKitId() != null);
            matchingSkin = SkinUtils.getDefaultSkinForRenderKitId(this, externalContext, skinMetadata.getRenderKitId());
            this._processSkinForReturn(skinMetadata, matchingSkin);
            return matchingSkin;
        }
        if (matchingSkins.size() == 1) {
            if (_LOG.isFine()) {
                _LOG.fine("returning ONLY match for skin metadata: " + skinMetadata);
            }
            matchingSkin = matchingSkins.get(0);
            this._processSkinForReturn(skinMetadata, matchingSkin);
            return matchingSkin;
        }
        return this._versionFilter(skinMetadata, matchingSkins);
    }

    List<SkinProvider> getProviders() {
        return this._providers;
    }

    private List<Skin> _filterSkins(List<Skin> skins, SkinMetadata metadata) {
        if (skins == null || skins.isEmpty() || metadata == null) {
            return Collections.emptyList();
        }
        List<Skin> filterList = this._idFilter(skins, metadata.getId());
        if (filterList.size() == 1 && metadata.getId() != null) {
            return filterList;
        }
        if ((filterList = this._familyFilter(filterList, metadata.getFamily())).size() == 1 && metadata.getFamily() != null) {
            return filterList;
        }
        filterList = this._renderKitFilter(filterList, metadata.getRenderKitId());
        return filterList;
    }

    private List<Skin> _idFilter(List<Skin> skins, String id) {
        if (id == null || id.isEmpty()) {
            return skins;
        }
        ArrayList<Skin> filterList = new ArrayList<Skin>(skins.size());
        for (Skin skin : skins) {
            if (!id.equals(skin.getId())) continue;
            filterList.add(skin);
        }
        return filterList;
    }

    private List<Skin> _familyFilter(List<Skin> skins, String family) {
        if (family == null || family.isEmpty()) {
            return skins;
        }
        ArrayList<Skin> filterList = new ArrayList<Skin>(skins.size());
        for (Skin skin : skins) {
            if (!family.equalsIgnoreCase(skin.getFamily())) continue;
            filterList.add(skin);
        }
        return filterList;
    }

    private List<Skin> _renderKitFilter(List<Skin> skins, String renderKitId) {
        if (renderKitId == null || renderKitId.isEmpty()) {
            return skins;
        }
        ArrayList<Skin> filterList = new ArrayList<Skin>(skins.size());
        for (Skin skin : skins) {
            if (!renderKitId.equalsIgnoreCase(skin.getRenderKitId())) continue;
            filterList.add(skin);
        }
        return filterList;
    }

    private Skin _versionFilter(SkinMetadata searchCriteria, List<Skin> matchingSkins) {
        SkinVersion version = searchCriteria.getVersion();
        Skin matchingSkin = this._findSkinForVersionName(matchingSkins, version);
        if (matchingSkin != null) {
            if (_LOG.isFine()) {
                _LOG.fine("returning exact version match.");
            }
            this._processSkinForReturn(searchCriteria, matchingSkin);
            return matchingSkin;
        }
        matchingSkin = this._findSkinWithDefaultVersion(matchingSkins);
        if (matchingSkin != null) {
            if (_LOG.isFine()) {
                _LOG.fine("returning DEFAULT version match.");
            }
            this._processSkinForReturn(searchCriteria, matchingSkin);
            return matchingSkin;
        }
        matchingSkin = this._findLeafSkin(matchingSkins);
        if (matchingSkin != null) {
            if (_LOG.isFine()) {
                _LOG.fine("return LEAF skin or one of the matches.");
            }
            this._processSkinForReturn(searchCriteria, matchingSkin);
            return matchingSkin;
        }
        if (_LOG.isFine()) {
            _LOG.fine("nothing worked so return first match.");
        }
        matchingSkin = matchingSkins.get(0);
        this._processSkinForReturn(searchCriteria, matchingSkins.get(0));
        return matchingSkin;
    }

    private void _processSkinForReturn(SkinMetadata skinMetadata, Skin skin) {
        FacesContext context = FacesContext.getCurrentInstance();
        this._clearReturningSkinContext(context, skinMetadata);
        TrinidadSkinProvider.getCurrentInstance(context.getExternalContext()).ensureSkinAdditions(skin);
    }

    private void _clearReturningSkinContext(FacesContext context, SkinMetadata skinMetadata) {
        Map attrMap = context.getAttributes();
        Object o = attrMap.get(_SKIN_PROVIDER_CONTEXT);
        if (o != null) {
            List requesters = (List)o;
            requesters.remove(skinMetadata);
            if (_LOG.isFiner()) {
                _LOG.finer("Removing " + skinMetadata + " from context");
                _LOG.finer("Context now is " + requesters);
            }
        }
    }

    private Skin _findSkinForVersionName(Collection<Skin> skins, SkinVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("skin version cannot be null");
        }
        if (version.getName() == null || version.getName().isEmpty()) {
            return null;
        }
        for (Skin skin : skins) {
            if (!version.getName().equals(skin.getVersion().getName())) continue;
            if (_LOG.isFine()) {
                _LOG.fine("Found version match skin: " + skin);
            }
            return skin;
        }
        return null;
    }

    private Skin _findLeafSkin(Collection<Skin> skins) {
        ArrayList<Skin> leafSkins = new ArrayList<Skin>();
        ArrayList<String> parentIds = new ArrayList<String>();
        for (Skin metadata : skins) {
            String parentId;
            Skin baseSkin = metadata.getBaseSkin();
            if (baseSkin == null || (parentId = baseSkin.getId()) == null) continue;
            parentIds.add(parentId);
        }
        for (Skin skin : skins) {
            String skinId = skin.getId();
            if (skinId == null || parentIds.contains(skinId)) continue;
            leafSkins.add(skin);
        }
        if (leafSkins.isEmpty()) {
            return null;
        }
        return (Skin)leafSkins.get(leafSkins.size() - 1);
    }

    private Skin _findSkinWithDefaultVersion(Collection<Skin> matchingSkinList) {
        for (Skin skin : matchingSkinList) {
            SkinVersion skinVersion = skin.getVersion();
            if (skinVersion == null || !skinVersion.isDefault()) continue;
            if (_LOG.isFine()) {
                _LOG.fine("Found default skin: " + skin);
            }
            return skin;
        }
        return null;
    }

    private void _handleCircularDependency(SkinMetadata skinMetadata) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map attrMap = context.getAttributes();
        Object o = attrMap.get(_SKIN_PROVIDER_CONTEXT);
        ArrayList<SkinMetadata> requesters = null;
        if (o == null) {
            requesters = new ArrayList<SkinMetadata>();
            attrMap.put(_SKIN_PROVIDER_CONTEXT, requesters);
        } else {
            requesters = (ArrayList<SkinMetadata>)o;
        }
        if (requesters.contains(skinMetadata)) {
            String message = "Circular dependency detected while loading skin: " + skinMetadata + ". Requesters are: " + requesters;
            if (_LOG.isSevere()) {
                _LOG.severe(message);
            }
            throw new IllegalStateException(message);
        }
        requesters.add(skinMetadata);
        if (_LOG.isFiner()) {
            _LOG.finer("Adding " + skinMetadata + " to context");
            _LOG.finer("Context now is " + requesters);
        }
    }
}

