/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.util.concurrent.ConcurrentMap;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;

public class FrameBustingUtils {
    public static final String FRAME_BUSTING_PARAM = "org.apache.myfaces.trinidad.security.FRAME_BUSTING";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FrameBustingUtils.class);

    public static FrameBustingParamValue getFrameBustingValue(FacesContext context, RequestContext reqContext) {
        if (reqContext.isPartialRequest(context) || ExternalContextUtils.isPortlet((ExternalContext)context.getExternalContext())) {
            return FrameBustingParamValue.FRAME_BUSTING_NEVER;
        }
        ConcurrentMap appMap = reqContext.getApplicationScopedConcurrentMap();
        FrameBustingParamValue frameBusting = (FrameBustingParamValue)((Object)appMap.get(FRAME_BUSTING_PARAM));
        if (frameBusting == null) {
            String frameBustingString = context.getExternalContext().getInitParameter(FRAME_BUSTING_PARAM);
            if (frameBustingString == null) {
                frameBusting = FrameBustingParamValue.FRAME_BUSTING_DIFFERENT_ORIGIN;
            } else {
                frameBusting = FrameBustingParamValue.valueOfDisplayName(frameBustingString);
                if (frameBusting == null) {
                    frameBusting = FrameBustingParamValue.FRAME_BUSTING_DIFFERENT_ORIGIN;
                    _LOG.warning("UNKNOWN_FRAME_BUSTING_VALUE");
                }
            }
            appMap.put(FRAME_BUSTING_PARAM, frameBusting);
        }
        return frameBusting;
    }

    public static void overrideFrameBustingValue(RequestContext reqContext, FrameBustingParamValue frameBusting) {
        ConcurrentMap appMap = reqContext.getApplicationScopedConcurrentMap();
        appMap.put(FRAME_BUSTING_PARAM, frameBusting);
    }

    public static enum FrameBustingParamValue {
        FRAME_BUSTING_NEVER("never"),
        FRAME_BUSTING_ALWAYS("always"),
        FRAME_BUSTING_DIFFERENT_ORIGIN("differentOrigin");

        private String _value;

        private FrameBustingParamValue(String value) {
            this._value = value;
        }

        public String toString() {
            return this._value;
        }

        public String displayName() {
            return this._value;
        }

        public static FrameBustingParamValue valueOfDisplayName(String displayName) {
            if (FRAME_BUSTING_NEVER.displayName().equalsIgnoreCase(displayName)) {
                return FRAME_BUSTING_NEVER;
            }
            if (FRAME_BUSTING_ALWAYS.displayName().equalsIgnoreCase(displayName)) {
                return FRAME_BUSTING_ALWAYS;
            }
            if (FRAME_BUSTING_DIFFERENT_ORIGIN.displayName().equalsIgnoreCase(displayName)) {
                return FRAME_BUSTING_DIFFERENT_ORIGIN;
            }
            return null;
        }
    }
}

