/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.ArrayList;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.event.RowDisclosureEvent;
import org.apache.myfaces.trinidad.model.RowKeySet;

public final class HierarchyUtils {
    static void __handleBroadcast(UIXHierarchy comp, FacesEvent event, RowKeySet state, MethodExpression method) throws AbortProcessingException {
        if (event instanceof RowDisclosureEvent) {
            RowDisclosureEvent dEvent = (RowDisclosureEvent)event;
            state.removeAll(dEvent.getRemovedSet());
            state.addAll(dEvent.getAddedSet());
            comp.addAttributeChange("disclosedRowKeys", state);
            comp.broadcastToMethodExpression(event, method);
        }
    }

    static void __handleEncodeBegin(UIXHierarchy comp, RowKeySet set) {
        Object focusRowKey;
        if (comp.__isFirstRender() && (focusRowKey = comp.getFocusRowKey()) != null) {
            ArrayList<Object> focusPath = new ArrayList<Object>(comp.getAllAncestorContainerRowKeys(focusRowKey));
            focusPath.add(focusRowKey);
            int size = focusPath.size();
            for (int i = 0; i < size; ++i) {
                Object subkey = focusPath.get(i);
                set.add(subkey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void __processLevel(FacesContext context, PhaseId phaseId, UIXHierarchy comp) {
        UIComponent nodeStamp;
        if (comp.getRowCount() != 0 && (nodeStamp = comp.getFacet("nodeStamp")) != null) {
            Object oldRowKey = comp.getRowKey();
            try {
                int startIndex = comp.getFirst();
                int endIndex = TableUtils.getLast(comp, startIndex);
                for (int i = startIndex; i <= endIndex; ++i) {
                    comp.setRowIndex(i);
                    comp.processComponent(context, nodeStamp, phaseId);
                }
            }
            finally {
                comp.setRowKey(oldRowKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void __iterateOverTree(FacesContext context, PhaseId phaseId, UIXHierarchy comp, RowKeySet state, boolean processChildrenAsStamps) {
        UIComponent nodeStamp = comp.getFacet("nodeStamp");
        int oldRow = comp.getRowIndex();
        try {
            int first = comp.getFirst();
            int last = TableUtils.getLast(comp, first);
            for (int i = first; i <= last; ++i) {
                comp.setRowIndex(i);
                if (processChildrenAsStamps) {
                    TableUtils.processStampedChildren(context, comp, phaseId);
                }
                comp.processComponent(context, nodeStamp, phaseId);
                if (!comp.isContainer() || !state.isContained()) continue;
                comp.enterContainer();
                try {
                    HierarchyUtils.__iterateOverTree(context, phaseId, comp, state, processChildrenAsStamps);
                    continue;
                }
                finally {
                    comp.exitContainer();
                }
            }
        }
        finally {
            comp.setRowIndex(oldRow);
        }
    }

    static boolean __setStartDepthPath(UIXHierarchy component, int startDepth) {
        boolean isNewPath = false;
        Object focusKey = component.getFocusRowKey();
        if (focusKey != null) {
            List<Object> focusPath = component.getAllAncestorContainerRowKeys(focusKey);
            focusPath = new ArrayList<Object>(focusPath);
            focusPath.add(focusKey);
            int focusSize = focusPath.size();
            if (focusSize > startDepth) {
                isNewPath = true;
                component.setRowKey(focusPath.get(startDepth));
            } else if (focusSize == startDepth) {
                isNewPath = true;
                component.setRowKey(focusKey);
                component.enterContainer();
            }
        } else if (startDepth == 0) {
            isNewPath = true;
            component.setRowKey(null);
        }
        return isNewPath;
    }

    private HierarchyUtils() {
    }
}

