/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.AvailableTableModel;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.InstalledTableModel;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.LocallDownloadDnD;
import org.netbeans.modules.autoupdate.ui.LocallyDownloadedTableModel;
import org.netbeans.modules.autoupdate.ui.SettingsTab;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitDetails;
import org.netbeans.modules.autoupdate.ui.UnitTab;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.UpdateTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateCheckScheduler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class PluginManagerUI
extends JPanel {
    private List<UpdateUnit> units = Collections.emptyList();
    private UnitTable installedTable;
    private UnitTable availableTable;
    private UnitTable updateTable;
    private UnitTable localTable;
    private JButton closeButton;
    public final RequestProcessor.Task initTask;
    private final Object initLock = new Object();
    private Object helpInstance = null;
    private static volatile RequestProcessor.Task runningTask;
    private static Collection<Runnable> runOnCancel;
    private boolean wasSettings = false;
    public static final int INDEX_OF_UPDATES_TAB = 0;
    public static final int INDEX_OF_AVAILABLE_TAB = 1;
    public static final int INDEX_OF_DOWNLOAD_TAB = 2;
    public static final int INDEX_OF_INSTALLED_TAB = 3;
    public static final int INDEX_OF_SETTINGS_TAB = 4;
    public static final String[] TAB_NAMES;
    private int initialTabToSelect;
    private boolean detailView;
    public static final String DETAIL_VIEW_SELECTED_PROP = "plugin.manager.detail.view.selected";
    private boolean willClose;
    private JButton bClose;
    private JButton bHelp;
    private JPanel pProgress;
    private JTabbedPane tpTabs;

    public PluginManagerUI(JButton closeButton) {
        this(closeButton, null, true);
    }

    public PluginManagerUI(JButton closeButton, Object initialTab) {
        this(closeButton, initialTab, Boolean.getBoolean(DETAIL_VIEW_SELECTED_PROP));
    }

    public PluginManagerUI(JButton closeButton, Object initialTab, boolean detailView) {
        this.detailView = detailView;
        this.closeButton = closeButton;
        this.willClose = false;
        int selIndex = -1;
        for (int i = 0; i < TAB_NAMES.length; ++i) {
            if (!TAB_NAMES[i].equals(initialTab)) continue;
            selIndex = i;
            break;
        }
        if (selIndex < 0 && null != initialTab) {
            throw new IllegalArgumentException("Invalid tab name: " + initialTab);
        }
        this.initialTabToSelect = selIndex;
        this.initComponents();
        this.initTask = Utilities.startAsWorkerThread(new Runnable(){

            @Override
            public void run() {
                PluginManagerUI.this.postInitComponents();
                PluginManagerUI.this.initialize();
            }
        });
    }

    boolean isDetailView() {
        return this.detailView;
    }

    void setDetailView(boolean detailView) {
        this.detailView = detailView;
    }

    private Window findWindowParent() {
        Container c = this;
        while (c != null) {
            if (!((c = c.getParent()) instanceof Window)) continue;
            return (Window)c;
        }
        return null;
    }

    void setWaitingState(boolean waitingState) {
        boolean enabled = !waitingState;
        for (Component c : this.tpTabs.getComponents()) {
            if (!(c instanceof UnitTab)) continue;
            ((UnitTab)c).setWaitingState(waitingState);
        }
        this.bClose.setEnabled(true);
        Container parent = this.getParent();
        JRootPane rootPane = this.getRootPane();
        if (parent != null) {
            parent.setEnabled(enabled);
        }
        if (rootPane != null) {
            if (enabled) {
                rootPane.setCursor(null);
            } else {
                rootPane.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        final Window w = this.findWindowParent();
        if (w != null) {
            w.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    final 2 waa = this;
                    PluginManagerUI.this.setWaitingState(true);
                    Utilities.startAsWorkerThread(PluginManagerUI.this, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PluginManagerUI.this.initTask.waitFinished();
                                w.removeWindowListener(waa);
                            }
                            finally {
                                PluginManagerUI.this.setWaitingState(false);
                            }
                        }
                    }, NbBundle.getMessage(PluginManagerUI.class, "UnitTab_InitAndCheckingForUpdates"), Utilities.getTimeOfInitialization());
                }
            });
        }
        HelpCtx.setHelpIDString(this, PluginManagerUI.class.getName());
        this.tpTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HelpCtx.setHelpIDString(PluginManagerUI.this, PluginManagerUI.this.getHelpCtx().getHelpID());
            }
        });
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.unitilialize();
    }

    public void close() {
        this.bClose.doClick();
    }

    public void willClose() {
        this.willClose = true;
    }

    public boolean isClosing() {
        return this.willClose;
    }

    private void initialize() {
        try {
            List<UpdateUnit> uu = UpdateManager.getDefault().getUpdateUnits(Utilities.getUnitTypes());
            if (this.localTable != null) {
                ArrayList<UpdateUnit> nbms = new ArrayList<UpdateUnit>(((LocallyDownloadedTableModel)this.localTable.getModel()).getLocalDownloadSupport().getUpdateUnits());
                List<UnitCategory> list = Utilities.makeUpdateCategories(nbms, true);
            }
            this.refreshUnitsInBackground(uu);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PluginManagerUI.this.refreshUnitsInAWT();
                    PluginManagerUI.this.setSelectedTab();
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace(ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    private void unitilialize() {
        Utilities.startAsWorkerThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PluginManagerUI.this.initTask.waitFinished();
                AutoupdateCheckScheduler.runCheckAvailableUpdates(0);
                Object object = PluginManagerUI.this.initLock;
                synchronized (object) {
                    PluginManagerUI.this.units = null;
                    PluginManagerUI.this.installedTable = null;
                    PluginManagerUI.this.availableTable = null;
                    PluginManagerUI.this.updateTable = null;
                    PluginManagerUI.this.localTable = null;
                }
            }
        }, 10000);
    }

    void setProgressComponent(final JLabel detail, final JComponent progressComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setProgressComponentInAwt(detail, progressComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginManagerUI.this.setProgressComponentInAwt(detail, progressComponent);
                }
            });
        }
    }

    private UnitTable createTabForModel(final UnitCategoryTableModel model) {
        final UnitTable table = new UnitTable(model);
        this.selectFirstRow(table);
        final UnitTab tab = new UnitTab(table, new UnitDetails(), this);
        if (this.initTask != null) {
            tab.setWaitingState(!this.initTask.isFinished());
            this.initTask.addTaskListener(new TaskListener(){

                @Override
                public void taskFinished(Task task) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            tab.setWaitingState(false);
                        }
                    });
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginManagerUI.this.tpTabs.add((Component)tab, model.getTabIndex());
                PluginManagerUI.this.decorateTabTitle(table);
            }
        });
        return table;
    }

    private void setProgressComponentInAwt(JLabel detail, JComponent progressComponent) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        progressComponent.setMinimumSize(progressComponent.getPreferredSize());
        this.pProgress.setVisible(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.pProgress.add((Component)progressComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pProgress.add((Component)detail, gridBagConstraints);
        this.revalidate();
    }

    void unsetProgressComponent(final JLabel detail, final JComponent progressComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.unsetProgressComponentInAwt(detail, progressComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginManagerUI.this.unsetProgressComponentInAwt(detail, progressComponent);
                }
            });
        }
    }

    private void setSelectedTab() {
        UnitTab unitTab;
        Component c;
        if (this.initialTabToSelect >= 0 && this.initialTabToSelect != this.tpTabs.getSelectedIndex() && this.initialTabToSelect < this.tpTabs.getComponentCount() && (c = this.tpTabs.getComponentAt(this.initialTabToSelect)) instanceof UnitTab && (unitTab = (UnitTab)c).getModel().isTabEnabled() && unitTab.getModel().canBePrimaryTab()) {
            this.tpTabs.setSelectedIndex(this.initialTabToSelect);
            this.initialTabToSelect = -1;
            return;
        }
        this.initialTabToSelect = -1;
        Component component = this.tpTabs.getSelectedComponent();
        if (component instanceof UnitTab && !(unitTab = (UnitTab)component).getModel().isTabEnabled()) {
            for (int i = 0; i < this.tpTabs.getComponentCount(); ++i) {
                component = this.tpTabs.getComponentAt(i);
                if (component instanceof UnitTab) {
                    unitTab = (UnitTab)component;
                    if (!unitTab.getModel().isTabEnabled() || !unitTab.getModel().canBePrimaryTab()) continue;
                    this.tpTabs.setSelectedIndex(i);
                    break;
                }
                this.tpTabs.setSelectedIndex(i);
                break;
            }
        }
    }

    private void unsetProgressComponentInAwt(JLabel detail, JComponent progressComponent) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        this.pProgress.remove(detail);
        this.pProgress.remove(progressComponent);
        this.pProgress.setVisible(false);
        this.revalidate();
    }

    private void initComponents() {
        this.tpTabs = new JTabbedPane();
        this.pProgress = new JPanel();
        this.bClose = this.closeButton;
        this.bHelp = new JButton();
        this.tpTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PluginManagerUI.this.tpTabsStateChanged(evt);
            }
        });
        this.pProgress.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText(this.bClose, NbBundle.getMessage(PluginManagerUI.class, "UnitTab_bClose_Text"));
        Mnemonics.setLocalizedText(this.bHelp, NbBundle.getMessage(PluginManagerUI.class, "PluginManagerUI.bHelp.text"));
        this.bHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginManagerUI.this.bHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pProgress, -2, 562, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 157, Short.MAX_VALUE).addComponent(this.bClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bHelp)).addComponent(this.tpTabs, -1, 864, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tpTabs, -1, 471, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pProgress, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bHelp).addComponent(this.bClose, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.tpTabs.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginManagerUI.class, "ACN_Tabs"));
        this.tpTabs.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginManagerUI.class, "ACD_Tabs"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginManagerUI.class, "ACN_PluginManagerUI"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginManagerUI.class, "ACD_PluginManagerUI"));
    }

    private void tpTabsStateChanged(ChangeEvent evt) {
        Component component = ((JTabbedPane)evt.getSource()).getSelectedComponent();
        if (component instanceof SettingsTab) {
            int i = ((SettingsTab)component).getSelectedRow();
            ((SettingsTab)component).getSettingsTableModel().refreshModel();
            if (i > -1) {
                ((SettingsTab)component).setSelectedRow(i);
            }
            this.wasSettings = true;
        } else {
            if (this.wasSettings) {
                final UnitCategoryTableModel availableModel = (UnitCategoryTableModel)this.availableTable.getModel();
                final Map<String, Boolean> availableState = UnitCategoryTableModel.captureState(availableModel.getUnits());
                ((SettingsTab)this.tpTabs.getComponentAt(4)).doLazyRefresh(new Runnable(){

                    @Override
                    public void run() {
                        UnitCategoryTableModel.restoreState(availableModel.getUnits(), availableState, false);
                    }
                });
            }
            this.wasSettings = false;
        }
    }

    private void bHelpActionPerformed(ActionEvent evt) {
        this.getHelpCtx().display();
    }

    private HelpCtx getHelpCtx() {
        String id = PluginManagerUI.class.getName();
        Component c = this.tpTabs.getSelectedComponent();
        if (c instanceof UnitTab) {
            id = ((UnitTab)c).getHelpId();
        } else if (c instanceof SettingsTab) {
            id = SettingsTab.class.getName();
        }
        return new HelpCtx(id);
    }

    private void postInitComponents() {
        Containers.initNotify();
        this.updateTable = this.createTabForModel(new UpdateTableModel(this.units));
        this.availableTable = this.createTabForModel(new AvailableTableModel(this.units));
        LocalDownloadSupport localDownloadSupport = new LocalDownloadSupport();
        LocallyDownloadedTableModel localTM = new LocallyDownloadedTableModel(localDownloadSupport);
        this.localTable = this.createTabForModel(localTM);
        this.installedTable = this.createTabForModel(new InstalledTableModel(this.units));
        LocallDownloadDnD l = new LocallDownloadDnD(localDownloadSupport, localTM, this);
        DropTarget dt = new DropTarget(null, l);
        dt.setActive(true);
        this.setDropTarget(dt);
        final SettingsTab tab = new SettingsTab(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginManagerUI.this.tpTabs.add((Component)tab, 4);
                PluginManagerUI.this.tpTabs.setTitleAt(4, tab.getDisplayName());
            }
        });
        this.setWaitingState(true);
    }

    void decorateTabTitle(UnitTable table) {
        if (table == null) {
            return;
        }
        UnitCategoryTableModel model = (UnitCategoryTableModel)table.getModel();
        int index = model.getTabIndex();
        this.tpTabs.setTitleAt(index, model.getDecoratedTabTitle());
        this.tpTabs.setEnabledAt(index, model.isTabEnabled());
        this.tpTabs.setToolTipTextAt(index, model.getTabTooltipText());
    }

    void undecorateTabTitles() {
        this.tpTabs.setTitleAt(0, NbBundle.getMessage(PluginManagerUI.class, "PluginManagerUI_UnitTab_Update_Title"));
        this.tpTabs.setTitleAt(1, NbBundle.getMessage(PluginManagerUI.class, "PluginManagerUI_UnitTab_Available_Title"));
    }

    private int findRowWithFirstUnit(UnitCategoryTableModel model) {
        for (int row = 0; row <= model.getRowCount(); ++row) {
            if (model.getUnitAtRow(row) == null) continue;
            return row;
        }
        return -1;
    }

    private void selectFirstRow(UnitTable table) {
        UnitCategoryTableModel model;
        int row;
        if (table != null && table.getSelectedRow() == -1 && (row = this.findRowWithFirstUnit(model = (UnitCategoryTableModel)table.getModel())) != -1) {
            table.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshUnitsInBackground(List<UpdateUnit> newUnits) {
        Object object = this.initLock;
        synchronized (object) {
            if (this.units == null) {
                return;
            }
            this.units = newUnits;
            InstalledTableModel installTableModel = (InstalledTableModel)this.installedTable.getModel();
            UnitCategoryTableModel updateTableModel = (UnitCategoryTableModel)this.updateTable.getModel();
            UnitCategoryTableModel availableTableModel = (UnitCategoryTableModel)this.availableTable.getModel();
            LocallyDownloadedTableModel localTableModel = (LocallyDownloadedTableModel)this.localTable.getModel();
            updateTableModel.setUnits(UpdateManager.getDefault().getUpdateUnits(UpdateManager.TYPE.MODULE));
            List<UpdateUnit> features = UpdateManager.getDefault().getUpdateUnits(UpdateManager.TYPE.FEATURE);
            if (this.isDetailView() && !features.isEmpty()) {
                installTableModel.setUnits(this.units);
            } else {
                installTableModel.setUnits(this.units, features);
            }
            availableTableModel.setUnits(this.units);
            localTableModel.setUnits(this.units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshUnitsInAWT() {
        assert (SwingUtilities.isEventDispatchThread()) : "Call from AWT only";
        Object object = this.initLock;
        synchronized (object) {
            Component[] components;
            this.selectFirstRow(this.installedTable);
            this.selectFirstRow(this.updateTable);
            this.selectFirstRow(this.availableTable);
            this.selectFirstRow(this.localTable);
            this.decorateTabTitle(this.updateTable);
            this.decorateTabTitle(this.availableTable);
            this.decorateTabTitle(this.localTable);
            this.decorateTabTitle(this.installedTable);
            for (Component component : components = this.tpTabs.getComponents()) {
                if (!(component instanceof UnitTab)) continue;
                UnitTab tab = (UnitTab)component;
                tab.refreshState();
            }
            this.setSelectedTab();
        }
    }

    static boolean canContinue(String message) {
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify(new NotifyDescriptor.Confirmation(message)));
    }

    public static void registerRunningTask(RequestProcessor.Task it) {
        assert (runningTask == null || runningTask.isFinished()) : "Only once task can be running. Already running : " + runningTask;
        runningTask = it;
    }

    public static void unregisterRunningTask() {
        runningTask = null;
        runOnCancel = null;
    }

    public static RequestProcessor.Task getRunningTask(Runnable onCancel) {
        if (runningTask != null) {
            if (runOnCancel == null) {
                runOnCancel = new HashSet<Runnable>();
            }
            runOnCancel.add(onCancel);
        }
        return runningTask;
    }

    public static RequestProcessor.Task getRunningTask() {
        return runningTask;
    }

    public static void cancelRunningTask() {
        if (runningTask != null && runOnCancel != null) {
            runningTask = null;
            for (Runnable run : runOnCancel) {
                run.run();
            }
            runOnCancel = null;
        } else {
            runningTask = null;
        }
    }

    public void updateUnitsChanged() {
        this.refreshUnitsInBackground(UpdateManager.getDefault().getUpdateUnits(Utilities.getUnitTypes()));
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginManagerUI.this.refreshUnitsInAWT();
                }
            });
        } else {
            this.refreshUnitsInAWT();
        }
    }

    public void tableStructureChanged() {
        this.installedTable.resortByDefault();
        ((UnitCategoryTableModel)this.installedTable.getModel()).fireTableStructureChanged();
        this.installedTable.setColumnsSize();
        this.installedTable.resetEnableRenderer();
        this.updateTable.resortByDefault();
        ((UnitCategoryTableModel)this.updateTable.getModel()).fireTableStructureChanged();
        this.updateTable.setColumnsSize();
        this.availableTable.resortByDefault();
        ((UnitCategoryTableModel)this.availableTable.getModel()).fireTableStructureChanged();
        this.availableTable.setColumnsSize();
    }

    public void buttonsChanged() {
        Component c = this.tpTabs.getSelectedComponent();
        if (c instanceof UnitTab) {
            ((UnitTab)c).refreshState();
        }
    }

    final void setSelectedTab(UnitTab tab) {
        this.tpTabs.setSelectedComponent(tab);
    }

    final UnitTab findTabForModel(UnitCategoryTableModel model) {
        for (Component c : this.tpTabs.getComponents()) {
            UnitTab ut;
            if (!(c instanceof UnitTab) || (ut = (UnitTab)c).getModel() != model) continue;
            return ut;
        }
        return null;
    }

    final String getSelectedTabName() {
        int index = this.initialTabToSelect;
        if (index == -1) {
            index = this.tpTabs.getSelectedIndex();
        }
        return TAB_NAMES[index];
    }

    static {
        runOnCancel = null;
        TAB_NAMES = new String[]{"update", "available", "local", "installed"};
    }
}

