/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.TreeUtils;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class SizeEqualsZero {
    static final boolean CHECK_NOT_EQUALS_DEFAULT = true;
    public static final String CHECK_NOT_EQUALS = "check.not.equals";

    public static ErrorDescription sizeEqualsZero(HintContext ctx) {
        return SizeEqualsZero.sizeEqualsZeroHint(ctx, "SizeEqualsZero", "$subj.isEmpty()");
    }

    public static ErrorDescription sizeNotEqualsZero(HintContext ctx) {
        if (!ctx.getPreferences().getBoolean(CHECK_NOT_EQUALS, true)) {
            return null;
        }
        return SizeEqualsZero.sizeEqualsZeroHint(ctx, "SizeEqualsZeroNeg", "!$subj.isEmpty()");
    }

    public static ErrorDescription sizeGreaterZero(HintContext ctx) {
        if (!ctx.getPreferences().getBoolean(CHECK_NOT_EQUALS, true)) {
            return null;
        }
        return SizeEqualsZero.sizeEqualsZeroHint(ctx, "SizeGreaterZeroNeg", "!$subj.isEmpty()");
    }

    public static ErrorDescription sizeEqualsZeroHint(HintContext ctx, String keyPostfix, String to) {
        Element enclMethodEl;
        TypeMirror subjType;
        TreePath subj = ctx.getVariables().get("$subj");
        if (subj == null) {
            subj = TreeUtils.findClass(ctx.getPath());
        }
        if ((subjType = ctx.getInfo().getTrees().getTypeMirror(subj)) == null || subjType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        Element el = ((DeclaredType)subjType).asElement();
        if (el == null || !el.getKind().isClass() && !el.getKind().isInterface()) {
            return null;
        }
        ExecutableElement isEmptyFound = null;
        for (ExecutableElement method : ElementFilter.methodsIn(ctx.getInfo().getElementUtilities().getMembers(subjType, null))) {
            if (!method.getSimpleName().contentEquals("isEmpty") || !method.getParameters().isEmpty() || !method.getTypeParameters().isEmpty()) continue;
            isEmptyFound = method;
            break;
        }
        if (isEmptyFound == null) {
            return null;
        }
        TreePath enclMethod = Utilities.findOwningExecutable(ctx, ctx.getPath(), false);
        if (enclMethod != null && (enclMethodEl = ctx.getInfo().getTrees().getElement(enclMethod)) == isEmptyFound) {
            return null;
        }
        String subjName = subj.getLeaf().toString();
        String fixDisplayName = NbBundle.getMessage(SizeEqualsZero.class, "FIX_" + keyPostfix, subjName);
        String errDisplayName = NbBundle.getMessage(SizeEqualsZero.class, "ERR_" + keyPostfix, subjName);
        Fix fix = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, ctx.getPath(), to);
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), errDisplayName, fix);
    }
}

