/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class GoToSettings {
    private static final String NODE_HIGHLIGHTING = "highlighting";
    private static final String NODE_SORTING = "sorting";
    private static final String KEY_HIGHLIGHTING_MODE = "mode";
    private static final String KEY_HIGHLIGHTING_TYPE = "type";
    private static final String KEY_SORTING_TYPE = "type";
    private static final String KEY_SORTING_PRJ = "preffer-projects";
    private static final GoToSettings INSTANCE = new GoToSettings();

    private GoToSettings() {
    }

    @NonNull
    public HighlightingMode getHighlightingMode() {
        return HighlightingMode.forSystemName(this.getHighlightingNode().get(KEY_HIGHLIGHTING_MODE, null));
    }

    void setHighlightingMode(@NonNull HighlightingMode mode) {
        assert (mode != null);
        this.getHighlightingNode().put(KEY_HIGHLIGHTING_MODE, mode.getSystemName());
    }

    @NonNull
    public HighlightingType getHighlightingType() {
        return HighlightingType.forSystemName(this.getHighlightingNode().get("type", null));
    }

    void setHighlightingType(@NonNull HighlightingType type) {
        assert (type != null);
        this.getHighlightingNode().put("type", type.getSystemName());
    }

    @NonNull
    public SortingType getSortingType() {
        return SortingType.forSystemName(this.getSortingNode().get("type", null));
    }

    void setSortingType(@NonNull SortingType type) {
        assert (type != null);
        this.getSortingNode().put("type", type.getSystemName());
    }

    public boolean isSortingPreferOpenProjects() {
        return this.getSortingNode().getBoolean(KEY_SORTING_PRJ, true);
    }

    public void setSortingPreferOpenProjects(boolean value) {
        this.getSortingNode().putBoolean(KEY_SORTING_PRJ, value);
    }

    @NonNull
    private Preferences getHighlightingNode() {
        Preferences prefs = NbPreferences.forModule(GoToSettings.class);
        return prefs.node(NODE_HIGHLIGHTING);
    }

    @NonNull
    private Preferences getSortingNode() {
        Preferences prefs = NbPreferences.forModule(GoToSettings.class);
        return prefs.node(NODE_SORTING);
    }

    @NonNull
    public static GoToSettings getDefault() {
        return INSTANCE;
    }

    public static final class SortingType
    extends Enum<SortingType> {
        public static final /* enum */ SortingType LEXICOGRAPHIC = new SortingType("lexicographic", NbBundle.getMessage(GoToSettings.class, "NAME_LEXICOGRAPHIC"));
        public static final /* enum */ SortingType LEVENSHTEIN = new SortingType("levenshtein", NbBundle.getMessage(GoToSettings.class, "NAME_LEVENSHTEIN"));
        private static final Map<String, SortingType> typesBySystemName;
        private final String systemName;
        private final String displayName;
        private static final /* synthetic */ SortingType[] $VALUES;

        public static SortingType[] values() {
            return (SortingType[])$VALUES.clone();
        }

        public static SortingType valueOf(String name) {
            return Enum.valueOf(SortingType.class, name);
        }

        private SortingType(String systemName, String displayName) {
            assert (systemName != null);
            assert (displayName != null);
            this.systemName = systemName;
            this.displayName = displayName;
        }

        @NonNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NonNull
        String getSystemName() {
            return this.systemName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        @NonNull
        static SortingType forSystemName(@NullAllowed String systemName) {
            SortingType type = typesBySystemName.get(systemName);
            if (type == null) {
                type = SortingType.getDefault();
            }
            return type;
        }

        @NonNull
        private static SortingType getDefault() {
            return LEXICOGRAPHIC;
        }

        static {
            $VALUES = new SortingType[]{LEXICOGRAPHIC, LEVENSHTEIN};
            HashMap<String, SortingType> map = new HashMap<String, SortingType>();
            for (SortingType t : SortingType.values()) {
                map.put(t.getSystemName(), t);
            }
            typesBySystemName = Collections.unmodifiableMap(map);
        }
    }

    public static final class HighlightingType
    extends Enum<HighlightingType> {
        public static final /* enum */ HighlightingType BOLD = new HighlightingType("bold", NbBundle.getMessage(GoToSettings.class, "NAME_BOLD"));
        public static final /* enum */ HighlightingType BACKGROUND = new HighlightingType("background", NbBundle.getMessage(GoToSettings.class, "NAME_BACKGROUND"));
        private static final Map<String, HighlightingType> typesBySystemName;
        private final String systemName;
        private final String displayName;
        private static final /* synthetic */ HighlightingType[] $VALUES;

        public static HighlightingType[] values() {
            return (HighlightingType[])$VALUES.clone();
        }

        public static HighlightingType valueOf(String name) {
            return Enum.valueOf(HighlightingType.class, name);
        }

        private HighlightingType(String systemName, String displayName) {
            assert (systemName != null);
            assert (displayName != null);
            this.systemName = systemName;
            this.displayName = displayName;
        }

        @NonNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NonNull
        String getSystemName() {
            return this.systemName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        @NonNull
        static HighlightingType forSystemName(@NullAllowed String systemName) {
            HighlightingType type = typesBySystemName.get(systemName);
            if (type == null) {
                type = HighlightingType.getDefault();
            }
            return type;
        }

        @NonNull
        private static HighlightingType getDefault() {
            return BACKGROUND;
        }

        static {
            $VALUES = new HighlightingType[]{BOLD, BACKGROUND};
            HashMap<String, HighlightingType> map = new HashMap<String, HighlightingType>();
            for (HighlightingType t : HighlightingType.values()) {
                map.put(t.getSystemName(), t);
            }
            typesBySystemName = Collections.unmodifiableMap(map);
        }
    }

    public static final class HighlightingMode
    extends Enum<HighlightingMode> {
        public static final /* enum */ HighlightingMode NONE = new HighlightingMode("none", NbBundle.getMessage(GoToSettings.class, "NAME_NONE"));
        public static final /* enum */ HighlightingMode ACTIVE = new HighlightingMode("active", NbBundle.getMessage(GoToSettings.class, "NAME_ACTIVE"));
        public static final /* enum */ HighlightingMode ALL = new HighlightingMode("all", NbBundle.getMessage(GoToSettings.class, "NAME_ALL"));
        private static final Map<String, HighlightingMode> modesBySystemName;
        private final String systemName;
        private final String displayName;
        private static final /* synthetic */ HighlightingMode[] $VALUES;

        public static HighlightingMode[] values() {
            return (HighlightingMode[])$VALUES.clone();
        }

        public static HighlightingMode valueOf(String name) {
            return Enum.valueOf(HighlightingMode.class, name);
        }

        private HighlightingMode(String systemName, String displayName) {
            assert (systemName != null);
            assert (displayName != null);
            this.systemName = systemName;
            this.displayName = displayName;
        }

        @NonNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NonNull
        String getSystemName() {
            return this.systemName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        @NonNull
        static HighlightingMode forSystemName(@NullAllowed String sysName) {
            HighlightingMode m = modesBySystemName.get(sysName);
            if (m == null) {
                m = HighlightingMode.getDefault();
            }
            return m;
        }

        @NonNull
        private static HighlightingMode getDefault() {
            return ACTIVE;
        }

        static {
            $VALUES = new HighlightingMode[]{NONE, ACTIVE, ALL};
            HashMap<String, HighlightingMode> map = new HashMap<String, HighlightingMode>();
            for (HighlightingMode m : HighlightingMode.values()) {
                map.put(m.getSystemName(), m);
            }
            modesBySystemName = Collections.unmodifiableMap(map);
        }
    }
}

