/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionInvoker;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public abstract class CallableSystemAction
extends SystemAction
implements Presenter.Menu,
Presenter.Popup,
Presenter.Toolbar {
    static final long serialVersionUID = 2339794599168944156L;
    private static final Set<Class> warnedAsynchronousActions = new WeakSet<Class>();
    private static final boolean DEFAULT_ASYNCH = !Boolean.getBoolean("org.openide.util.actions.CallableSystemAction.synchronousByDefault");

    @Override
    public JMenuItem getMenuPresenter() {
        return ActionPresenterProvider.getDefault().createMenuPresenter(this);
    }

    @Override
    public JMenuItem getPopupPresenter() {
        return ActionPresenterProvider.getDefault().createPopupPresenter(this);
    }

    @Override
    public Component getToolbarPresenter() {
        return ActionPresenterProvider.getDefault().createToolbarPresenter(this);
    }

    public abstract void performAction();

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.isEnabled()) {
            ActionInvoker.invokeAction(this, ev, this.asynchronous(), new Runnable(){

                @Override
                public void run() {
                    CallableSystemAction.this.performAction();
                }
            });
        } else {
            Utilities.disabledActionBeep();
        }
    }

    protected boolean asynchronous() {
        if (warnedAsynchronousActions.add(this.getClass())) {
            Logger.getLogger(CallableSystemAction.class.getName()).warning("Warning - " + this.getClass().getName() + " should override CallableSystemAction.asynchronous() to return false");
        }
        return DEFAULT_ASYNCH;
    }
}

