/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jackpot30.cmdline.ant;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class JackpotTask
extends Task {
    private String jackpotHome;
    private Path src;
    private String sourcepath;
    private String sourcelevel;
    private Path classpath;
    private String configFile;

    public void setJackpotHome(String jackpotHome) {
        this.jackpotHome = jackpotHome;
    }

    public Path createSrc() {
        this.src = new Path(this.getProject());
        return this.src;
    }

    public void setSourcepath(String sourcepath) {
        this.sourcepath = sourcepath;
    }

    public void setSource(String sourcelevel) {
        this.sourcelevel = sourcelevel;
    }

    public Path createClasspath() {
        this.classpath = new Path(this.getProject());
        return this.classpath;
    }

    public Path getClasspath() {
        return this.classpath != null ? this.classpath : this.createClasspath();
    }

    public void setConfigfile(String file) {
        this.configFile = file;
    }

    public void execute() throws BuildException {
        try {
            CommandlineJava cmdLine = new CommandlineJava();
            if (this.jackpotHome == null) {
                throw new BuildException("Must specify jackpotHome");
            }
            Path srcPath = this.src;
            if (srcPath == null) {
                if (this.sourcepath == null) {
                    throw new BuildException("Must specify either src subelement or sourcepath");
                }
                srcPath = new Path(this.getProject(), this.sourcepath);
            }
            cmdLine.createClasspath(this.getProject()).add(new Path(this.getProject(), this.jackpotHome + "/jackpot.jar"));
            cmdLine.setClassname("org.netbeans.modules.jackpot30.cmdline.Main");
            JackpotTask.addArguments(cmdLine, "-no-apply");
            JackpotTask.addArguments(cmdLine, "-sourcepath", srcPath.toString());
            JackpotTask.addArguments(cmdLine, "-classpath", this.getClasspath().toString());
            if (this.sourcelevel != null) {
                JackpotTask.addArguments(cmdLine, "--source", this.sourcelevel);
            }
            if (this.configFile != null) {
                JackpotTask.addArguments(cmdLine, "--config-file", this.configFile);
            }
            JackpotTask.addArguments(cmdLine, srcPath.list());
            Execute exec = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
            exec.setCommandline(cmdLine.getCommandline());
            exec.execute();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private static void addArguments(CommandlineJava cmdLine, String ... args) {
        for (String arg : args) {
            cmdLine.createArgument().setValue(arg);
        }
    }
}

