/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public final class OSUtils {
    public static Long getProcessId(Process process, Logger logger) {
        Long pid = null;
        try {
            Method pidMethod = Process.class.getDeclaredMethod("pid", new Class[0]);
            Object pidNumber = pidMethod.invoke((Object)process, new Object[0]);
            if (pidNumber instanceof Long) {
                pid = (Long)pidNumber;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String processClassName = process.getClass().getName();
            if (processClassName.equals("java.lang.UNIXProcess")) {
                pid = OSUtils.getUnixPid(process, logger);
            }
            logger.info("Failed to determine Process ID from [{}]: {}", (Object)processClassName, (Object)e.getMessage());
        }
        return pid;
    }

    static int parseJavaVersion(String version) {
        String majorVersion;
        if (version.startsWith("1.")) {
            majorVersion = version.substring(2, 3);
        } else {
            Pattern majorVersion9PlusPattern = Pattern.compile("(\\d+).*");
            Matcher m = majorVersion9PlusPattern.matcher(version);
            if (m.find()) {
                majorVersion = m.group(1);
            } else {
                throw new IllegalArgumentException("Could not detect major version of " + version);
            }
        }
        return Integer.parseInt(majorVersion);
    }

    private static Long getUnixPid(Process process, Logger logger) {
        try {
            Class<?> procClass = process.getClass();
            Field pidField = procClass.getDeclaredField("pid");
            pidField.setAccessible(true);
            Object pidObject = pidField.get(process);
            if (pidObject instanceof Number) {
                return ((Number)pidObject).longValue();
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.debug("Could not find Unix PID", (Throwable)e);
            return null;
        }
    }
}

