/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.deprecation.log;

import java.util.Arrays;
import java.util.Objects;
import org.apache.nifi.deprecation.log.DeprecationException;
import org.apache.nifi.deprecation.log.DeprecationLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandardDeprecationLogger
implements DeprecationLogger {
    private static final String LOGGER_NAME_FORMAT = "deprecation.%s";
    private final Class<?> referenceClass;
    private final Logger logger;

    StandardDeprecationLogger(Class<?> referenceClass) {
        this.referenceClass = Objects.requireNonNull(referenceClass, "Reference Class required");
        this.logger = LoggerFactory.getLogger((String)String.format(LOGGER_NAME_FORMAT, referenceClass.getName()));
    }

    @Override
    public void warn(String message, Object ... arguments) {
        Objects.requireNonNull(message, "Message required");
        Object[] extendedArguments = this.getExtendedArguments(arguments);
        this.logger.warn(message, extendedArguments);
    }

    private Object[] getExtendedArguments(Object ... arguments) {
        Object[] messageArguments = arguments == null ? new Object[]{} : arguments;
        int messageArgumentsLength = messageArguments.length;
        Object[] extendedArguments = Arrays.copyOf(messageArguments, messageArgumentsLength + 1);
        extendedArguments[messageArgumentsLength] = new DeprecationException(this.referenceClass);
        return extendedArguments;
    }
}

