/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.ProvenanceEventEnricher;
import org.apache.nifi.controller.repository.claim.ContentClaimWriteCache;
import org.apache.nifi.controller.repository.metrics.PerformanceTracker;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.InternalProvenanceReporter;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRepository;

public interface RepositoryContext {
    public Connectable getConnectable();

    public Collection<Connection> getConnections(Relationship var1);

    public List<Connection> getPollableConnections();

    public ContentRepository getContentRepository();

    public FlowFileRepository getFlowFileRepository();

    public FlowFileEventRepository getFlowFileEventRepository();

    public ProvenanceEventRepository getProvenanceRepository();

    public boolean isRelationshipAvailabilitySatisfied(int var1);

    public ContentClaimWriteCache createContentClaimWriteCache(PerformanceTracker var1);

    public InternalProvenanceReporter createProvenanceReporter(Predicate<FlowFile> var1, ProvenanceEventEnricher var2);

    public String getConnectableDescription();

    public int getNextIncomingConnectionIndex();

    public long getNextFlowFileSequence();

    public void adjustCounter(String var1, long var2);

    public ProvenanceEventBuilder createProvenanceEventBuilder();

    public StateManager getStateManager();
}

