/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.minifi.commons.schema.ConnectionSchema;
import org.apache.nifi.minifi.commons.schema.common.CollectionUtil;

public class NiFiRegConnectionSchemaFunction
implements Function<VersionedConnection, ConnectionSchema> {
    @Override
    public ConnectionSchema apply(VersionedConnection versionedConnection) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", versionedConnection.getIdentifier());
        map.put("name", versionedConnection.getName());
        map.put("source id", versionedConnection.getSource().getId());
        Set selectedRelationships = CollectionUtil.nullToEmpty((Set)versionedConnection.getSelectedRelationships());
        map.put("source relationship names", selectedRelationships.stream().sorted().collect(Collectors.toList()));
        map.put("destination id", versionedConnection.getDestination().getId());
        map.put("max work queue size", versionedConnection.getBackPressureObjectThreshold());
        map.put("max work queue data size", versionedConnection.getBackPressureDataSizeThreshold());
        map.put("flowfile expiration", versionedConnection.getFlowFileExpiration());
        List queuePrioritizers = CollectionUtil.nullToEmpty((List)versionedConnection.getPrioritizers());
        if (queuePrioritizers.size() > 0) {
            map.put("queue prioritizer class", queuePrioritizers.get(0));
        }
        ConnectionSchema connectionSchema = new ConnectionSchema(map);
        if (ConnectableType.FUNNEL.name().equals(versionedConnection.getSource().getType())) {
            connectionSchema.addValidationIssue("Connection " + versionedConnection.getName() + " has type " + ConnectableType.FUNNEL.name() + " which is not supported by MiNiFi");
        }
        if (queuePrioritizers.size() > 1) {
            connectionSchema.addValidationIssue("queue prioritizer class", "Connections", " has more than one queue prioritizer");
        }
        return connectionSchema;
    }
}

