/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.File;
import java.util.Iterator;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.backup.VirtualFileDescriptor;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.FileSystemBlobVault;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.log.LogUtil;
import org.jetbrains.annotations.NotNull;

public class PersistentEntityStoreBackupStrategy
extends BackupStrategy {
    private final PersistentStoreTransaction backupTxn;
    private final BackupStrategy environmentBackupStrategy;
    private final BackupStrategy blobVaultBackupStrategy;

    public PersistentEntityStoreBackupStrategy(@NotNull PersistentEntityStoreImpl store) {
        this.backupTxn = store.beginReadonlyTransaction();
        final long logHighAddress = this.backupTxn.getEnvironmentTransaction().getHighAddress();
        this.environmentBackupStrategy = new BackupStrategyDecorator(store.getEnvironment().getBackupStrategy()){

            @Override
            public long acceptFile(@NotNull VirtualFileDescriptor file) {
                return Math.min(super.acceptFile(file), logHighAddress - LogUtil.getAddress((String)file.getName()));
            }
        };
        BlobVault blobVault = store.getBlobVault().getSourceVault();
        if (!(blobVault instanceof FileSystemBlobVault)) {
            this.blobVaultBackupStrategy = blobVault.getBackupStrategy();
        } else {
            final FileSystemBlobVault fsBlobVault = (FileSystemBlobVault)blobVault;
            final long lastUsedHandle = store.getSequence(this.backupTxn, "blob.handles.sequence").loadValue(this.backupTxn);
            this.blobVaultBackupStrategy = new BackupStrategyDecorator(blobVault.getBackupStrategy()){

                @Override
                public long acceptFile(@NotNull VirtualFileDescriptor file) {
                    block5: {
                        block4: {
                            if (!file.hasContent()) break block4;
                            if (!file.getName().equals("version")) break block5;
                        }
                        return super.acceptFile(file);
                    }
                    File f = file.getFile();
                    if (f != null && fsBlobVault.getBlobHandleByFile(f) > lastUsedHandle) {
                        return -1L;
                    }
                    return super.acceptFile(file);
                }
            };
        }
    }

    public void beforeBackup() throws Exception {
        this.environmentBackupStrategy.beforeBackup();
        this.blobVaultBackupStrategy.beforeBackup();
    }

    public Iterable<VirtualFileDescriptor> getContents() {
        return () -> new Iterator<VirtualFileDescriptor>(){
            private boolean environmentListed;
            private Iterator filesIterator;
            {
                this.filesIterator = PersistentEntityStoreBackupStrategy.this.environmentBackupStrategy.getContents().iterator();
                this.environmentListed = false;
            }

            @Override
            public boolean hasNext() {
                while (!this.filesIterator.hasNext()) {
                    if (this.environmentListed) {
                        return false;
                    }
                    this.environmentListed = true;
                    this.filesIterator = PersistentEntityStoreBackupStrategy.this.blobVaultBackupStrategy.getContents().iterator();
                }
                return true;
            }

            @Override
            public VirtualFileDescriptor next() {
                return (VirtualFileDescriptor)this.filesIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void afterBackup() throws Exception {
        try {
            this.blobVaultBackupStrategy.afterBackup();
            this.environmentBackupStrategy.afterBackup();
        }
        finally {
            this.backupTxn.abort();
        }
    }

    public long acceptFile(@NotNull VirtualFileDescriptor file) {
        return LogUtil.isLogFileName((String)file.getName()) ? this.environmentBackupStrategy.acceptFile(file) : this.blobVaultBackupStrategy.acceptFile(file);
    }

    private static class BackupStrategyDecorator
    extends BackupStrategy {
        @NotNull
        private final BackupStrategy decorated;

        public BackupStrategyDecorator(@NotNull BackupStrategy decorated) {
            this.decorated = decorated;
        }

        public void beforeBackup() throws Exception {
            this.decorated.beforeBackup();
        }

        public Iterable<VirtualFileDescriptor> getContents() {
            return this.decorated.getContents();
        }

        public void afterBackup() throws Exception {
            this.decorated.afterBackup();
        }

        public void onError(Throwable t) {
            this.decorated.onError(t);
        }

        public long acceptFile(@NotNull VirtualFileDescriptor file) {
            return this.decorated.acceptFile(file);
        }
    }
}

