/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractIntervalDataFrameCursor;
import io.questdb.cairo.BinarySearch;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;

public class IntervalBwdDataFrameCursor
extends AbstractIntervalDataFrameCursor {
    private static final Log LOG = LogFactory.getLog(IntervalBwdDataFrameCursor.class);

    public IntervalBwdDataFrameCursor(RuntimeIntrinsicIntervalModel intervals, int timestampIndex) {
        super(intervals, timestampIndex);
    }

    @Override
    public DataFrame next() {
        while (this.intervalsLo < this.intervalsHi && this.partitionLo < this.partitionHi) {
            int currentInterval = this.intervalsHi - 1;
            int currentPartition = this.partitionHi - 1;
            long rowCount = this.reader.openPartition(currentPartition);
            if (rowCount > 0L) {
                MemoryR column = this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.reader.getColumnBase(currentPartition), this.timestampIndex));
                long intervalLo = this.intervals.getQuick(currentInterval * 2);
                long intervalHi = this.intervals.getQuick(currentInterval * 2 + 1);
                long limitHi = this.partitionLimit == -1L ? rowCount - 1L : this.partitionLimit - 1L;
                long partitionTimestampLo = column.getLong(0L);
                LOG.debug().$("next [partition=").$(currentPartition).$(", intervalLo=").microTime(intervalLo).$(", intervalHi=").microTime(intervalHi).$(", partitionLo=").microTime(partitionTimestampLo).$(", limitHi=").$(limitHi).$(", rowCount=").$(rowCount).$(", currentInterval=").$(currentInterval).$(']').$();
                if (partitionTimestampLo > intervalHi) {
                    this.skipPartition(currentPartition);
                    continue;
                }
                long partitionTimestampHi = column.getLong(limitHi * 8L);
                if (partitionTimestampHi < intervalLo) {
                    this.skipInterval(currentInterval, limitHi + 1L);
                    continue;
                }
                long lo = partitionTimestampLo < intervalLo ? BinarySearch.find(column, intervalLo - 1L, 0L, limitHi, 1) + 1L : 0L;
                long hi = partitionTimestampHi > intervalHi ? BinarySearch.find(column, intervalHi, lo, limitHi, 1) + 1L : limitHi + 1L;
                if (lo == 0L) {
                    this.skipPartition(currentPartition);
                } else {
                    this.skipInterval(currentInterval, lo);
                }
                if (lo >= hi) continue;
                this.dataFrame.partitionIndex = currentPartition;
                this.dataFrame.rowLo = lo;
                this.dataFrame.rowHi = hi;
                this.sizeSoFar += hi - lo;
                return this.dataFrame;
            }
            this.partitionLimit = -1L;
            this.partitionHi = currentPartition;
        }
        return null;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.partitionLimit = -1L;
    }

    private void skipInterval(int intervalIndex, long limit) {
        LOG.debug().$("next skips interval [partitionLimit=").$(limit).$(", intervalsHi=").$(intervalIndex).$(']').$();
        this.partitionLimit = limit;
        this.intervalsHi = intervalIndex;
    }

    private void skipPartition(int currentPartition) {
        LOG.debug().$("next skips partition").$();
        this.partitionHi = currentPartition;
        this.partitionLimit = -1L;
    }
}

