/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionByte;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionInt;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionLong;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionShort;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class FirstGeoHashGroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "first(G)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function function = args.getQuick(0);
        int type = function.getType();
        switch (ColumnType.tagOf(type)) {
            case 14: {
                return new FirstGeoHashGroupByFunctionByte(type, function);
            }
            case 15: {
                return new FirstGeoHashGroupByFunctionShort(type, function);
            }
            case 16: {
                return new FirstGeoHashGroupByFunctionInt(type, function);
            }
        }
        return new FirstGeoHashGroupByFunctionLong(type, function);
    }
}

