/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.properties;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.properties.StandardSensitivePropertyProviderFactory;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.properties.ProtectedNiFiRegistryProperties;
import org.apache.nifi.registry.properties.util.NiFiRegistryBootstrapUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiRegistryPropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(NiFiRegistryPropertiesLoader.class);
    private String keyHex;
    private SensitivePropertyProviderFactory sensitivePropertyProviderFactory;

    public static NiFiRegistryPropertiesLoader withKey(String keyHex) {
        NiFiRegistryPropertiesLoader loader = new NiFiRegistryPropertiesLoader();
        loader.setKeyHex(keyHex);
        return loader;
    }

    public void setKeyHex(String keyHex) {
        if (this.keyHex != null && !this.keyHex.trim().isEmpty()) {
            throw new RuntimeException("Cannot overwrite an existing key");
        }
        this.keyHex = keyHex;
    }

    private SensitivePropertyProviderFactory getSensitivePropertyProviderFactory() {
        if (this.sensitivePropertyProviderFactory == null) {
            this.sensitivePropertyProviderFactory = StandardSensitivePropertyProviderFactory.withKeyAndBootstrapSupplier((String)this.keyHex, () -> {
                try {
                    return NiFiRegistryBootstrapUtils.loadBootstrapProperties();
                }
                catch (IOException e) {
                    logger.debug("Cannot read bootstrap.conf -- file is missing or not readable.  Defaulting to empty bootstrap.conf");
                    return BootstrapProperties.EMPTY;
                }
            });
        }
        return this.sensitivePropertyProviderFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ProtectedNiFiRegistryProperties readProtectedPropertiesFromDisk(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            String path = file == null ? "missing file" : file.getAbsolutePath();
            logger.error("Cannot read from '{}' -- file is missing or not readable", (Object)path);
            throw new IllegalArgumentException("NiFi Registry properties file missing or unreadable");
        }
        Properties rawProperties = new Properties();
        try (FileReader reader = new FileReader(file);){
            rawProperties.load(reader);
            NiFiRegistryProperties innerProperties = new NiFiRegistryProperties(rawProperties);
            logger.info("Loaded {} properties from {}", (Object)rawProperties.size(), (Object)file.getAbsolutePath());
            ProtectedNiFiRegistryProperties protectedNiFiRegistryProperties = new ProtectedNiFiRegistryProperties(innerProperties);
            return protectedNiFiRegistryProperties;
        }
        catch (IOException ioe) {
            logger.error("Cannot load properties file due to " + ioe.getLocalizedMessage());
            throw new RuntimeException("Cannot load properties file due to " + ioe.getLocalizedMessage(), ioe);
        }
    }

    public NiFiRegistryProperties load(File file) {
        ProtectedNiFiRegistryProperties protectedNiFiProperties = this.readProtectedPropertiesFromDisk(file);
        if (protectedNiFiProperties.hasProtectedKeys()) {
            logger.warn("Support for encrypted application properties is deprecated for removal in NiFi 2.0.0");
            Security.addProvider((Provider)new BouncyCastleProvider());
            this.getSensitivePropertyProviderFactory().getSupportedProviders().forEach(protectedNiFiProperties::addSensitivePropertyProvider);
        }
        return protectedNiFiProperties.getUnprotectedProperties();
    }

    public NiFiRegistryProperties load(String path) {
        if (path != null && !path.trim().isEmpty()) {
            return this.load(new File(path));
        }
        logger.error("Cannot read from '{}' -- path is null or empty", (Object)path);
        throw new IllegalArgumentException("NiFi Registry properties file path empty or null");
    }
}

