/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.registration;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.oidc.OidcConfigurationException;
import org.apache.nifi.web.security.oidc.OidcUrlPath;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.registration.ClientRegistrationProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.web.client.RestOperations;

public class StandardClientRegistrationProvider
implements ClientRegistrationProvider {
    private static final String REGISTRATION_REDIRECT_URI = String.format("{baseUrl}%s", OidcUrlPath.CALLBACK.getPath());
    private static final Set<String> STANDARD_SCOPES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("openid", "email")));
    private final NiFiProperties properties;
    private final RestOperations restOperations;

    public StandardClientRegistrationProvider(NiFiProperties properties, RestOperations restOperations) {
        this.properties = Objects.requireNonNull(properties, "Properties required");
        this.restOperations = Objects.requireNonNull(restOperations, "REST Operations required");
    }

    @Override
    public ClientRegistration getClientRegistration() {
        String clientId = this.properties.getOidcClientId();
        String clientSecret = this.properties.getOidcClientSecret();
        OIDCProviderMetadata providerMetadata = this.getProviderMetadata();
        ClientAuthenticationMethod clientAuthenticationMethod = this.getClientAuthenticationMethod(providerMetadata.getTokenEndpointAuthMethods());
        String issuerUri = providerMetadata.getIssuer().getValue();
        String tokenUri = providerMetadata.getTokenEndpointURI().toASCIIString();
        LinkedHashMap configurationMetadata = new LinkedHashMap(providerMetadata.toJSONObject());
        String authorizationUri = providerMetadata.getAuthorizationEndpointURI().toASCIIString();
        String jwkSetUri = providerMetadata.getJWKSetURI().toASCIIString();
        String userInfoUri = providerMetadata.getUserInfoEndpointURI().toASCIIString();
        LinkedHashSet<String> scope = new LinkedHashSet<String>(STANDARD_SCOPES);
        List additionalScopes = this.properties.getOidcAdditionalScopes();
        scope.addAll(additionalScopes);
        return ClientRegistration.withRegistrationId((String)OidcRegistrationProperty.REGISTRATION_ID.getProperty()).clientId(clientId).clientSecret(clientSecret).clientName(issuerUri).issuerUri(issuerUri).tokenUri(tokenUri).authorizationUri(authorizationUri).jwkSetUri(jwkSetUri).userInfoUri(userInfoUri).providerConfigurationMetadata(configurationMetadata).redirectUri(REGISTRATION_REDIRECT_URI).scope(scope).userNameAttributeName("sub").clientAuthenticationMethod(clientAuthenticationMethod).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).build();
    }

    private OIDCProviderMetadata getProviderMetadata() {
        String metadataObject;
        String discoveryUrl = this.properties.getOidcDiscoveryUrl();
        try {
            metadataObject = (String)this.restOperations.getForObject(discoveryUrl, String.class, new Object[0]);
        }
        catch (RuntimeException e) {
            String message = String.format("OpenID Connect Metadata URL [%s] retrieval failed", discoveryUrl);
            throw new OidcConfigurationException(message, e);
        }
        try {
            return OIDCProviderMetadata.parse((String)metadataObject);
        }
        catch (ParseException e) {
            throw new OidcConfigurationException("OpenID Connect Metadata parsing failed", e);
        }
    }

    private ClientAuthenticationMethod getClientAuthenticationMethod(List<com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod> metadataAuthMethods) {
        ClientAuthenticationMethod clientAuthenticationMethod = metadataAuthMethods == null || metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.CLIENT_SECRET_BASIC) ? ClientAuthenticationMethod.CLIENT_SECRET_BASIC : (metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.CLIENT_SECRET_POST) ? ClientAuthenticationMethod.CLIENT_SECRET_POST : (metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.NONE) ? ClientAuthenticationMethod.NONE : ClientAuthenticationMethod.CLIENT_SECRET_BASIC));
        return clientAuthenticationMethod;
    }
}

