/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import org.apache.nifi.controller.queue.FlowFileQueueSize;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.queue.RemoteQueuePartitionDiagnostics;

public class StandardRemoteQueuePartitionDiagnostics
implements RemoteQueuePartitionDiagnostics {
    private final String nodeId;
    private final FlowFileQueueSize queueSize;

    public StandardRemoteQueuePartitionDiagnostics(String nodeId, FlowFileQueueSize queueSize) {
        this.nodeId = nodeId;
        this.queueSize = queueSize;
    }

    public String getNodeIdentifier() {
        return this.nodeId;
    }

    public QueueSize getUnacknowledgedQueueSize() {
        return new QueueSize(this.queueSize.getUnacknowledgedCount(), (long)this.queueSize.getUnacknowledgedCount());
    }

    public QueueSize getActiveQueueSize() {
        return new QueueSize(this.queueSize.getActiveCount(), this.queueSize.getActiveBytes());
    }

    public QueueSize getSwapQueueSize() {
        return new QueueSize(this.queueSize.getSwappedCount(), this.queueSize.getSwappedBytes());
    }

    public int getSwapFileCount() {
        return this.queueSize.getSwapFileCount();
    }
}

