/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.AbstractMSequence;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.WaitStrategy;
import io.questdb.std.Os;

public class MCSequence
extends AbstractMSequence {
    public MCSequence(int cycle) {
        this(cycle, null);
    }

    public MCSequence(int cycle, WaitStrategy waitStrategy) {
        super(cycle, waitStrategy);
    }

    public <T> void consumeAll(RingQueue<T> queue, QueueConsumer<T> consumer) {
        long cursor;
        do {
            if ((cursor = this.next()) > -1L) {
                consumer.consume(queue.get(cursor));
                this.done(cursor);
                continue;
            }
            if (cursor != -2L) continue;
            Os.pause();
        } while (cursor != -1L);
    }

    @Override
    public long next() {
        long current = this.value;
        long next = current + 1L;
        long cached = this.cache;
        if (next > cached) {
            long avail = this.barrier.availableIndex(next);
            if (avail > cached) {
                this.setCacheFenced(avail);
                if (next > avail) {
                    return -1L;
                }
            } else {
                return -1L;
            }
        }
        return this.casValue(current, next) ? next : -2L;
    }
}

