/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util;

import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.FlowFileFilter;

public class FlowFileFilters {
    public static FlowFileFilter newSizeBasedFilter(double maxSize, DataUnit unit, final int maxCount) {
        final double maxBytes = DataUnit.B.convert(maxSize, unit);
        return new FlowFileFilter(){
            int count = 0;
            long size = 0L;

            public FlowFileFilter.FlowFileFilterResult filter(FlowFile flowFile) {
                ++this.count;
                this.size += flowFile.getSize();
                if (this.count == 1) {
                    return FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE;
                }
                if ((double)this.size > maxBytes || this.count > maxCount) {
                    return FlowFileFilter.FlowFileFilterResult.REJECT_AND_TERMINATE;
                }
                return FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE;
            }
        };
    }
}

