/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.diff.VersionedFlowDifference;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.registry.VersionedFlowDifferenceResult;

public class DiffFlowVersions
extends AbstractNiFiRegistryCommand<VersionedFlowDifferenceResult> {
    public DiffFlowVersions() {
        super("diff-flow-versions", VersionedFlowDifferenceResult.class);
    }

    @Override
    public String getDescription() {
        return "Shows the differences between two versions of a flow.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.FLOW_ID.createOption());
        this.addOption(CommandOption.FLOW_VERSION_1.createOption());
        this.addOption(CommandOption.FLOW_VERSION_2.createOption());
    }

    @Override
    public VersionedFlowDifferenceResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        String flowId = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        Integer version1 = this.getRequiredIntArg(properties, CommandOption.FLOW_VERSION_1);
        Integer version2 = this.getRequiredIntArg(properties, CommandOption.FLOW_VERSION_2);
        FlowClient flowClient = client.getFlowClient();
        VersionedFlow flow = flowClient.get(flowId);
        VersionedFlowDifference flowDifference = flowClient.diff(flow.getBucketIdentifier(), flowId, version1, version2);
        return new VersionedFlowDifferenceResult(this.getResultType(properties), flowDifference);
    }
}

