/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.util;

import java.io.IOException;
import java.io.Writer;

public class JsonStreamWriter {
    private final Writer writer;

    public JsonStreamWriter(Writer writer) {
        this.writer = writer;
    }

    public JsonStreamWriter beginObject() throws IOException {
        this.writer.append('{');
        return this;
    }

    public JsonStreamWriter endObject() throws IOException {
        this.writer.append('}');
        return this;
    }

    public JsonStreamWriter beginArray() throws IOException {
        this.writer.append('[');
        return this;
    }

    public JsonStreamWriter endArray() throws IOException {
        this.writer.append(']');
        return this;
    }

    public JsonStreamWriter name(String name) throws IOException {
        this.writer.append('\"').append(name).append('\"').append(':');
        return this;
    }

    public JsonStreamWriter unquotedValue(String value) throws IOException {
        this.writer.append(value == null ? "null" : value);
        return this;
    }

    public JsonStreamWriter stringValueRaw(String value) throws IOException {
        if (value == null) {
            this.writer.append("null");
        } else {
            this.writer.append('\"').append(value).append('\"');
        }
        return this;
    }

    public JsonStreamWriter stringValue(String value) throws IOException {
        if (value == null) {
            this.writer.append("null");
        } else {
            this.writer.append('\"');
            this.escape(value);
            this.writer.append('\"');
        }
        return this;
    }

    public JsonStreamWriter namedStringValueRaw(String name, String value) throws IOException {
        this.name(name);
        this.stringValueRaw(value);
        return this;
    }

    public JsonStreamWriter namedStringValue(String name, String value) throws IOException {
        this.name(name);
        this.stringValue(value);
        return this;
    }

    public JsonStreamWriter separator() throws IOException {
        this.writer.append(',');
        return this;
    }

    protected void escape(String value) throws IOException {
        block10: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\\': {
                    this.writer.append('\\').append(c);
                    continue block10;
                }
                case '\"': {
                    this.writer.append('\\').append(c);
                    continue block10;
                }
                case '\b': {
                    this.writer.append('\\').append('b');
                    continue block10;
                }
                case '\t': {
                    this.writer.append('\\').append('t');
                    continue block10;
                }
                case '\n': {
                    this.writer.append('\\').append('n');
                    continue block10;
                }
                case '\f': {
                    this.writer.append('\\').append('f');
                    continue block10;
                }
                case '\r': {
                    this.writer.append('\\').append('r');
                    continue block10;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    int lastHexDigit = c % 16;
                    this.writer.append('\\').append('u').append('0').append('0').append(c >= '\u0010' ? (char)'1' : '0').append((char)((lastHexDigit > 9 ? 65 : 48) + lastHexDigit % 10));
                    continue block10;
                }
                default: {
                    this.writer.append(c);
                }
            }
        }
    }
}

