/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientLink;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.serialization.ODataSerializer;
import org.apache.olingo.client.api.serialization.ODataSerializerException;
import org.apache.olingo.client.api.serialization.ODataWriter;
import org.apache.olingo.commons.api.format.ContentType;

public class ODataWriterImpl
implements ODataWriter {
    protected final ODataClient client;

    public ODataWriterImpl(ODataClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream writeEntities(Collection<ClientEntity> entities, ContentType contentType) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            ODataSerializer serializer = this.client.getSerializer(contentType);
            for (ClientEntity entity : entities) {
                serializer.write((Writer)writer, this.client.getBinder().getEntity(entity));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    @Override
    public InputStream writeEntity(ClientEntity entity, ContentType contentType) throws ODataSerializerException {
        return this.writeEntities(Collections.singleton(entity), contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream writeProperty(ClientProperty property, ContentType contentType) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            this.client.getSerializer(contentType).write((Writer)writer, this.client.getBinder().getProperty(property));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream writeLink(ClientLink link, ContentType contentType) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            this.client.getSerializer(contentType).write((Writer)writer, this.client.getBinder().getLink(link));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream writeReference(ResWrap<URI> reference, ContentType contenType) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            this.client.getSerializer(contenType).write((Writer)writer, reference);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }
}

